(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    257486,       6956]*)
(*NotebookOutlinePosition[    259686,       7021]*)
(*  CellTagsIndexPosition[    259538,       7013]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["\<\
Chapter 9
Higher Approximations of Continuous Systems Having Two-to-One Internal \
Resonances\
\>", "Title",
  TextAlignment->Left,
  TextJustification->0],

Cell[TextData[{
  "In this chapter, we use the method of multiple scales to determine \
second-order uniform asymptotic expansions of the solutions of continuous \
systems with quadratic and cubic nonlinearities possessing ",
  StyleBox["two-to-one internal resonances",
    FontColor->RGBColor[0, 0, 1]],
  ". Higher-order treatments of such systems lead to inconsistent results if \
the time derivatives in their governing equations are expressed in \
second-order rather than first-order form. Therefore, we express the time \
derivatives in the governing equations in first-order form before treating \
them with the method of multiple scales. We describe the methodology using \
two examples: two-mode interactions in hinged-hinged buckled beams and \
four-mode interactions in suspended cables."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell["Preliminaries", "Section",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(Off[General::spell1, Integrate::gener]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "To determine second-order uniform asymptotic expansions of the solutions \
of  buckled beams and suspended cables by using the method of multiple \
scales, taking into account two-to-one internal resonances, we introduce the \
three time scales ",
  Cell[BoxData[
      \(TraditionalForm\`T\_0 = t\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`T\_1 = \[Epsilon]\ t\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`T\_2 = \(\[Epsilon]\^2\) t\)]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon]\)]],
  " is a small nondimensional parameter and the order of the amplitude of \
oscillations. Moreover, we symbolize these scales according to"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(Needs["\<Utilities`Notation`\>"]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{"Symbolize", "[", 
        TagBox[\(T\_0\),
          NotationBoxTag,
          Editable->True], "]"}], ";", 
      RowBox[{"Symbolize", "[", 
        TagBox[\(T\_1\),
          NotationBoxTag,
          Editable->True], "]"}], ";", 
      RowBox[{"Symbolize", "[", 
        TagBox[\(T\_2\),
          NotationBoxTag,
          Editable->True], "]"}], ";"}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(timeScales = {T\_0, T\_1, T\_2}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "In terms of the time scales ",
  Cell[BoxData[
      \(TraditionalForm\`T\_0\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`T\_1\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`T\_2\)]],
  ", the time derivatives can be expressed as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(dt[0]\)[expr_] := expr; 
    \(dt[1]\)[expr_] := 
      Sum[\[Epsilon]\^i\ D[expr, timeScales[\([i + 1]\)]], {i, 0, 2}]; \)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "To speed up manipulations of the integrals involved in the governing \
equations with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", we introduce the rules"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(intRule1 = {int[fun_, arg2__] :> int[Expand[fun], arg2]}; \n
    intRule2 = {int[a_ + b_, arg2__] :> int[a, arg2] + int[b, arg2], 
        int[\[Epsilon]\^n_. \ fun_, arg2__] :> \[Epsilon]\^n\ int[fun, arg2], 
        int[a_\ fun_, a1_, b1___] :> 
          a\ int[fun, a1, b1] /; FreeQ[a, First[a1]], 
        int[int[a1_, a2_]\ fun_. , a3__] :> 
          int[a1, a2]\ int[fun, a3] /; FreeQ[Rest[a2], First[a2]]}; \)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
In the ensuing analysis, we express the solutions in terms of \
complex-variable functions and hence we introduce the complex-conjugate \
rule\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(conjugateRule = {A\_s_ :> A\&_\_s, A\&_\_s_ :> A\_s, 
        Complex[m_, n_] :> Complex[m, \(-n\)]}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
To display the outputs in easily read expressions, we introduce the rules\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(displayRule = {
        \(\(Derivative[a_, b__]\)[w_\_i__]\)[_, T\_0, __] :> 
          SequenceForm[
            If[arg1 = 
                Times\ @@\ MapIndexed[D\_\(#2[\([1]\)] - 1\)\%#1\ &, {b}]; 
              arg1 =!= 1, arg1, "\<\>"], 
            w\_i\^SequenceForm\ @@\ Table["\<'\>", {a}]], 
        \(\(Derivative[a__]\)[A\_i__]\)[__] :> 
          SequenceForm[Times\ @@\ MapIndexed[D\_\(#2[\([1]\)]\)\%#1\ &, {a}], 
            A\_i], \(\(Derivative[a__]\)[A\&_\_i__]\)[__] :> 
          SequenceForm[Times\ @@\ MapIndexed[D\_\(#2[\([1]\)]\)\%#1\ &, {a}], 
            A\&_\_i], w_\_i__[_, T\_0, __] -> w\_i, A\_i__[__] -> A\_i, 
        A\&_\_i__[__] -> A\&_\_i, 
        Exp[a_.  + b_. \ Complex[0, m_]\ T\_0 + 
              c_. \ Complex[0, n_]\ T\_0] -> 
          Exp[a + \((m*b + n*c)\) I\ T\_0]}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell["9.1 Two-Mode Interactions in Buckled Beams", "Section",
  CellMargins->{{Inherited, 17.4375}, {Inherited, Inherited}},
  Evaluatable->False,
  TextAlignment->Left,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],

Cell["\<\
In this section, we consider the nonlinear response of a hinged-hinged \
buckled beam possessing a two-to-one internal resonance to a principal \
parametric resonance of the higher mode. The analysis assumes a unimodal \
static buckled deflection. The nondimensional equation of motion is (Section \
8.1.1)\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{"EOM", "=", 
        RowBox[{
          RowBox[{
            RowBox[{
            \(u\_\(t, t\)\), "+", \(u\_\(x, x, x, x\)\), "+", 
              \(P\_k\ u\_\(x, x\)\), "-", 
              RowBox[{"2", \(b\^2\), " ", "\[Alpha]", " ", 
                RowBox[{"(", 
                  RowBox[{\(\[Integral]\_0\%1\), 
                    RowBox[{
                      RowBox[{\(u\_x\), " ", 
                        RowBox[{
                          SubsuperscriptBox["\[Phi]", "k", "\[Prime]",
                            MultilineFunction->None], "[", "x", "]"}]}], 
                      \(\[DifferentialD]x\)}]}], ")"}], " ", 
                RowBox[{
                  SubsuperscriptBox["\[Phi]", "k", "\[DoublePrime]",
                    MultilineFunction->None], "[", "x", "]"}]}]}], "==", 
            RowBox[{\(\(-c\)\ u\_t\), "+", 
              RowBox[{
              "b", " ", "\[Alpha]", " ", 
                \((\[Integral]\_0\%1\( u\_x\%2\) \[DifferentialD]x)\), " ", 
                RowBox[{
                  SubsuperscriptBox["\[Phi]", "k", "\[DoublePrime]",
                    MultilineFunction->None], "[", "x", "]"}]}], "+", 
              RowBox[{"2", "b", " ", "\[Alpha]", " ", 
                RowBox[{"(", 
                  RowBox[{\(\[Integral]\_0\%1\), 
                    RowBox[{
                      RowBox[{\(u\_x\), " ", 
                        RowBox[{
                          SubsuperscriptBox["\[Phi]", "k", "\[Prime]",
                            MultilineFunction->None], "[", "x", "]"}]}], 
                      \(\[DifferentialD]x\)}]}], ")"}], " ", 
                \(u\_\(x, x\)\)}], "+", 
              \(\[Alpha]\ 
                \((\[Integral]\_0\%1\( u\_x\%2\) \[DifferentialD]x)\)\ 
                u\_\(x, x\)\), "+", 
              \(Cos[t\ \[CapitalOmega]]\ f\ u\_\(x, x\)\), "+", 
              RowBox[{"b", " ", \(Cos[t\ \[CapitalOmega]]\), " ", "f", " ", 
                RowBox[{
                  SubsuperscriptBox["\[Phi]", "k", "\[DoublePrime]",
                    MultilineFunction->None], "[", "x", "]"}]}]}]}], "/.", 
          \(u\_m__ :> \[PartialD]\_m u[x, t]\)}]}], ";"}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["and the associated boundary conditions are", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{"BC", "=", 
        RowBox[{"{", 
          RowBox[{\(u[0, t] == 0\), ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((2, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(0, t\), "]"}], "==", 
              "0"}], ",", \(u[1, t] == 0\), ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((2, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(1, t\), "]"}], "==", 
              "0"}]}], "}"}]}], ";"}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`P\_k\)]],
  " is the ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  "th critical Euler buckling load, ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_k\)]],
  " is the ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  "th buckling mode shape, and ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  " is the nondimensional buckling level."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Because the two-to-one internal resonance is activated by the quadratic \
nonlinearities, as indicated in Chapter 5, second- and higher-order \
treatments of such systems lead to inconsistent results if the time \
derivatives in their governing equations are expressed in second-order rather \
than first-order form. Therefore, we express the time derivatives in \
first-order form by letting ",
  Cell[BoxData[
      \(TraditionalForm\`v[x, t] == \[PartialD]\_t u[x, t]\)]],
  ", adding it to ",
  StyleBox["EOM",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", and obtaining"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(EOM1 = {\[PartialD]\_t u[x, t] - v[x, t] == 0, 
        EOM /. \[PartialD]\_\(t, t\)u[x, t] -> \[PartialD]\_t v[x, t]}; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "We use the method of multiple scales to directly attack ",
  StyleBox["EOM1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["BC",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ". To transform the time derivatives in ",
  StyleBox["EOM1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in terms of the scales ",
  Cell[BoxData[
      \(TraditionalForm\`T\_0\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`T\_1\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`T\_2\)]],
  ", we define"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(multiScales = {u[x_, t] -> u[x, T\_0, T\_1, T\_2], 
        v[x, t] -> v[x, T\_0, T\_1, T\_2], 
        \(\(Derivative[m_, n_]\)[u_]\)[x_, t] -> 
          \(dt[n]\)[D[u[x, T\_0, T\_1, T\_2], {x, m}]], t -> T\_0}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Then, we seek a second-order approximate solution of ",
  StyleBox["EOM1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["BC",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in the form"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(solRule = 
      h : u | v -> 
        \((Evaluate[Sum[\[Epsilon]\^j\ h\_j[#1, #2, #3, #4], {j, 3}]]\ &)\); 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`#1\)]],
  " stands for ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`#2\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`#3\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`#4\)]],
  " stand for ",
  Cell[BoxData[
      \(TraditionalForm\`T\_0, T\_1\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`T\_2\)]],
  ", respectively."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
We consider the case of a two-to-one internal resonance between the lowest \
two modes and a principal parametric resonance of the second mode; that is,\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(omgList = {\[Omega]\_1, \[Omega]\_2}; \n
    ResonanceConds = {
        \[Omega]\_2 == 2  \[Omega]\_1 + \[Epsilon]\ \[Sigma]\_1, 
        \[CapitalOmega] == 2  \[Omega]\_2 + \[Epsilon]\ \[Sigma]\_2}; \)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "where the ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\_i\)]],
  " are detuning parameters that describe the nearness of the resonances. \
Because the influence of the two-to-one internal resonance appears at ",
  StyleBox["O",
    FontSlant->"Italic"],
  "(\[Epsilon]), we scale the damping and forcing terms as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(scaling = {c -> 2  \[Epsilon]\ \[Mu], f -> \[Epsilon]\ f}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting ",
  StyleBox["multiScales",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", ",
  StyleBox["solRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", and ",
  StyleBox["scaling",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["EOM1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", expanding the result for small \[Epsilon], and discarding terms of order \
higher than ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon]\^3\)]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(eq91a = 
      \((\(\(\(\(\(\(EOM1 /. Integrate -> int\) /. multiScales\) /. solRule
                      \) /. scaling\) /. intRule1\) //. intRule2 // TrigToExp
              \) // ExpandAll)\) /. \[Epsilon]\^\(n_ /; n > 3\) -> 0; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[
"Equating coefficients of like powers of \[Epsilon], we obtain"], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(eqEps = 
      \(\(Thread[CoefficientList[Subtract\ @@\ #, \[Epsilon]] == 0]\ &\)\ /@\ 
            eq91a // Transpose\) // Rest; \neqEps /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                InterpretationBox[
                  RowBox[{\(D\_0\), "\[InvisibleSpace]", 
                    SubsuperscriptBox["u", "1", 
                      InterpretationBox["\[Null]",
                        SequenceForm[ ],
                        Editable->False]]}],
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Power[ 
                      Subscript[ u, 1], 
                      SequenceForm[ ]]],
                  Editable->False], "-", \(v\_1\)}], "==", "0"}], ",", 
            RowBox[{
              RowBox[{
                InterpretationBox[
                  RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                    SubsuperscriptBox["u", "1", 
                      
                      InterpretationBox[
                        \("'"\[InvisibleSpace]"'"\[InvisibleSpace]"'"\
\[InvisibleSpace]"'"\),
                        SequenceForm[ "'", "'", "'", "'"],
                        Editable->False]]}],
                  SequenceForm[ "", 
                    Power[ 
                      Subscript[ u, 1], 
                      SequenceForm[ "'", "'", "'", "'"]]],
                  Editable->False], "+", 
                InterpretationBox[
                  RowBox[{\(D\_0\), "\[InvisibleSpace]", 
                    SubsuperscriptBox["v", "1", 
                      InterpretationBox["\[Null]",
                        SequenceForm[ ],
                        Editable->False]]}],
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Power[ 
                      Subscript[ v, 1], 
                      SequenceForm[ ]]],
                  Editable->False], "+", 
                RowBox[{
                  RowBox[{"(", 
                    InterpretationBox[
                      RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                        SubsuperscriptBox["u", "1", 
                          InterpretationBox[\("'"\[InvisibleSpace]"'"\),
                            SequenceForm[ "'", "'"],
                            Editable->False]]}],
                      SequenceForm[ "", 
                        Power[ 
                          Subscript[ u, 1], 
                          SequenceForm[ "'", "'"]]],
                      Editable->False], ")"}], " ", \(P\_k\)}], "-", 
                RowBox[{
                \(1\/2\), " ", "b", " ", 
                  \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\), " ", "f", " ", 
                  RowBox[{
                    SubsuperscriptBox["\[Phi]", "k", "\[DoublePrime]",
                      MultilineFunction->None], "[", "x", "]"}]}], "-", 
                RowBox[{
                \(1\/2\), " ", "b", " ", \(E\^\(I\ T\_0\ \[CapitalOmega]\)\), 
                  " ", "f", " ", 
                  RowBox[{
                    SubsuperscriptBox["\[Phi]", "k", "\[DoublePrime]",
                      MultilineFunction->None], "[", "x", "]"}]}], "-", 
                RowBox[{"2", " ", \(b\^2\), " ", "\[Alpha]", " ", 
                  RowBox[{"int", "[", 
                    RowBox[{
                      RowBox[{
                        RowBox[{"(", 
                          InterpretationBox[
                            RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                              SubsuperscriptBox["u", "1", 
                                InterpretationBox["\<\"'\"\>",
                                  SequenceForm[ "'"],
                                  Editable->False]]}],
                            SequenceForm[ "", 
                              Power[ 
                                Subscript[ u, 1], 
                                SequenceForm[ "'"]]],
                            Editable->False], ")"}], " ", 
                        RowBox[{
                          SubsuperscriptBox["\[Phi]", "k", "\[Prime]",
                            MultilineFunction->None], "[", "x", "]"}]}], ",", 
                      \({x, 0, 1}\)}], "]"}], " ", 
                  RowBox[{
                    SubsuperscriptBox["\[Phi]", "k", "\[DoublePrime]",
                      MultilineFunction->None], "[", "x", "]"}]}]}], "==", 
              "0"}]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                InterpretationBox[
                  RowBox[{\(D\_0\), "\[InvisibleSpace]", 
                    SubsuperscriptBox["u", "2", 
                      InterpretationBox["\[Null]",
                        SequenceForm[ ],
                        Editable->False]]}],
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Power[ 
                      Subscript[ u, 2], 
                      SequenceForm[ ]]],
                  Editable->False], "+", 
                InterpretationBox[
                  RowBox[{\(D\_1\), "\[InvisibleSpace]", 
                    SubsuperscriptBox["u", "1", 
                      InterpretationBox["\[Null]",
                        SequenceForm[ ],
                        Editable->False]]}],
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Power[ 
                      Subscript[ u, 1], 
                      SequenceForm[ ]]],
                  Editable->False], "-", \(v\_2\)}], "==", "0"}], ",", 
            RowBox[{
              RowBox[{
                RowBox[{
                \(-\(1\/2\)\), " ", \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\), 
                  " ", "f", " ", 
                  RowBox[{"(", 
                    InterpretationBox[
                      RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                        SubsuperscriptBox["u", "1", 
                          InterpretationBox[\("'"\[InvisibleSpace]"'"\),
                            SequenceForm[ "'", "'"],
                            Editable->False]]}],
                      SequenceForm[ "", 
                        Power[ 
                          Subscript[ u, 1], 
                          SequenceForm[ "'", "'"]]],
                      Editable->False], ")"}]}], "-", 
                RowBox[{
                \(1\/2\), " ", \(E\^\(I\ T\_0\ \[CapitalOmega]\)\), " ", "f", 
                  " ", 
                  RowBox[{"(", 
                    InterpretationBox[
                      RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                        SubsuperscriptBox["u", "1", 
                          InterpretationBox[\("'"\[InvisibleSpace]"'"\),
                            SequenceForm[ "'", "'"],
                            Editable->False]]}],
                      SequenceForm[ "", 
                        Power[ 
                          Subscript[ u, 1], 
                          SequenceForm[ "'", "'"]]],
                      Editable->False], ")"}]}], "-", 
                RowBox[{"2", " ", "b", " ", "\[Alpha]", " ", 
                  RowBox[{"int", "[", 
                    RowBox[{
                      RowBox[{
                        RowBox[{"(", 
                          InterpretationBox[
                            RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                              SubsuperscriptBox["u", "1", 
                                InterpretationBox["\<\"'\"\>",
                                  SequenceForm[ "'"],
                                  Editable->False]]}],
                            SequenceForm[ "", 
                              Power[ 
                                Subscript[ u, 1], 
                                SequenceForm[ "'"]]],
                            Editable->False], ")"}], " ", 
                        RowBox[{
                          SubsuperscriptBox["\[Phi]", "k", "\[Prime]",
                            MultilineFunction->None], "[", "x", "]"}]}], ",", 
                      \({x, 0, 1}\)}], "]"}], " ", 
                  RowBox[{"(", 
                    InterpretationBox[
                      RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                        SubsuperscriptBox["u", "1", 
                          InterpretationBox[\("'"\[InvisibleSpace]"'"\),
                            SequenceForm[ "'", "'"],
                            Editable->False]]}],
                      SequenceForm[ "", 
                        Power[ 
                          Subscript[ u, 1], 
                          SequenceForm[ "'", "'"]]],
                      Editable->False], ")"}]}], "+", 
                InterpretationBox[
                  RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                    SubsuperscriptBox["u", "2", 
                      
                      InterpretationBox[
                        \("'"\[InvisibleSpace]"'"\[InvisibleSpace]"'"\
\[InvisibleSpace]"'"\),
                        SequenceForm[ "'", "'", "'", "'"],
                        Editable->False]]}],
                  SequenceForm[ "", 
                    Power[ 
                      Subscript[ u, 2], 
                      SequenceForm[ "'", "'", "'", "'"]]],
                  Editable->False], "+", 
                RowBox[{"2", " ", "\[Mu]", " ", 
                  RowBox[{"(", 
                    InterpretationBox[
                      RowBox[{\(D\_0\), "\[InvisibleSpace]", 
                        SubsuperscriptBox["u", "1", 
                          InterpretationBox["\[Null]",
                            SequenceForm[ ],
                            Editable->False]]}],
                      SequenceForm[ 
                        Subscript[ D, 0], 
                        Power[ 
                          Subscript[ u, 1], 
                          SequenceForm[ ]]],
                      Editable->False], ")"}]}], "+", 
                InterpretationBox[
                  RowBox[{\(D\_0\), "\[InvisibleSpace]", 
                    SubsuperscriptBox["v", "2", 
                      InterpretationBox["\[Null]",
                        SequenceForm[ ],
                        Editable->False]]}],
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Power[ 
                      Subscript[ v, 2], 
                      SequenceForm[ ]]],
                  Editable->False], "+", 
                InterpretationBox[
                  RowBox[{\(D\_1\), "\[InvisibleSpace]", 
                    SubsuperscriptBox["v", "1", 
                      InterpretationBox["\[Null]",
                        SequenceForm[ ],
                        Editable->False]]}],
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Power[ 
                      Subscript[ v, 1], 
                      SequenceForm[ ]]],
                  Editable->False], "+", 
                RowBox[{
                  RowBox[{"(", 
                    InterpretationBox[
                      RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                        SubsuperscriptBox["u", "2", 
                          InterpretationBox[\("'"\[InvisibleSpace]"'"\),
                            SequenceForm[ "'", "'"],
                            Editable->False]]}],
                      SequenceForm[ "", 
                        Power[ 
                          Subscript[ u, 2], 
                          SequenceForm[ "'", "'"]]],
                      Editable->False], ")"}], " ", \(P\_k\)}], "-", 
                RowBox[{"b", " ", "\[Alpha]", " ", 
                  RowBox[{"int", "[", 
                    RowBox[{
                      SuperscriptBox[
                        RowBox[{"(", 
                          InterpretationBox[
                            RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                              SubsuperscriptBox["u", "1", 
                                InterpretationBox["\<\"'\"\>",
                                  SequenceForm[ "'"],
                                  Editable->False]]}],
                            SequenceForm[ "", 
                              Power[ 
                                Subscript[ u, 1], 
                                SequenceForm[ "'"]]],
                            Editable->False], ")"}], "2"], ",", 
                      \({x, 0, 1}\)}], "]"}], " ", 
                  RowBox[{
                    SubsuperscriptBox["\[Phi]", "k", "\[DoublePrime]",
                      MultilineFunction->None], "[", "x", "]"}]}], "-", 
                RowBox[{"2", " ", \(b\^2\), " ", "\[Alpha]", " ", 
                  RowBox[{"int", "[", 
                    RowBox[{
                      RowBox[{
                        RowBox[{"(", 
                          InterpretationBox[
                            RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                              SubsuperscriptBox["u", "2", 
                                InterpretationBox["\<\"'\"\>",
                                  SequenceForm[ "'"],
                                  Editable->False]]}],
                            SequenceForm[ "", 
                              Power[ 
                                Subscript[ u, 2], 
                                SequenceForm[ "'"]]],
                            Editable->False], ")"}], " ", 
                        RowBox[{
                          SubsuperscriptBox["\[Phi]", "k", "\[Prime]",
                            MultilineFunction->None], "[", "x", "]"}]}], ",", 
                      \({x, 0, 1}\)}], "]"}], " ", 
                  RowBox[{
                    SubsuperscriptBox["\[Phi]", "k", "\[DoublePrime]",
                      MultilineFunction->None], "[", "x", "]"}]}]}], "==", 
              "0"}]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                InterpretationBox[
                  RowBox[{\(D\_0\), "\[InvisibleSpace]", 
                    SubsuperscriptBox["u", "3", 
                      InterpretationBox["\[Null]",
                        SequenceForm[ ],
                        Editable->False]]}],
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Power[ 
                      Subscript[ u, 3], 
                      SequenceForm[ ]]],
                  Editable->False], "+", 
                InterpretationBox[
                  RowBox[{\(D\_1\), "\[InvisibleSpace]", 
                    SubsuperscriptBox["u", "2", 
                      InterpretationBox["\[Null]",
                        SequenceForm[ ],
                        Editable->False]]}],
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Power[ 
                      Subscript[ u, 2], 
                      SequenceForm[ ]]],
                  Editable->False], "+", 
                InterpretationBox[
                  RowBox[{\(D\_2\), "\[InvisibleSpace]", 
                    SubsuperscriptBox["u", "1", 
                      InterpretationBox["\[Null]",
                        SequenceForm[ ],
                        Editable->False]]}],
                  SequenceForm[ 
                    Subscript[ D, 2], 
                    Power[ 
                      Subscript[ u, 1], 
                      SequenceForm[ ]]],
                  Editable->False], "-", \(v\_3\)}], "==", "0"}], ",", 
            RowBox[{
              RowBox[{
                RowBox[{\(-\[Alpha]\), " ", 
                  RowBox[{"int", "[", 
                    RowBox[{
                      SuperscriptBox[
                        RowBox[{"(", 
                          InterpretationBox[
                            RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                              SubsuperscriptBox["u", "1", 
                                InterpretationBox["\<\"'\"\>",
                                  SequenceForm[ "'"],
                                  Editable->False]]}],
                            SequenceForm[ "", 
                              Power[ 
                                Subscript[ u, 1], 
                                SequenceForm[ "'"]]],
                            Editable->False], ")"}], "2"], ",", 
                      \({x, 0, 1}\)}], "]"}], " ", 
                  RowBox[{"(", 
                    InterpretationBox[
                      RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                        SubsuperscriptBox["u", "1", 
                          InterpretationBox[\("'"\[InvisibleSpace]"'"\),
                            SequenceForm[ "'", "'"],
                            Editable->False]]}],
                      SequenceForm[ "", 
                        Power[ 
                          Subscript[ u, 1], 
                          SequenceForm[ "'", "'"]]],
                      Editable->False], ")"}]}], "-", 
                RowBox[{"2", " ", "b", " ", "\[Alpha]", " ", 
                  RowBox[{"int", "[", 
                    RowBox[{
                      RowBox[{
                        RowBox[{"(", 
                          InterpretationBox[
                            RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                              SubsuperscriptBox["u", "2", 
                                InterpretationBox["\<\"'\"\>",
                                  SequenceForm[ "'"],
                                  Editable->False]]}],
                            SequenceForm[ "", 
                              Power[ 
                                Subscript[ u, 2], 
                                SequenceForm[ "'"]]],
                            Editable->False], ")"}], " ", 
                        RowBox[{
                          SubsuperscriptBox["\[Phi]", "k", "\[Prime]",
                            MultilineFunction->None], "[", "x", "]"}]}], ",", 
                      \({x, 0, 1}\)}], "]"}], " ", 
                  RowBox[{"(", 
                    InterpretationBox[
                      RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                        SubsuperscriptBox["u", "1", 
                          InterpretationBox[\("'"\[InvisibleSpace]"'"\),
                            SequenceForm[ "'", "'"],
                            Editable->False]]}],
                      SequenceForm[ "", 
                        Power[ 
                          Subscript[ u, 1], 
                          SequenceForm[ "'", "'"]]],
                      Editable->False], ")"}]}], "-", 
                RowBox[{
                \(1\/2\), " ", \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\), " ", 
                  "f", " ", 
                  RowBox[{"(", 
                    InterpretationBox[
                      RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                        SubsuperscriptBox["u", "2", 
                          InterpretationBox[\("'"\[InvisibleSpace]"'"\),
                            SequenceForm[ "'", "'"],
                            Editable->False]]}],
                      SequenceForm[ "", 
                        Power[ 
                          Subscript[ u, 2], 
                          SequenceForm[ "'", "'"]]],
                      Editable->False], ")"}]}], "-", 
                RowBox[{
                \(1\/2\), " ", \(E\^\(I\ T\_0\ \[CapitalOmega]\)\), " ", "f", 
                  " ", 
                  RowBox[{"(", 
                    InterpretationBox[
                      RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                        SubsuperscriptBox["u", "2", 
                          InterpretationBox[\("'"\[InvisibleSpace]"'"\),
                            SequenceForm[ "'", "'"],
                            Editable->False]]}],
                      SequenceForm[ "", 
                        Power[ 
                          Subscript[ u, 2], 
                          SequenceForm[ "'", "'"]]],
                      Editable->False], ")"}]}], "-", 
                RowBox[{"2", " ", "b", " ", "\[Alpha]", " ", 
                  RowBox[{"int", "[", 
                    RowBox[{
                      RowBox[{
                        RowBox[{"(", 
                          InterpretationBox[
                            RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                              SubsuperscriptBox["u", "1", 
                                InterpretationBox["\<\"'\"\>",
                                  SequenceForm[ "'"],
                                  Editable->False]]}],
                            SequenceForm[ "", 
                              Power[ 
                                Subscript[ u, 1], 
                                SequenceForm[ "'"]]],
                            Editable->False], ")"}], " ", 
                        RowBox[{
                          SubsuperscriptBox["\[Phi]", "k", "\[Prime]",
                            MultilineFunction->None], "[", "x", "]"}]}], ",", 
                      \({x, 0, 1}\)}], "]"}], " ", 
                  RowBox[{"(", 
                    InterpretationBox[
                      RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                        SubsuperscriptBox["u", "2", 
                          InterpretationBox[\("'"\[InvisibleSpace]"'"\),
                            SequenceForm[ "'", "'"],
                            Editable->False]]}],
                      SequenceForm[ "", 
                        Power[ 
                          Subscript[ u, 2], 
                          SequenceForm[ "'", "'"]]],
                      Editable->False], ")"}]}], "+", 
                InterpretationBox[
                  RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                    SubsuperscriptBox["u", "3", 
                      
                      InterpretationBox[
                        \("'"\[InvisibleSpace]"'"\[InvisibleSpace]"'"\
\[InvisibleSpace]"'"\),
                        SequenceForm[ "'", "'", "'", "'"],
                        Editable->False]]}],
                  SequenceForm[ "", 
                    Power[ 
                      Subscript[ u, 3], 
                      SequenceForm[ "'", "'", "'", "'"]]],
                  Editable->False], "+", 
                RowBox[{"2", " ", "\[Mu]", " ", 
                  RowBox[{"(", 
                    InterpretationBox[
                      RowBox[{\(D\_0\), "\[InvisibleSpace]", 
                        SubsuperscriptBox["u", "2", 
                          InterpretationBox["\[Null]",
                            SequenceForm[ ],
                            Editable->False]]}],
                      SequenceForm[ 
                        Subscript[ D, 0], 
                        Power[ 
                          Subscript[ u, 2], 
                          SequenceForm[ ]]],
                      Editable->False], ")"}]}], "+", 
                InterpretationBox[
                  RowBox[{\(D\_0\), "\[InvisibleSpace]", 
                    SubsuperscriptBox["v", "3", 
                      InterpretationBox["\[Null]",
                        SequenceForm[ ],
                        Editable->False]]}],
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Power[ 
                      Subscript[ v, 3], 
                      SequenceForm[ ]]],
                  Editable->False], "+", 
                RowBox[{"2", " ", "\[Mu]", " ", 
                  RowBox[{"(", 
                    InterpretationBox[
                      RowBox[{\(D\_1\), "\[InvisibleSpace]", 
                        SubsuperscriptBox["u", "1", 
                          InterpretationBox["\[Null]",
                            SequenceForm[ ],
                            Editable->False]]}],
                      SequenceForm[ 
                        Subscript[ D, 1], 
                        Power[ 
                          Subscript[ u, 1], 
                          SequenceForm[ ]]],
                      Editable->False], ")"}]}], "+", 
                InterpretationBox[
                  RowBox[{\(D\_1\), "\[InvisibleSpace]", 
                    SubsuperscriptBox["v", "2", 
                      InterpretationBox["\[Null]",
                        SequenceForm[ ],
                        Editable->False]]}],
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Power[ 
                      Subscript[ v, 2], 
                      SequenceForm[ ]]],
                  Editable->False], "+", 
                InterpretationBox[
                  RowBox[{\(D\_2\), "\[InvisibleSpace]", 
                    SubsuperscriptBox["v", "1", 
                      InterpretationBox["\[Null]",
                        SequenceForm[ ],
                        Editable->False]]}],
                  SequenceForm[ 
                    Subscript[ D, 2], 
                    Power[ 
                      Subscript[ v, 1], 
                      SequenceForm[ ]]],
                  Editable->False], "+", 
                RowBox[{
                  RowBox[{"(", 
                    InterpretationBox[
                      RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                        SubsuperscriptBox["u", "3", 
                          InterpretationBox[\("'"\[InvisibleSpace]"'"\),
                            SequenceForm[ "'", "'"],
                            Editable->False]]}],
                      SequenceForm[ "", 
                        Power[ 
                          Subscript[ u, 3], 
                          SequenceForm[ "'", "'"]]],
                      Editable->False], ")"}], " ", \(P\_k\)}], "-", 
                RowBox[{"2", " ", "b", " ", "\[Alpha]", " ", 
                  RowBox[{"int", "[", 
                    RowBox[{
                      RowBox[{
                        RowBox[{"(", 
                          InterpretationBox[
                            RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                              SubsuperscriptBox["u", "1", 
                                InterpretationBox["\<\"'\"\>",
                                  SequenceForm[ "'"],
                                  Editable->False]]}],
                            SequenceForm[ "", 
                              Power[ 
                                Subscript[ u, 1], 
                                SequenceForm[ "'"]]],
                            Editable->False], ")"}], " ", 
                        RowBox[{"(", 
                          InterpretationBox[
                            RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                              SubsuperscriptBox["u", "2", 
                                InterpretationBox["\<\"'\"\>",
                                  SequenceForm[ "'"],
                                  Editable->False]]}],
                            SequenceForm[ "", 
                              Power[ 
                                Subscript[ u, 2], 
                                SequenceForm[ "'"]]],
                            Editable->False], ")"}]}], ",", \({x, 0, 1}\)}], 
                    "]"}], " ", 
                  RowBox[{
                    SubsuperscriptBox["\[Phi]", "k", "\[DoublePrime]",
                      MultilineFunction->None], "[", "x", "]"}]}], "-", 
                RowBox[{"2", " ", \(b\^2\), " ", "\[Alpha]", " ", 
                  RowBox[{"int", "[", 
                    RowBox[{
                      RowBox[{
                        RowBox[{"(", 
                          InterpretationBox[
                            RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                              SubsuperscriptBox["u", "3", 
                                InterpretationBox["\<\"'\"\>",
                                  SequenceForm[ "'"],
                                  Editable->False]]}],
                            SequenceForm[ "", 
                              Power[ 
                                Subscript[ u, 3], 
                                SequenceForm[ "'"]]],
                            Editable->False], ")"}], " ", 
                        RowBox[{
                          SubsuperscriptBox["\[Phi]", "k", "\[Prime]",
                            MultilineFunction->None], "[", "x", "]"}]}], ",", 
                      \({x, 0, 1}\)}], "]"}], " ", 
                  RowBox[{
                    SubsuperscriptBox["\[Phi]", "k", "\[DoublePrime]",
                      MultilineFunction->None], "[", "x", "]"}]}]}], "==", 
              "0"}]}], "}"}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell["9.1.1 First-Order Solution", "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "The homogeneous part of the first-order equations, ",
  StyleBox["eqEps[[1]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", can be written as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(linearSys = \(#[\([1]\)]\ &\)\ /@\ eqEps[\([1]\)] /. f -> 0; \n
    linearSys /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          InterpretationBox[
            RowBox[{\(D\_0\), "\[InvisibleSpace]", 
              SubsuperscriptBox["u", "1", 
                InterpretationBox["\[Null]",
                  SequenceForm[ ],
                  Editable->False]]}],
            SequenceForm[ 
              Subscript[ D, 0], 
              Power[ 
                Subscript[ u, 1], 
                SequenceForm[ ]]],
            Editable->False], "-", \(v\_1\)}], ",", 
        RowBox[{
          InterpretationBox[
            RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
              SubsuperscriptBox["u", "1", 
                
                InterpretationBox[
                  \("'"\[InvisibleSpace]"'"\[InvisibleSpace]"'"\
\[InvisibleSpace]"'"\),
                  SequenceForm[ "'", "'", "'", "'"],
                  Editable->False]]}],
            SequenceForm[ "", 
              Power[ 
                Subscript[ u, 1], 
                SequenceForm[ "'", "'", "'", "'"]]],
            Editable->False], "+", 
          InterpretationBox[
            RowBox[{\(D\_0\), "\[InvisibleSpace]", 
              SubsuperscriptBox["v", "1", 
                InterpretationBox["\[Null]",
                  SequenceForm[ ],
                  Editable->False]]}],
            SequenceForm[ 
              Subscript[ D, 0], 
              Power[ 
                Subscript[ v, 1], 
                SequenceForm[ ]]],
            Editable->False], "+", 
          RowBox[{
            RowBox[{"(", 
              InterpretationBox[
                RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                  SubsuperscriptBox["u", "1", 
                    InterpretationBox[\("'"\[InvisibleSpace]"'"\),
                      SequenceForm[ "'", "'"],
                      Editable->False]]}],
                SequenceForm[ "", 
                  Power[ 
                    Subscript[ u, 1], 
                    SequenceForm[ "'", "'"]]],
                Editable->False], ")"}], " ", \(P\_k\)}], "-", 
          RowBox[{"2", " ", \(b\^2\), " ", "\[Alpha]", " ", 
            RowBox[{"int", "[", 
              RowBox[{
                RowBox[{
                  RowBox[{"(", 
                    InterpretationBox[
                      RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                        SubsuperscriptBox["u", "1", 
                          InterpretationBox["\<\"'\"\>",
                            SequenceForm[ "'"],
                            Editable->False]]}],
                      SequenceForm[ "", 
                        Power[ 
                          Subscript[ u, 1], 
                          SequenceForm[ "'"]]],
                      Editable->False], ")"}], " ", 
                  RowBox[{
                    SubsuperscriptBox["\[Phi]", "k", "\[Prime]",
                      MultilineFunction->None], "[", "x", "]"}]}], ",", 
                \({x, 0, 1}\)}], "]"}], " ", 
            RowBox[{
              SubsuperscriptBox["\[Phi]", "k", "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}]}]}]}], "}"}]], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Because in the presence of damping all of the modes that are not directly \
or indirectly excited decay with time (Nayfeh and Mook, 1979), the solution \
of ",
  StyleBox["eqEps[[1]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " is taken to consist of the lowest two modes; that is,"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(solForm = 
      \[CapitalPsi][x]\ Exp[I\ \[CapitalOmega]\ T\_0] + 
        \[CapitalPsi][x]\ Exp[\(-I\)\ \[CapitalOmega]\ T\_0] + 
        Sum[A\_i[T\_1, T\_2]\ \[CapitalPhi]\_i[x]\ 
              Exp[I\ \[Omega]\_i\ T\_0] + 
            A\&_\_i[T\_1, T\_2]\ \[CapitalPhi]\_i[x]\ 
              Exp[\(-I\)\ \[Omega]\_i\ T\_0], {i, 2}]; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1 = {u\_1 -> Function[{x, T\_0, T\_1, T\_2}, solForm // Evaluate], 
        v\_1 -> Function[{x, T\_0, T\_1, T\_2}, D[solForm, T\_0] // Evaluate]}
        \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_1 \[Rule] 
        Function[{x, T\_0, T\_1, T\_2}, 
          E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ \[CapitalPsi][x] + 
            E\^\(I\ T\_0\ \[CapitalOmega]\)\ \[CapitalPsi][x] + 
            E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1[T\_1, T\_2]\ 
              \[CapitalPhi]\_1[x] + 
            E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2[T\_1, T\_2]\ 
              \[CapitalPhi]\_2[x] + 
            E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ \[CapitalPhi]\_1[x]\ 
              A\&_\_1[T\_1, T\_2] + 
            E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ \[CapitalPhi]\_2[x]\ 
              A\&_\_2[T\_1, T\_2]], 
      v\_1 \[Rule] 
        Function[{x, T\_0, T\_1, T\_2}, 
          \(-I\)\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ \[CapitalOmega]\ 
              \[CapitalPsi][x] + 
            I\ E\^\(I\ T\_0\ \[CapitalOmega]\)\ \[CapitalOmega]\ 
              \[CapitalPsi][x] + 
            I\ E\^\(I\ T\_0\ \[Omega]\_1\)\ \[Omega]\_1\ A\_1[T\_1, T\_2]\ 
              \[CapitalPhi]\_1[x] + 
            I\ E\^\(I\ T\_0\ \[Omega]\_2\)\ \[Omega]\_2\ A\_2[T\_1, T\_2]\ 
              \[CapitalPhi]\_2[x] - 
            I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ \[Omega]\_1\ 
              \[CapitalPhi]\_1[x]\ A\&_\_1[T\_1, T\_2] - 
            I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ \[Omega]\_2\ 
              \[CapitalPhi]\_2[x]\ A\&_\_2[T\_1, T\_2]]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "where the ",
  Cell[BoxData[
      \(\[CapitalPhi]\_i\)]],
  " are the eigenmodes, which satisfy the orthonormality condition ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Integral]\_0\%1 \[CapitalPhi]\_n[x]\ \[CapitalPhi]\_m[x]\ 
            \[DifferentialD]x = \[Delta]\_\(n, m\)\)]],
  ", and ",
  Cell[BoxData[
      \(\[CapitalPsi]\)]],
  " is uniquely determined by the following boundary-value problem:"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(eq91b = 
      Coefficient[
          \(\(eqEps[\([1, 2, 1]\)] /. 
                \((sol1 /. {A\_i_ -> \((0\ &)\), A\&_\_i_ -> \((0\ &)\)})
                  \)\) /. intRule1\) //. intRule2, 
          E\^\(I\ \[CapitalOmega]\ T\_0\)] == 0\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{\(\(-\[CapitalOmega]\^2\)\ \[CapitalPsi][x]\), "+", 
        RowBox[{\(P\_k\), " ", 
          RowBox[{
            SuperscriptBox["\[CapitalPsi]", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}]}], "-", 
        RowBox[{\(1\/2\), " ", "b", " ", "f", " ", 
          RowBox[{
            SubsuperscriptBox["\[Phi]", "k", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}]}], "-", 
        RowBox[{"2", " ", \(b\^2\), " ", "\[Alpha]", " ", 
          RowBox[{"int", "[", 
            RowBox[{
              RowBox[{
                RowBox[{
                  SuperscriptBox["\[CapitalPsi]", "\[Prime]",
                    MultilineFunction->None], "[", "x", "]"}], " ", 
                RowBox[{
                  SubsuperscriptBox["\[Phi]", "k", "\[Prime]",
                    MultilineFunction->None], "[", "x", "]"}]}], ",", 
              \({x, 0, 1}\)}], "]"}], " ", 
          RowBox[{
            SubsuperscriptBox["\[Phi]", "k", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}]}], "+", 
        RowBox[{
          SuperscriptBox["\[CapitalPsi]", 
            TagBox[\((4)\),
              Derivative],
            MultilineFunction->None], "[", "x", "]"}]}], "==", "0"}]], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(bc91b = BC /. u -> \[CapitalPsi]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\(\[CapitalPsi][0, t] == 0\), ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["\[CapitalPsi]", 
              TagBox[\((2, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(0, t\), "]"}], "==", "0"}], 
        ",", \(\[CapitalPsi][1, t] == 0\), ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["\[CapitalPsi]", 
              TagBox[\((2, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(1, t\), "]"}], "==", "0"}]}], 
      "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
In what follows, we consider nonlinear vibrations of a first-mode buckled \
beam; hence, the critical buckling load is\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(bucklingLoad = P\_k -> \[Pi]\^2; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "We note that, as the buckling level increases from zero, the symmetric \
mode is the first mode. However, as the buckling level exceeds the first \
cross-over value, the symmetric mode becomes the second mode. Hence, the \
second natural frequency ",
  Cell[BoxData[
      \(\[Omega]\_2\)]],
  " depends on the buckling level. For buckling levels greater than the \
cross-over value, the first static buckled deflection and the first two \
normalized mode shapes and associated natural frequencies are"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(modeshapes = {\[Phi]\_k -> \((Sin[\[Pi]\ #]\ &)\), 
        \[CapitalPhi]\_1 -> \((\(\@2\) Sin[2  \[Pi]\ #]\ &)\), 
        \[CapitalPhi]\_2 -> \((\(\@2\) Sin[\[Pi]\ #]\ &)\)}; \n
    frequencies = {\[Omega]\_2 -> b\ \(\[Pi]\^2\) \@\[Alpha], 
        \[Omega]\_1 -> 2 \@ 3\ \[Pi]\^2}; \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "The buckling level at which ",
  Cell[BoxData[
      \(\[Omega]\_2 = 2  \[Omega]\_1\)]],
  " is"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(values1 = 
      \(Solve[\[Omega]\_2 == 2  \[Omega]\_1 /. frequencies, b]\)[\([1]\)]\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({b \[Rule] \(4\ \@3\)\/\@\[Alpha]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Substituting the ",
  StyleBox["bucklingLoad",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["modeshapes",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["eq91b",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(eq91c = \(eq91b /. bucklingLoad\) /. modeshapes\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{\(1\/2\ b\ f\ \[Pi]\^2\ Sin[\[Pi]\ x]\), "+", 
        RowBox[{"2", " ", \(b\^2\), " ", \(\[Pi]\^2\), " ", "\[Alpha]", " ", 
          RowBox[{"int", "[", 
            RowBox[{
              RowBox[{"\[Pi]", " ", \(Cos[\[Pi]\ x]\), " ", 
                RowBox[{
                  SuperscriptBox["\[CapitalPsi]", "\[Prime]",
                    MultilineFunction->None], "[", "x", "]"}]}], ",", 
              \({x, 0, 1}\)}], "]"}], " ", \(Sin[\[Pi]\ x]\)}], "-", 
        \(\[CapitalOmega]\^2\ \[CapitalPsi][x]\), "+", 
        RowBox[{\(\[Pi]\^2\), " ", 
          RowBox[{
            SuperscriptBox["\[CapitalPsi]", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}]}], "+", 
        RowBox[{
          SuperscriptBox["\[CapitalPsi]", 
            TagBox[\((4)\),
              Derivative],
            MultilineFunction->None], "[", "x", "]"}]}], "==", "0"}]], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Inspection of ",
  StyleBox["eq91c",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["bc91b ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "suggests that ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPsi][x]\)]],
  " has the form"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(\[CapitalPsi]sol = 
      \[CapitalPsi] -> \((\[CapitalGamma]\ Sin[\[Pi]\ #]\ &)\); \)\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting ",
  StyleBox["\[CapitalPsi]sol",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["eq91c",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", collecting the coefficient of ",
  Cell[BoxData[
      \(TraditionalForm\`Sin[\[Pi]\ x]\)]],
  ", solving the resulting equation for ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalGamma]\)]],
  ", and simplifying it using ",
  StyleBox["frequencies",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["values1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CapitalGamma]Rule = 
      \(\(\(Solve[
                Coefficient[
                    \(eq91c[\([1]\)] /. \[CapitalPsi]sol\) /. 
                      int -> Integrate, Sin[\[Pi]\ x]] == 0, \[CapitalGamma]]
                \)[\([1]\)] /. \[CapitalOmega] -> 2  \[Omega]\_2\) /. 
          frequencies\) /. values1\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[CapitalGamma] \[Rule] f\/\(24\ \@3\ \[Pi]\^2\ \@\[Alpha]\)}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["Because the buckled-beam problem is self-adjoint, we have", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(adjoint = {{\(-I\)\ \[Omega]\_1\ \[CapitalPhi]\_1[x], 
          \[CapitalPhi]\_1[x]}, {\(-I\)\ \[Omega]\_2\ \[CapitalPhi]\_2[x], 
          \[CapitalPhi]\_2[x]}}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["whose complex conjugate is", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(adjointC = adjoint /. conjugateRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{I\ \[Omega]\_1\ \[CapitalPhi]\_1[x], \[CapitalPhi]\_1[x]}, {
        I\ \[Omega]\_2\ \[CapitalPhi]\_2[x], \[CapitalPhi]\_2[x]}}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["9.1.2 Second-Order Solution", "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting ",
  StyleBox["sol1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", ",
  StyleBox["\[CapitalPsi]sol",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", and some of the parameter values into ",
  StyleBox["eqEps[[2]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(order2Eq = 
      \(\((linearSys /. u_\_1 -> u\_2)\) == 
              \((\(\(\(\(\(\(\((linearSys /. u_\_1 -> u\_2)\) - 
                                  \((\(#[\([1]\)]\ &\)\ /@\ eqEps[\([2]\)])
                                    \) /. sol1\) /. \[CapitalPsi]sol\) /. 
                            \[CapitalGamma]Rule\) /. intRule1\) //. intRule2
                        \) /. modeshapes\) /. int -> Integrate // Expand)
                \) /. bucklingLoad\) /. values1 // Thread; \n
    order2Eq /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            InterpretationBox[
              RowBox[{\(D\_0\), "\[InvisibleSpace]", 
                SubsuperscriptBox["u", "2", 
                  InterpretationBox["\[Null]",
                    SequenceForm[ ],
                    Editable->False]]}],
              SequenceForm[ 
                Subscript[ D, 0], 
                Power[ 
                  Subscript[ u, 2], 
                  SequenceForm[ ]]],
              Editable->False], "-", \(v\_2\)}], "==", 
          RowBox[{
            RowBox[{\(-\@2\), " ", \(E\^\(I\ T\_0\ \[Omega]\_2\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 2]],
                  Editable->False], ")"}], " ", \(Sin[\[Pi]\ x]\)}], "-", 
            RowBox[{\(\@2\), " ", \(E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 2]],
                  Editable->False], ")"}], " ", \(Sin[\[Pi]\ x]\)}], "-", 
            RowBox[{\(\@2\), " ", \(E\^\(I\ T\_0\ \[Omega]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 1]],
                  Editable->False], ")"}], " ", \(Sin[2\ \[Pi]\ x]\)}], "-", 
            RowBox[{\(\@2\), " ", \(E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 1]],
                  Editable->False], ")"}], " ", \(Sin[2\ \[Pi]\ x]\)}]}]}], 
        ",", 
        RowBox[{
          RowBox[{
            RowBox[{\(\[Pi]\^2\), " ", 
              RowBox[{"(", 
                InterpretationBox[
                  RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                    SubsuperscriptBox["u", "2", 
                      InterpretationBox[\("'"\[InvisibleSpace]"'"\),
                        SequenceForm[ "'", "'"],
                        Editable->False]]}],
                  SequenceForm[ "", 
                    Power[ 
                      Subscript[ u, 2], 
                      SequenceForm[ "'", "'"]]],
                  Editable->False], ")"}]}], "+", 
            InterpretationBox[
              RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                SubsuperscriptBox["u", "2", 
                  
                  InterpretationBox[
                    \("'"\[InvisibleSpace]"'"\[InvisibleSpace]"'"\
\[InvisibleSpace]"'"\),
                    SequenceForm[ "'", "'", "'", "'"],
                    Editable->False]]}],
              SequenceForm[ "", 
                Power[ 
                  Subscript[ u, 2], 
                  SequenceForm[ "'", "'", "'", "'"]]],
              Editable->False], "+", 
            InterpretationBox[
              RowBox[{\(D\_0\), "\[InvisibleSpace]", 
                SubsuperscriptBox["v", "2", 
                  InterpretationBox["\[Null]",
                    SequenceForm[ ],
                    Editable->False]]}],
              SequenceForm[ 
                Subscript[ D, 0], 
                Power[ 
                  Subscript[ v, 2], 
                  SequenceForm[ ]]],
              Editable->False], "-", 
            RowBox[{"96", " ", 
              RowBox[{"int", "[", 
                RowBox[{
                  RowBox[{
                    RowBox[{"(", 
                      InterpretationBox[
                        RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                          SubsuperscriptBox["u", "2", 
                            InterpretationBox["\<\"'\"\>",
                              SequenceForm[ "'"],
                              Editable->False]]}],
                        SequenceForm[ "", 
                          Power[ 
                            Subscript[ u, 2], 
                            SequenceForm[ "'"]]],
                        Editable->False], ")"}], " ", 
                    RowBox[{
                      SubsuperscriptBox["\[Phi]", "k", "\[Prime]",
                        MultilineFunction->None], "[", "x", "]"}]}], ",", 
                  \({x, 0, 1}\)}], "]"}], " ", 
              RowBox[{
                SubsuperscriptBox["\[Phi]", "k", "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}]}]}], "==", 
          RowBox[{
          \(-\(\(f\^2\ Sin[\[Pi]\ x]\)\/\(16\ \@3\ \@\[Alpha]\)\)\), "-", 
            \(\(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ f\^2\ 
                  Sin[\[Pi]\ x]\)\/\(32\ \@3\ \@\[Alpha]\)\), "-", 
            \(\(E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ f\^2\ 
                  Sin[\[Pi]\ x]\)\/\(32\ \@3\ \@\[Alpha]\)\), "+", 
            \(\(I\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ f\ \[Mu]\ 
                  \[CapitalOmega]\ Sin[\[Pi]\ x]\)\/\(12\ \@3\ \[Pi]\^2\ 
                  \@\[Alpha]\)\), "-", 
            \(\(I\ E\^\(I\ T\_0\ \[CapitalOmega]\)\ f\ \[Mu]\ 
                  \[CapitalOmega]\ Sin[\[Pi]\ x]\)\/\(12\ \@3\ \[Pi]\^2\ 
                  \@\[Alpha]\)\), "-", 
            \(8\/3\ \@2\ 
              E\^\(I\ T\_0\ \((\(-\[CapitalOmega]\) + \[Omega]\_1)\)\)\ f\ 
              \[Pi]\^2\ Sin[2\ \[Pi]\ x]\ A\_1\), "-", 
            \(8\/3\ \@2\ E\^\(I\ T\_0\ \((\[CapitalOmega] + \[Omega]\_1)\)\)\ 
              f\ \[Pi]\^2\ Sin[2\ \[Pi]\ x]\ A\_1\), "-", 
            \(16\ \@3\ E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ \[Pi]\^4\ \@\[Alpha]\ 
              Sin[\[Pi]\ x]\ A\_1\%2\), "-", 
            \(\@2\ E\^\(I\ T\_0\ \((\(-\[CapitalOmega]\) + \[Omega]\_2)\)\)\ f
              \ \[Pi]\^2\ Sin[\[Pi]\ x]\ A\_2\), "-", 
            \(\@2\ E\^\(I\ T\_0\ \((\[CapitalOmega] + \[Omega]\_2)\)\)\ f\ 
              \[Pi]\^2\ Sin[\[Pi]\ x]\ A\_2\), "-", 
            \(32\ \@3\ E\^\(I\ T\_0\ \((\[Omega]\_1 + \[Omega]\_2)\)\)\ 
              \[Pi]\^4\ \@\[Alpha]\ Sin[2\ \[Pi]\ x]\ A\_1\ A\_2\), "-", 
            \(12\ \@3\ E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ \[Pi]\^4\ \@\[Alpha]\ 
              Sin[\[Pi]\ x]\ A\_2\%2\), "-", 
            RowBox[{
            "I", " ", \(\@2\), " ", \(E\^\(I\ T\_0\ \[Omega]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 1]],
                  Editable->False], ")"}], " ", \(Sin[2\ \[Pi]\ x]\), " ", 
              \(\[Omega]\_1\)}], "+", 
            RowBox[{
            "I", " ", \(\@2\), " ", \(E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\), 
              " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 1]],
                  Editable->False], ")"}], " ", \(Sin[2\ \[Pi]\ x]\), " ", 
              \(\[Omega]\_1\)}], "-", 
            \(2\ I\ \@2\ E\^\(I\ T\_0\ \[Omega]\_1\)\ \[Mu]\ 
              Sin[2\ \[Pi]\ x]\ A\_1\ \[Omega]\_1\), "-", 
            RowBox[{
            "I", " ", \(\@2\), " ", \(E\^\(I\ T\_0\ \[Omega]\_2\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 2]],
                  Editable->False], ")"}], " ", \(Sin[\[Pi]\ x]\), " ", 
              \(\[Omega]\_2\)}], "+", 
            RowBox[{
            "I", " ", \(\@2\), " ", \(E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\), 
              " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 2]],
                  Editable->False], ")"}], " ", \(Sin[\[Pi]\ x]\), " ", 
              \(\[Omega]\_2\)}], "-", 
            \(2\ I\ \@2\ E\^\(I\ T\_0\ \[Omega]\_2\)\ \[Mu]\ Sin[\[Pi]\ x]\ 
              A\_2\ \[Omega]\_2\), "-", 
            \(8\/3\ \@2\ 
              E\^\(I\ T\_0\ \((\(-\[CapitalOmega]\) - \[Omega]\_1)\)\)\ f\ 
              \[Pi]\^2\ Sin[2\ \[Pi]\ x]\ A\&_\_1\), "-", 
            \(8\/3\ \@2\ E\^\(I\ T\_0\ \((\[CapitalOmega] - \[Omega]\_1)\)\)\ 
              f\ \[Pi]\^2\ Sin[2\ \[Pi]\ x]\ A\&_\_1\), "-", 
            \(32\ \@3\ \[Pi]\^4\ \@\[Alpha]\ Sin[\[Pi]\ x]\ A\_1\ A\&_\_1\), 
            "-", \(32\ \@3\ 
              E\^\(I\ T\_0\ \((\(-\[Omega]\_1\) + \[Omega]\_2)\)\)\ \[Pi]\^4\ 
              \@\[Alpha]\ Sin[2\ \[Pi]\ x]\ A\_2\ A\&_\_1\), "+", 
            \(2\ I\ \@2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ \[Mu]\ 
              Sin[2\ \[Pi]\ x]\ \[Omega]\_1\ A\&_\_1\), "-", 
            \(16\ \@3\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Pi]\^4\ 
              \@\[Alpha]\ Sin[\[Pi]\ x]\ A\&_\_1\%2\), "-", 
            \(\@2\ E\^\(I\ T\_0\ \((\(-\[CapitalOmega]\) - \[Omega]\_2)\)\)\ f
              \ \[Pi]\^2\ Sin[\[Pi]\ x]\ A\&_\_2\), "-", 
            \(\@2\ E\^\(I\ T\_0\ \((\[CapitalOmega] - \[Omega]\_2)\)\)\ f\ 
              \[Pi]\^2\ Sin[\[Pi]\ x]\ A\&_\_2\), "-", 
            \(32\ \@3\ E\^\(I\ T\_0\ \((\[Omega]\_1 - \[Omega]\_2)\)\)\ 
              \[Pi]\^4\ \@\[Alpha]\ Sin[2\ \[Pi]\ x]\ A\_1\ A\&_\_2\), "-", 
            \(24\ \@3\ \[Pi]\^4\ \@\[Alpha]\ Sin[\[Pi]\ x]\ A\_2\ A\&_\_2\), 
            "+", \(2\ I\ \@2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ \[Mu]\ 
              Sin[\[Pi]\ x]\ \[Omega]\_2\ A\&_\_2\), "-", 
            \(32\ \@3\ E\^\(I\ T\_0\ \((\(-\[Omega]\_1\) - \[Omega]\_2)\)\)\ 
              \[Pi]\^4\ \@\[Alpha]\ Sin[2\ \[Pi]\ x]\ A\&_\_1\ A\&_\_2\), 
            "-", \(12\ \@3\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ \[Pi]\^4\ 
              \@\[Alpha]\ Sin[\[Pi]\ x]\ A\&_\_2\%2\)}]}]}], "}"}]], "Output",\

  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "In order to collect the terms that may lead to secular terms from the \
right-hand sides of ",
  StyleBox["order2Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we define the rules"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(OmgRule = 
      \(\(Solve[ResonanceConds, 
              Complement[omgList, {#}]~Join~{\[CapitalOmega]}]\)[\([1]\)]\ &
          \)\ /@\ omgList\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{\[Omega]\_2 \[Rule] \[Epsilon]\ \[Sigma]\_1 + 2\ \[Omega]\_1, 
        \[CapitalOmega] \[Rule] 
          2\ \[Epsilon]\ \[Sigma]\_1 + \[Epsilon]\ \[Sigma]\_2 + 
            4\ \[Omega]\_1}, {
        \[Omega]\_1 \[Rule] 
          1\/2\ \((\(-\[Epsilon]\)\ \[Sigma]\_1 + \[Omega]\_2)\), 
        \[CapitalOmega] \[Rule] \[Epsilon]\ \[Sigma]\_2 + 2\ \[Omega]\_2}}
      \)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[BoxData[
    \(expRule1[i_] := 
      Exp[arg_] :> 
        Exp[Expand[arg /. OmgRule[\([i]\)]] /. \[Epsilon]\ T\_0 -> T\_1]\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Collecting the terms that may lead to secular terms, the terms \
proportional to ",
  Cell[BoxData[
      \(E\^\(I\ \[Omega]\_i\ T\_0\)\)]],
  ", we have"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(ST11 = 
      Coefficient[\(#[\([2]\)]\ &\)\ /@\ order2Eq /. expRule1[1], 
        E\^\(I\ \[Omega]\_1\ T\_0\)]; \nST11 /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{\(-\@2\), " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
              SequenceForm[ 
                Subscript[ D, 1], 
                Subscript[ A, 1]],
              Editable->False], ")"}], " ", \(Sin[2\ \[Pi]\ x]\)}], ",", 
        RowBox[{
          RowBox[{\(-I\), " ", \(\@2\), " ", 
            RowBox[{"(", 
              InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                SequenceForm[ 
                  Subscript[ D, 1], 
                  Subscript[ A, 1]],
                Editable->False], ")"}], " ", \(Sin[2\ \[Pi]\ x]\), " ", 
            \(\[Omega]\_1\)}], "-", 
          \(2\ I\ \@2\ \[Mu]\ Sin[2\ \[Pi]\ x]\ A\_1\ \[Omega]\_1\), "-", 
          \(32\ \@3\ E\^\(I\ T\_1\ \[Sigma]\_1\)\ \[Pi]\^4\ \@\[Alpha]\ 
            Sin[2\ \[Pi]\ x]\ A\_2\ A\&_\_1\)}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ST12 = 
      Coefficient[\(#[\([2]\)]\ &\)\ /@\ order2Eq /. expRule1[2], 
        E\^\(I\ \[Omega]\_2\ T\_0\)]; \nST12 /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{\(-\@2\), " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
              SequenceForm[ 
                Subscript[ D, 1], 
                Subscript[ A, 2]],
              Editable->False], ")"}], " ", \(Sin[\[Pi]\ x]\)}], ",", 
        RowBox[{
        \(\(-16\)\ \@3\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ \[Pi]\^4\ 
            \@\[Alpha]\ Sin[\[Pi]\ x]\ A\_1\%2\), "-", 
          RowBox[{"I", " ", \(\@2\), " ", 
            RowBox[{"(", 
              InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                SequenceForm[ 
                  Subscript[ D, 1], 
                  Subscript[ A, 2]],
                Editable->False], ")"}], " ", \(Sin[\[Pi]\ x]\), " ", 
            \(\[Omega]\_2\)}], "-", 
          \(2\ I\ \@2\ \[Mu]\ Sin[\[Pi]\ x]\ A\_2\ \[Omega]\_2\), "-", 
          \(\@2\ E\^\(I\ T\_1\ \[Sigma]\_2\)\ f\ \[Pi]\^2\ Sin[\[Pi]\ x]\ 
            A\&_\_2\)}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Demanding that ",
  StyleBox["ST11",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  StyleBox[" ",
    FontColor->RGBColor[1, 0, 1]],
  "be orthogonal to the ",
  StyleBox["adjointC[[1]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain the solvability condition"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"SCond11", "=", 
      RowBox[{
        RowBox[{
          RowBox[{"Solve", "[", 
            RowBox[{
            \(\(\(\(int[adjointC[\([1]\)] . ST11, {x, 0, 1}] == 0 /. intRule1
                      \) //. intRule2\) /. modeshapes\) /. 
                int -> Integrate\), ",", 
              RowBox[{
                SubsuperscriptBox["A", "1", 
                  TagBox[\((1, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], 
            "]"}], "[", \([1]\), "]"}], "//", "ExpandAll"}]}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          SubsuperscriptBox["A", "1", 
            TagBox[\((1, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}], "\[Rule]", 
        \(\(-\[Mu]\)\ A\_1[T\_1, T\_2] + 
          \(8\ I\ \@6\ E\^\(I\ T\_1\ \[Sigma]\_1\)\ \[Pi]\^4\ \@\[Alpha]\ 
              A\_2[T\_1, T\_2]\ A\&_\_1[T\_1, T\_2]\)\/\[Omega]\_1\)}], 
      "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Demanding that ",
  StyleBox["ST12",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  StyleBox[" ",
    FontColor->RGBColor[1, 0, 1]],
  "be orthogonal to the ",
  StyleBox["adjointC[[2]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain the solvability condition"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"SCond12", "=", 
      RowBox[{
        RowBox[{
          RowBox[{"Solve", "[", 
            RowBox[{
            \(\(\(\(int[adjointC[\([2]\)] . ST12, {x, 0, 1}] == 0 /. intRule1
                      \) //. intRule2\) /. modeshapes\) /. 
                int -> Integrate\), ",", 
              RowBox[{
                SubsuperscriptBox["A", "2", 
                  TagBox[\((1, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], 
            "]"}], "[", \([1]\), "]"}], "//", "ExpandAll"}]}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          SubsuperscriptBox["A", "2", 
            TagBox[\((1, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}], "\[Rule]", 
        \(\(4\ I\ \@6\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ \[Pi]\^4\ 
              \@\[Alpha]\ A\_1[T\_1, T\_2]\^2\)\/\[Omega]\_2 - 
          \[Mu]\ A\_2[T\_1, T\_2] + 
          \(I\ E\^\(I\ T\_1\ \[Sigma]\_2\)\ f\ \[Pi]\^2\ 
              A\&_\_2[T\_1, T\_2]\)\/\(2\ \[Omega]\_2\)\)}], "}"}]], "Output",\

  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["Hence, we have the solvability conditions", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(SCond1 = Join[SCond11, SCond12]; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["whose complex conjugates are", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(ccSCond1 = SCond1 /. conjugateRule; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "To remove ",
  Cell[BoxData[
      InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
        SequenceForm[ 
          Subscript[ D, 1], 
          Subscript[ A, 1]],
        Editable->False]]],
  " and ",
  Cell[BoxData[
      InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
        SequenceForm[ 
          Subscript[ D, 1], 
          Subscript[ A, 2]],
        Editable->False]]],
  " from the right-hand sides of ",
  StyleBox["order2Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we first define the rules"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sigRule = 
      \(Solve[ResonanceConds, {\[Sigma]\_1, \[Sigma]\_2}]\)[\([1]\)]\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Sigma]\_1 \[Rule] 
        \(-\(\(2\ \[Omega]\_1 - \[Omega]\_2\)\/\[Epsilon]\)\), 
      \[Sigma]\_2 \[Rule] 
        \(-\(\(\(-\[CapitalOmega]\) + 2\ \[Omega]\_2\)\/\[Epsilon]\)\)}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[BoxData[
    \(\(expRule2 = 
      Exp[a_] :> Exp[\(a /. sigRule\) /. T\_1 -> \[Epsilon]\ T\_0 // Expand]; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting ",
  StyleBox["SCond1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", ",
  StyleBox["ccSCond1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", and ",
  StyleBox["expRule2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["order2Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(order2Eqm = 
      \(\(order2Eq /. SCond1\) /. ccSCond1\) /. expRule2 // ExpandAll; \n
    order2Eqm /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            InterpretationBox[
              RowBox[{\(D\_0\), "\[InvisibleSpace]", 
                SubsuperscriptBox["u", "2", 
                  InterpretationBox["\[Null]",
                    SequenceForm[ ],
                    Editable->False]]}],
              SequenceForm[ 
                Subscript[ D, 0], 
                Power[ 
                  Subscript[ u, 2], 
                  SequenceForm[ ]]],
              Editable->False], "-", \(v\_2\)}], "==", 
          \(\@2\ E\^\(I\ T\_0\ \[Omega]\_1\)\ \[Mu]\ Sin[2\ \[Pi]\ x]\ A\_1 + 
            \@2\ E\^\(I\ T\_0\ \[Omega]\_2\)\ \[Mu]\ Sin[\[Pi]\ x]\ A\_2 - 
            \(8\ I\ \@3\ E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ \[Pi]\^4\ 
                \@\[Alpha]\ Sin[\[Pi]\ x]\ A\_1\%2\)\/\[Omega]\_2 + 
            \(I\ E\^\(I\ T\_0\ \((\(-\[CapitalOmega]\) + \[Omega]\_2)\)\)\ f\ 
                \[Pi]\^2\ Sin[\[Pi]\ x]\ A\_2\)\/\(\@2\ \[Omega]\_2\) + 
            \@2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ \[Mu]\ Sin[2\ \[Pi]\ x]\ 
              A\&_\_1 - 
            \(16\ I\ \@3\ 
                E\^\(I\ T\_0\ \((\(-\[Omega]\_1\) + \[Omega]\_2)\)\)\ 
                \[Pi]\^4\ \@\[Alpha]\ Sin[2\ \[Pi]\ x]\ A\_2\ 
                A\&_\_1\)\/\[Omega]\_1 + 
            \(8\ I\ \@3\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Pi]\^4\ 
                \@\[Alpha]\ Sin[\[Pi]\ x]\ A\&_\_1\%2\)\/\[Omega]\_2 + 
            \@2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ \[Mu]\ Sin[\[Pi]\ x]\ 
              A\&_\_2 + 
            \(16\ I\ \@3\ E\^\(I\ T\_0\ \((\[Omega]\_1 - \[Omega]\_2)\)\)\ 
                \[Pi]\^4\ \@\[Alpha]\ Sin[2\ \[Pi]\ x]\ A\_1\ 
                A\&_\_2\)\/\[Omega]\_1 - 
            \(I\ E\^\(I\ T\_0\ \((\[CapitalOmega] - \[Omega]\_2)\)\)\ f\ 
                \[Pi]\^2\ Sin[\[Pi]\ x]\ A\&_\_2\)\/\(\@2\ \[Omega]\_2\)\)}], 
        ",", 
        RowBox[{
          RowBox[{
            RowBox[{\(\[Pi]\^2\), " ", 
              RowBox[{"(", 
                InterpretationBox[
                  RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                    SubsuperscriptBox["u", "2", 
                      InterpretationBox[\("'"\[InvisibleSpace]"'"\),
                        SequenceForm[ "'", "'"],
                        Editable->False]]}],
                  SequenceForm[ "", 
                    Power[ 
                      Subscript[ u, 2], 
                      SequenceForm[ "'", "'"]]],
                  Editable->False], ")"}]}], "+", 
            InterpretationBox[
              RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                SubsuperscriptBox["u", "2", 
                  
                  InterpretationBox[
                    \("'"\[InvisibleSpace]"'"\[InvisibleSpace]"'"\
\[InvisibleSpace]"'"\),
                    SequenceForm[ "'", "'", "'", "'"],
                    Editable->False]]}],
              SequenceForm[ "", 
                Power[ 
                  Subscript[ u, 2], 
                  SequenceForm[ "'", "'", "'", "'"]]],
              Editable->False], "+", 
            InterpretationBox[
              RowBox[{\(D\_0\), "\[InvisibleSpace]", 
                SubsuperscriptBox["v", "2", 
                  InterpretationBox["\[Null]",
                    SequenceForm[ ],
                    Editable->False]]}],
              SequenceForm[ 
                Subscript[ D, 0], 
                Power[ 
                  Subscript[ v, 2], 
                  SequenceForm[ ]]],
              Editable->False], "-", 
            RowBox[{"96", " ", 
              RowBox[{"int", "[", 
                RowBox[{
                  RowBox[{
                    RowBox[{"(", 
                      InterpretationBox[
                        RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                          SubsuperscriptBox["u", "2", 
                            InterpretationBox["\<\"'\"\>",
                              SequenceForm[ "'"],
                              Editable->False]]}],
                        SequenceForm[ "", 
                          Power[ 
                            Subscript[ u, 2], 
                            SequenceForm[ "'"]]],
                        Editable->False], ")"}], " ", 
                    RowBox[{
                      SubsuperscriptBox["\[Phi]", "k", "\[Prime]",
                        MultilineFunction->None], "[", "x", "]"}]}], ",", 
                  \({x, 0, 1}\)}], "]"}], " ", 
              RowBox[{
                SubsuperscriptBox["\[Phi]", "k", "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}]}]}], "==", 
          \(\(-\(\(f\^2\ Sin[\[Pi]\ x]\)\/\(16\ \@3\ \@\[Alpha]\)\)\) - 
            \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ f\^2\ 
                Sin[\[Pi]\ x]\)\/\(32\ \@3\ \@\[Alpha]\) - 
            \(E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ f\^2\ Sin[\[Pi]\ x]\)\/\(32
                \ \@3\ \@\[Alpha]\) + 
            \(I\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ f\ \[Mu]\ 
                \[CapitalOmega]\ Sin[\[Pi]\ x]\)\/\(12\ \@3\ \[Pi]\^2\ 
                \@\[Alpha]\) - 
            \(I\ E\^\(I\ T\_0\ \[CapitalOmega]\)\ f\ \[Mu]\ \[CapitalOmega]\ 
                Sin[\[Pi]\ x]\)\/\(12\ \@3\ \[Pi]\^2\ \@\[Alpha]\) - 
            8\/3\ \@2\ 
              E\^\(I\ T\_0\ \((\(-\[CapitalOmega]\) + \[Omega]\_1)\)\)\ f\ 
              \[Pi]\^2\ Sin[2\ \[Pi]\ x]\ A\_1 - 
            8\/3\ \@2\ E\^\(I\ T\_0\ \((\[CapitalOmega] + \[Omega]\_1)\)\)\ f
              \ \[Pi]\^2\ Sin[2\ \[Pi]\ x]\ A\_1 - 
            8\ \@3\ E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ \[Pi]\^4\ \@\[Alpha]\ 
              Sin[\[Pi]\ x]\ A\_1\%2 + 
            \(E\^\(I\ T\_0\ \((\(-\[CapitalOmega]\) + \[Omega]\_2)\)\)\ f\ 
                \[Pi]\^2\ Sin[\[Pi]\ x]\ A\_2\)\/\@2 - 
            \@2\ E\^\(I\ T\_0\ \((\(-\[CapitalOmega]\) + \[Omega]\_2)\)\)\ f\ 
              \[Pi]\^2\ Sin[\[Pi]\ x]\ A\_2 - 
            \@2\ E\^\(I\ T\_0\ \((\[CapitalOmega] + \[Omega]\_2)\)\)\ f\ 
              \[Pi]\^2\ Sin[\[Pi]\ x]\ A\_2 - 
            32\ \@3\ E\^\(I\ T\_0\ \((\[Omega]\_1 + \[Omega]\_2)\)\)\ 
              \[Pi]\^4\ \@\[Alpha]\ Sin[2\ \[Pi]\ x]\ A\_1\ A\_2 - 
            12\ \@3\ E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ \[Pi]\^4\ \@\[Alpha]\ 
              Sin[\[Pi]\ x]\ A\_2\%2 - 
            I\ \@2\ E\^\(I\ T\_0\ \[Omega]\_1\)\ \[Mu]\ Sin[2\ \[Pi]\ x]\ 
              A\_1\ \[Omega]\_1 - 
            I\ \@2\ E\^\(I\ T\_0\ \[Omega]\_2\)\ \[Mu]\ Sin[\[Pi]\ x]\ A\_2\ 
              \[Omega]\_2 - 
            8\/3\ \@2\ 
              E\^\(I\ T\_0\ \((\(-\[CapitalOmega]\) - \[Omega]\_1)\)\)\ f\ 
              \[Pi]\^2\ Sin[2\ \[Pi]\ x]\ A\&_\_1 - 
            8\/3\ \@2\ E\^\(I\ T\_0\ \((\[CapitalOmega] - \[Omega]\_1)\)\)\ f
              \ \[Pi]\^2\ Sin[2\ \[Pi]\ x]\ A\&_\_1 - 
            32\ \@3\ \[Pi]\^4\ \@\[Alpha]\ Sin[\[Pi]\ x]\ A\_1\ A\&_\_1 - 
            16\ \@3\ E\^\(I\ T\_0\ \((\(-\[Omega]\_1\) + \[Omega]\_2)\)\)\ 
              \[Pi]\^4\ \@\[Alpha]\ Sin[2\ \[Pi]\ x]\ A\_2\ A\&_\_1 + 
            I\ \@2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ \[Mu]\ 
              Sin[2\ \[Pi]\ x]\ \[Omega]\_1\ A\&_\_1 - 
            8\ \@3\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Pi]\^4\ 
              \@\[Alpha]\ Sin[\[Pi]\ x]\ A\&_\_1\%2 - 
            \@2\ E\^\(I\ T\_0\ \((\(-\[CapitalOmega]\) - \[Omega]\_2)\)\)\ f\ 
              \[Pi]\^2\ Sin[\[Pi]\ x]\ A\&_\_2 + 
            \(E\^\(I\ T\_0\ \((\[CapitalOmega] - \[Omega]\_2)\)\)\ f\ 
                \[Pi]\^2\ Sin[\[Pi]\ x]\ A\&_\_2\)\/\@2 - 
            \@2\ E\^\(I\ T\_0\ \((\[CapitalOmega] - \[Omega]\_2)\)\)\ f\ 
              \[Pi]\^2\ Sin[\[Pi]\ x]\ A\&_\_2 - 
            16\ \@3\ E\^\(I\ T\_0\ \((\[Omega]\_1 - \[Omega]\_2)\)\)\ 
              \[Pi]\^4\ \@\[Alpha]\ Sin[2\ \[Pi]\ x]\ A\_1\ A\&_\_2 - 
            24\ \@3\ \[Pi]\^4\ \@\[Alpha]\ Sin[\[Pi]\ x]\ A\_2\ A\&_\_2 + 
            I\ \@2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ \[Mu]\ Sin[\[Pi]\ x]\ 
              \[Omega]\_2\ A\&_\_2 - 
            32\ \@3\ E\^\(I\ T\_0\ \((\(-\[Omega]\_1\) - \[Omega]\_2)\)\)\ 
              \[Pi]\^4\ \@\[Alpha]\ Sin[2\ \[Pi]\ x]\ A\&_\_1\ A\&_\_2 - 
            12\ \@3\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ \[Pi]\^4\ 
              \@\[Alpha]\ Sin[\[Pi]\ x]\ A\&_\_2\%2\)}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "We use the method of undetermined coefficients to determine the solution \
of ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and their associated boundary conditions. To implement this, we first \
determine all possible forms of the terms on the right-hand sides of ",
  StyleBox["order2Eqm ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "as follows:"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2Form = 
      \(Table[\(Cases[order2Eqm[\([k, 2]\)], #]\ &\)\ /@
              \ {_\ E\^\(a_\ T\_0 + b_. \)\ f_[c_\ x] -> 
                  E\^\(a\ T\_0 + b\)\ f[c\ x], 
                a_\ f_[b_\ x] :> f[b\ x] /; FreeQ[a, T\_0]}, {k, 2}] // 
          Flatten\) // Union\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({Sin[\[Pi]\ x], E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ Sin[\[Pi]\ x], 
      E\^\(I\ T\_0\ \[CapitalOmega]\)\ Sin[\[Pi]\ x], 
      E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ Sin[\[Pi]\ x], 
      E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ Sin[\[Pi]\ x], 
      E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ Sin[\[Pi]\ x], 
      E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ Sin[\[Pi]\ x], 
      E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ Sin[\[Pi]\ x], 
      E\^\(I\ T\_0\ \[Omega]\_2\)\ Sin[\[Pi]\ x], 
      E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ Sin[\[Pi]\ x], 
      E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ Sin[\[Pi]\ x], 
      E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ T\_0\ \[Omega]\_2\)\ 
        Sin[\[Pi]\ x], 
      E\^\(I\ T\_0\ \[CapitalOmega] - I\ T\_0\ \[Omega]\_2\)\ Sin[\[Pi]\ x], 
      E\^\(\(-I\)\ T\_0\ \[CapitalOmega] + I\ T\_0\ \[Omega]\_2\)\ 
        Sin[\[Pi]\ x], 
      E\^\(I\ T\_0\ \[CapitalOmega] + I\ T\_0\ \[Omega]\_2\)\ Sin[\[Pi]\ x], 
      E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ Sin[2\ \[Pi]\ x], 
      E\^\(I\ T\_0\ \[Omega]\_1\)\ Sin[2\ \[Pi]\ x], 
      E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ T\_0\ \[Omega]\_1\)\ 
        Sin[2\ \[Pi]\ x], 
      E\^\(I\ T\_0\ \[CapitalOmega] - I\ T\_0\ \[Omega]\_1\)\ 
        Sin[2\ \[Pi]\ x], 
      E\^\(\(-I\)\ T\_0\ \[CapitalOmega] + I\ T\_0\ \[Omega]\_1\)\ 
        Sin[2\ \[Pi]\ x], 
      E\^\(I\ T\_0\ \[CapitalOmega] + I\ T\_0\ \[Omega]\_1\)\ 
        Sin[2\ \[Pi]\ x], 
      E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
        Sin[2\ \[Pi]\ x], 
      E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ Sin[2\ \[Pi]\ x], 
      E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
        Sin[2\ \[Pi]\ x], 
      E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ Sin[2\ \[Pi]\ x]}
      \)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "where all the spatial dependent functions satisfy the hinged-hinged \
boundary conditions. We note that ",
  StyleBox["sol2Form",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " consists of (a) the terms that are proportional to ",
  Cell[BoxData[
      \(E\^\(\(-I\)\ \[Omega]\_1\ T\_0\), E\^\(I\ \[Omega]\_1\ T\_0\)\)]],
  ", ",
  Cell[BoxData[
      \(E\^\(\(-I\)\ \[Omega]\_2\ T\_0\), E\^\(I\ \[Omega]\_2\ T\_0\ \)\)]],
  "and (b) the remainder of the terms. The positions of the former terms, \
which are orthogonal to the adjoint, in ",
  StyleBox["sol2Form",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " are"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(pos[1] = 
      \(\((\(Position[
                  \(#\ sol2Form /. expRule1[1]\) /. Exp[_.  + _\ T\_0] -> 0, 
                  a_ /; a =!= 0, 1] // Flatten\) // Rest)\)\ &\)\ /@
        \ {E\^\(\(-I\)\ \[Omega]\_1\ T\_0\), E\^\(I\ \[Omega]\_1\ T\_0\)}\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{17, 24}, {16, 23}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(pos[2] = 
      \(\((\(Position[
                  \(#\ sol2Form /. expRule1[2]\) /. Exp[_.  + _\ T\_0] -> 0, 
                  a_ /; a =!= 0, 1] // Flatten\) // Rest)\)\ &\)\ /@
        \ {E\^\(\(-I\)\ \[Omega]\_2\ T\_0\), E\^\(I\ \[Omega]\_2\ T\_0\)}\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{7, 9, 13}, {6, 8, 14}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Next, we seek the solution of  ",
  Cell[BoxData[
      \(TraditionalForm\`u\_2\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`v\_2\)]],
  " in two parts. First, we consider the part of ",
  StyleBox["sol2Form",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " that is not related to the secular terms"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2Forma = 
      Delete[sol2Form, \({#}\ &\)\ /@\ Flatten[Array[pos, 2]]]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({Sin[\[Pi]\ x], E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ Sin[\[Pi]\ x], 
      E\^\(I\ T\_0\ \[CapitalOmega]\)\ Sin[\[Pi]\ x], 
      E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ Sin[\[Pi]\ x], 
      E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ Sin[\[Pi]\ x], 
      E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ Sin[\[Pi]\ x], 
      E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ Sin[\[Pi]\ x], 
      E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ T\_0\ \[Omega]\_2\)\ 
        Sin[\[Pi]\ x], 
      E\^\(I\ T\_0\ \[CapitalOmega] + I\ T\_0\ \[Omega]\_2\)\ Sin[\[Pi]\ x], 
      E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ T\_0\ \[Omega]\_1\)\ 
        Sin[2\ \[Pi]\ x], 
      E\^\(I\ T\_0\ \[CapitalOmega] - I\ T\_0\ \[Omega]\_1\)\ 
        Sin[2\ \[Pi]\ x], 
      E\^\(\(-I\)\ T\_0\ \[CapitalOmega] + I\ T\_0\ \[Omega]\_1\)\ 
        Sin[2\ \[Pi]\ x], 
      E\^\(I\ T\_0\ \[CapitalOmega] + I\ T\_0\ \[Omega]\_1\)\ 
        Sin[2\ \[Pi]\ x], 
      E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
        Sin[2\ \[Pi]\ x], 
      E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ Sin[2\ \[Pi]\ x]}
      \)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["and define the undetermined coefficients as", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(uSymbola = Table[\[Psi]\_i, {i, Length[sol2Forma]}]; \n
    vSymbola = uSymbola /. \[Psi] -> \[Eta]; \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "The general solution in terms of the ",
  StyleBox["sol2Forma",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " can be written as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(sol2a = {
        u\_2 -> Function[{x, T\_0, T\_1, T\_2}, 
            uSymbola . sol2Forma // Evaluate], 
        v\_2 -> Function[{x, T\_0, T\_1, T\_2}, 
            vSymbola . sol2Forma // Evaluate]}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Second, we consider the part of ",
  StyleBox["sol2Form",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " that is related to the secular terms"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2Formb1 = sol2Form[\([\(pos[1]\)[\([1]\)]]\)]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({E\^\(I\ T\_0\ \[Omega]\_1\)\ Sin[2\ \[Pi]\ x], 
      E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
        Sin[2\ \[Pi]\ x]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2Formb2 = sol2Form[\([\(pos[2]\)[\([1]\)]]\)]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ Sin[\[Pi]\ x], 
      E\^\(I\ T\_0\ \[Omega]\_2\)\ Sin[\[Pi]\ x], 
      E\^\(I\ T\_0\ \[CapitalOmega] - I\ T\_0\ \[Omega]\_2\)\ Sin[\[Pi]\ x]}
      \)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["and define the undetermined coefficients as", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(uSymbolb1 = Table[\[Psi]s\_\(1, i\), {i, Length[sol2Formb1]}]; \n
    uSymbolb2 = Table[\[Psi]s\_\(2, i\), {i, Length[sol2Formb2]}]; \)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "where the undetermined coefficients for ",
  Cell[BoxData[
      \(TraditionalForm\`v\_2\)]],
  " are related to ",
  StyleBox["uSymbolb1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["uSymbolb2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " due to the orthogonality condition. Therefore, the general solution in \
terms of the ",
  StyleBox["sol2Formb1 ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "and ",
  StyleBox["sol2Formb2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " can be written as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(sol2b = {
        u\_2 -> Function[{x, T\_0, T\_1, T\_2}, 
            uSymbolb1 . sol2Formb1 + uSymbolb2 . sol2Formb2 // Evaluate], 
        v\_2 -> Function[{x, T\_0, T\_1, T\_2}, 
            \(-I\)\ \[Omega]\_1\ uSymbolb1 . sol2Formb1 - 
                I\ \[Omega]\_2\ uSymbolb2 . sol2Formb2 // Evaluate]}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "The total solution is the sum of ",
  StyleBox["sol2a",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", ",
  StyleBox["sol2b",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", and the complex conjugate of ",
  StyleBox["sol2b",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Next, we solve for these undetermined coefficients. Substituting ",
  StyleBox["sol2a",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and equating the coefficients of ",
  StyleBox["sol2Forma",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we have"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(algEqa = 
      Flatten[\(Coefficient[
                    \(\(\(\(Subtract\ @@\ # /. sol2a\) /. intRule1\) //. 
                          intRule2\) /. modeshapes\) /. int -> Integrate, 
                    sol2Forma]\ &\)\ /@\ order2Eqm] == 0 /. 
          Exp[_\ T\_0 + _. ] -> 0 // Thread; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting some of the parameter values into ",
  StyleBox["algEqa ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "and solving for ",
  StyleBox["uSymbola",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["vSymbola",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(symbolaRule = 
      \(\(\(Solve[algEqa, uSymbola~Join~vSymbola]\)[\([1]\)] /. 
            \[CapitalOmega] -> 2  \[Omega]\_2\) /. frequencies\) /. values1
        \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Eta]\_1 \[Rule] 0, 
      \[Psi]\_1 \[Rule] 
        \(-\(\(\@3\ f\^2 + 
                1536\ \@3\ \[Pi]\^4\ \[Alpha]\ A\_1[T\_1, T\_2]\ 
                  A\&_\_1[T\_1, T\_2] + 
                1152\ \@3\ \[Pi]\^4\ \[Alpha]\ A\_2[T\_1, T\_2]\ 
                  A\&_\_2[T\_1, T\_2]\)\/\(2304\ \[Pi]\^4\ \@\[Alpha]\)\)\), 
      \[Eta]\_2 \[Rule] 
        \(-\(\(f\ \[Mu]\)\/\(9\ \@3\ \[Pi]\^2\ \@\[Alpha]\)\)\), 
      \[Eta]\_3 \[Rule] 
        \(-\(\(f\ \[Mu]\)\/\(9\ \@3\ \[Pi]\^2\ \@\[Alpha]\)\)\), 
      \[Eta]\_4 \[Rule] \(-\(\(I\ f\^2\)\/\(1440\ \[Pi]\^2\ \@\[Alpha]\)\)\), 
      \[Eta]\_5 \[Rule] \(I\ f\^2\)\/\(1440\ \[Pi]\^2\ \@\[Alpha]\), 
      \[Eta]\_6 \[Rule] 
        \(-2\)\ I\ \[Pi]\^2\ \@\[Alpha]\ A\&_\_2[T\_1, T\_2]\^2, 
      \[Eta]\_7 \[Rule] 2\ I\ \[Pi]\^2\ \@\[Alpha]\ A\_2[T\_1, T\_2]\^2, 
      \[Psi]\_2 \[Rule] 
        \(-\(\(I\ f\ \[Mu]\)\/\(216\ \[Pi]\^4\ \@\[Alpha]\)\)\), 
      \[Psi]\_3 \[Rule] \(I\ f\ \[Mu]\)\/\(216\ \[Pi]\^4\ \@\[Alpha]\), 
      \[Psi]\_4 \[Rule] f\^2\/\(23040\ \@3\ \[Pi]\^4\ \@\[Alpha]\), 
      \[Psi]\_5 \[Rule] f\^2\/\(23040\ \@3\ \[Pi]\^4\ \@\[Alpha]\), 
      \[Psi]\_6 \[Rule] \(\@\[Alpha]\ A\&_\_2[T\_1, T\_2]\^2\)\/\(4\ \@3\), 
      \[Psi]\_7 \[Rule] \(\@\[Alpha]\ A\_2[T\_1, T\_2]\^2\)\/\(4\ \@3\), 
      \[Eta]\_8 \[Rule] 
        \(-\(1\/16\)\)\ I\ \@\(3\/2\)\ f\ A\&_\_2[T\_1, T\_2], 
      \[Eta]\_9 \[Rule] 1\/16\ I\ \@\(3\/2\)\ f\ A\_2[T\_1, T\_2], 
      \[Eta]\_10 \[Rule] 
        \(-\(\(5\ I\ f\ A\&_\_1[T\_1, T\_2]\)\/\(9\ \@6\)\)\), 
      \[Eta]\_11 \[Rule] \(I\ f\ A\&_\_1[T\_1, T\_2]\)\/\@6, 
      \[Eta]\_12 \[Rule] \(-\(\(I\ f\ A\_1[T\_1, T\_2]\)\/\@6\)\), 
      \[Eta]\_13 \[Rule] \(5\ I\ f\ A\_1[T\_1, T\_2]\)\/\(9\ \@6\), 
      \[Eta]\_14 \[Rule] 
        \(-6\)\ I\ \[Pi]\^2\ \@\[Alpha]\ A\&_\_1[T\_1, T\_2]\ 
          A\&_\_2[T\_1, T\_2], 
      \[Eta]\_15 \[Rule] 
        6\ I\ \[Pi]\^2\ \@\[Alpha]\ A\_1[T\_1, T\_2]\ A\_2[T\_1, T\_2], 
      \[Psi]\_8 \[Rule] \(f\ A\&_\_2[T\_1, T\_2]\)\/\(192\ \@2\ \[Pi]\^2\), 
      \[Psi]\_9 \[Rule] \(f\ A\_2[T\_1, T\_2]\)\/\(192\ \@2\ \[Pi]\^2\), 
      \[Psi]\_10 \[Rule] \(f\ A\&_\_1[T\_1, T\_2]\)\/\(54\ \@2\ \[Pi]\^2\), 
      \[Psi]\_11 \[Rule] \(f\ A\&_\_1[T\_1, T\_2]\)\/\(18\ \@2\ \[Pi]\^2\), 
      \[Psi]\_12 \[Rule] \(f\ A\_1[T\_1, T\_2]\)\/\(18\ \@2\ \[Pi]\^2\), 
      \[Psi]\_13 \[Rule] \(f\ A\_1[T\_1, T\_2]\)\/\(54\ \@2\ \[Pi]\^2\), 
      \[Psi]\_14 \[Rule] 
        \(\@\[Alpha]\ A\&_\_1[T\_1, T\_2]\ A\&_\_2[T\_1, T\_2]\)\/\@3, 
      \[Psi]\_15 \[Rule] 
        \(\@\[Alpha]\ A\_1[T\_1, T\_2]\ A\_2[T\_1, T\_2]\)\/\@3}\)], "Output",\

  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Substituting ",
  StyleBox["sol2b",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into either of the two equations in ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", equating the coefficients of ",
  StyleBox["sol2Formb1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["sol2Formb2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", and solving for ",
  StyleBox["uSymbolb1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["uSymbolb2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we have"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(symbolbRule = 
      \(\(\(Solve[
                Coefficient[Subtract\ @@\ order2Eqm[\([1]\)] /. sol2b, 
                        sol2Formb1~Join~sol2Formb2] == 0 /. 
                    Exp[_\ T\_0 + _. ] -> 0 // Thread, 
                uSymbolb1~Join~uSymbolb2]\)[\([1]\)] /. 
            \[CapitalOmega] -> 2  \[Omega]\_2\) /. frequencies\) /. values1
        \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Psi]s\_\(1, 1\) \[Rule] 
        \(-\(\(I\ \[Mu]\ A\_1[T\_1, T\_2]\)\/\(2\ \@6\ \[Pi]\^2\)\)\), 
      \[Psi]s\_\(1, 2\) \[Rule] 
        \(-\(\(2\ \@\[Alpha]\ A\_2[T\_1, T\_2]\ A\&_\_1[T\_1, T\_2]\)\/\@3
                \)\), \[Psi]s\_\(2, 2\) \[Rule] 
        \(-\(\(I\ \[Mu]\ A\_2[T\_1, T\_2]\)\/\(4\ \@6\ \[Pi]\^2\)\)\), 
      \[Psi]s\_\(2, 3\) \[Rule] 
        \(-\(\(f\ A\&_\_2[T\_1, T\_2]\)\/\(96\ \@2\ \[Pi]\^2\)\)\), 
      \[Psi]s\_\(2, 1\) \[Rule] 
        \(-\(\(\@\[Alpha]\ A\_1[T\_1, T\_2]\^2\)\/\(4\ \@3\)\)\)}\)], "Output",\

  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Substituting these symbol values into ",
  StyleBox["sol2a",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["sol2b",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(sol2aForm = 
      \({u\_2[x, T\_0, T\_1, T\_2], v\_2[x, T\_0, T\_1, T\_2]} /. sol2a\) /. 
        symbolaRule; \n
    sol2bForm = 
      \({u\_2[x, T\_0, T\_1, T\_2], v\_2[x, T\_0, T\_1, T\_2]} /. sol2b\) /. 
        symbolbRule; \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2 = {
        u\_2 \[Rule] 
          Function[{x, T\_0, T\_1, T\_2}, 
            \(sol2aForm[\([1]\)] + sol2bForm[\([1]\)] + 
                  \((sol2bForm[\([1]\)] /. conjugateRule)\) // Expand\) // 
              Evaluate], 
        v\_2 \[Rule] 
          Function[{x, T\_0, T\_1, T\_2}, 
            \(sol2aForm[\([2]\)] + sol2bForm[\([2]\)] + 
                  \((sol2bForm[\([2]\)] /. conjugateRule)\) // Expand\) // 
              Evaluate]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_2 \[Rule] 
        Function[{x, T\_0, T\_1, T\_2}, 
          \(-\(\(f\^2\ Sin[\[Pi]\ x]\)\/\(768\ \@3\ \[Pi]\^4\ 
                    \@\[Alpha]\)\)\) + 
            \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ f\^2\ 
                Sin[\[Pi]\ x]\)\/\(23040\ \@3\ \[Pi]\^4\ \@\[Alpha]\) + 
            \(E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ f\^2\ 
                Sin[\[Pi]\ x]\)\/\(23040\ \@3\ \[Pi]\^4\ \@\[Alpha]\) - 
            \(I\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ f\ \[Mu]\ 
                Sin[\[Pi]\ x]\)\/\(216\ \[Pi]\^4\ \@\[Alpha]\) + 
            \(I\ E\^\(I\ T\_0\ \[CapitalOmega]\)\ f\ \[Mu]\ 
                Sin[\[Pi]\ x]\)\/\(216\ \[Pi]\^4\ \@\[Alpha]\) + 
            \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] + I\ T\_0\ \[Omega]\_1\)\ f\ 
                Sin[2\ \[Pi]\ x]\ A\_1[T\_1, T\_2]\)\/\(18\ \@2\ \[Pi]\^2\) + 
            \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ T\_0\ \[Omega]\_1\)\ f\ 
                Sin[2\ \[Pi]\ x]\ A\_1[T\_1, T\_2]\)\/\(54\ \@2\ \[Pi]\^2\) - 
            \(I\ E\^\(I\ T\_0\ \[Omega]\_1\)\ \[Mu]\ Sin[2\ \[Pi]\ x]\ 
                A\_1[T\_1, T\_2]\)\/\(2\ \@6\ \[Pi]\^2\) - 
            \(E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ \@\[Alpha]\ Sin[\[Pi]\ x]\ 
                A\_1[T\_1, T\_2]\^2\)\/\(4\ \@3\) - 
            \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] + I\ T\_0\ \[Omega]\_2\)\ f\ 
                Sin[\[Pi]\ x]\ A\_2[T\_1, T\_2]\)\/\(96\ \@2\ \[Pi]\^2\) + 
            \(E\^\(I\ T\_0\ \[CapitalOmega] + I\ T\_0\ \[Omega]\_2\)\ f\ 
                Sin[\[Pi]\ x]\ A\_2[T\_1, T\_2]\)\/\(192\ \@2\ \[Pi]\^2\) - 
            \(I\ E\^\(I\ T\_0\ \[Omega]\_2\)\ \[Mu]\ Sin[\[Pi]\ x]\ 
                A\_2[T\_1, T\_2]\)\/\(4\ \@6\ \[Pi]\^2\) + 
            \(E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ \@\[Alpha]\ 
                Sin[2\ \[Pi]\ x]\ A\_1[T\_1, T\_2]\ A\_2[T\_1, T\_2]\)\/\@3 + 
            \(E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ \@\[Alpha]\ Sin[\[Pi]\ x]\ 
                A\_2[T\_1, T\_2]\^2\)\/\(4\ \@3\) + 
            \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ T\_0\ \[Omega]\_1\)\ f\ 
                Sin[2\ \[Pi]\ x]\ A\&_\_1[T\_1, T\_2]\)\/\(54\ \@2\ 
                \[Pi]\^2\) + 
            \(E\^\(I\ T\_0\ \[CapitalOmega] - I\ T\_0\ \[Omega]\_1\)\ f\ 
                Sin[2\ \[Pi]\ x]\ A\&_\_1[T\_1, T\_2]\)\/\(18\ \@2\ 
                \[Pi]\^2\) + 
            \(I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ \[Mu]\ Sin[2\ \[Pi]\ x]\ 
                A\&_\_1[T\_1, T\_2]\)\/\(2\ \@6\ \[Pi]\^2\) - 
            \(2\ \@\[Alpha]\ Sin[\[Pi]\ x]\ A\_1[T\_1, T\_2]\ 
                A\&_\_1[T\_1, T\_2]\)\/\@3 - 
            \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                \@\[Alpha]\ Sin[2\ \[Pi]\ x]\ A\_2[T\_1, T\_2]\ 
                A\&_\_1[T\_1, T\_2]\)\/\@3 - 
            \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \@\[Alpha]\ Sin[\[Pi]\ x]\ 
                A\&_\_1[T\_1, T\_2]\^2\)\/\(4\ \@3\) + 
            \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ T\_0\ \[Omega]\_2\)\ f\ 
                Sin[\[Pi]\ x]\ A\&_\_2[T\_1, T\_2]\)\/\(192\ \@2\ 
                \[Pi]\^2\) - 
            \(E\^\(I\ T\_0\ \[CapitalOmega] - I\ T\_0\ \[Omega]\_2\)\ f\ 
                Sin[\[Pi]\ x]\ A\&_\_2[T\_1, T\_2]\)\/\(96\ \@2\ \[Pi]\^2\) + 
            \(I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ \[Mu]\ Sin[\[Pi]\ x]\ 
                A\&_\_2[T\_1, T\_2]\)\/\(4\ \@6\ \[Pi]\^2\) - 
            \(2\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                \@\[Alpha]\ Sin[2\ \[Pi]\ x]\ A\_1[T\_1, T\_2]\ 
                A\&_\_2[T\_1, T\_2]\)\/\@3 - 
            1\/2\ \@3\ \@\[Alpha]\ Sin[\[Pi]\ x]\ A\_2[T\_1, T\_2]\ 
              A\&_\_2[T\_1, T\_2] + 
            \(E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                \@\[Alpha]\ Sin[2\ \[Pi]\ x]\ A\&_\_1[T\_1, T\_2]\ 
                A\&_\_2[T\_1, T\_2]\)\/\@3 + 
            \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ \@\[Alpha]\ Sin[\[Pi]\ x]\ 
                A\&_\_2[T\_1, T\_2]\^2\)\/\(4\ \@3\)], 
      v\_2 \[Rule] 
        Function[{x, T\_0, T\_1, T\_2}, 
          \(-\(\(I\ E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ f\^2\ 
                    Sin[\[Pi]\ x]\)\/\(1440\ \[Pi]\^2\ \@\[Alpha]\)\)\) + 
            \(I\ E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ f\^2\ 
                Sin[\[Pi]\ x]\)\/\(1440\ \[Pi]\^2\ \@\[Alpha]\) - 
            \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ f\ \[Mu]\ 
                Sin[\[Pi]\ x]\)\/\(9\ \@3\ \[Pi]\^2\ \@\[Alpha]\) - 
            \(E\^\(I\ T\_0\ \[CapitalOmega]\)\ f\ \[Mu]\ Sin[\[Pi]\ x]\)\/\(9
                \ \@3\ \[Pi]\^2\ \@\[Alpha]\) - 
            \(I\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] + I\ T\_0\ \[Omega]\_1\)\ 
                f\ Sin[2\ \[Pi]\ x]\ A\_1[T\_1, T\_2]\)\/\@6 + 
            \(5\ I\ E\^\(I\ T\_0\ \[CapitalOmega] + I\ T\_0\ \[Omega]\_1\)\ f
                \ Sin[2\ \[Pi]\ x]\ A\_1[T\_1, T\_2]\)\/\(9\ \@6\) - 
            \(E\^\(I\ T\_0\ \[Omega]\_1\)\ \[Mu]\ Sin[2\ \[Pi]\ x]\ 
                \[Omega]\_1\ A\_1[T\_1, T\_2]\)\/\(2\ \@6\ \[Pi]\^2\) + 
            \(I\ E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ \@\[Alpha]\ Sin[\[Pi]\ x]\ 
                \[Omega]\_2\ A\_1[T\_1, T\_2]\^2\)\/\(4\ \@3\) + 
            1\/16\ I\ \@\(3\/2\)\ 
              E\^\(I\ T\_0\ \[CapitalOmega] + I\ T\_0\ \[Omega]\_2\)\ f\ 
              Sin[\[Pi]\ x]\ A\_2[T\_1, T\_2] - 
            \(I\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega] + I\ T\_0\ \[Omega]\_2\)\ 
                f\ Sin[\[Pi]\ x]\ \[Omega]\_2\ A\_2[T\_1, T\_2]\)\/\(96\ \@2\ 
                \[Pi]\^2\) - 
            \(E\^\(I\ T\_0\ \[Omega]\_2\)\ \[Mu]\ Sin[\[Pi]\ x]\ \[Omega]\_2\ 
                A\_2[T\_1, T\_2]\)\/\(4\ \@6\ \[Pi]\^2\) + 
            6\ I\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
              \[Pi]\^2\ \@\[Alpha]\ Sin[2\ \[Pi]\ x]\ A\_1[T\_1, T\_2]\ 
              A\_2[T\_1, T\_2] + 
            2\ I\ E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ \[Pi]\^2\ \@\[Alpha]\ 
              Sin[\[Pi]\ x]\ A\_2[T\_1, T\_2]\^2 - 
            \(5\ I\ E
                  \^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ T\_0\ \[Omega]\_1\)\ 
                f\ Sin[2\ \[Pi]\ x]\ A\&_\_1[T\_1, T\_2]\)\/\(9\ \@6\) + 
            \(I\ E\^\(I\ T\_0\ \[CapitalOmega] - I\ T\_0\ \[Omega]\_1\)\ f\ 
                Sin[2\ \[Pi]\ x]\ A\&_\_1[T\_1, T\_2]\)\/\@6 - 
            \(E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ \[Mu]\ Sin[2\ \[Pi]\ x]\ 
                \[Omega]\_1\ A\&_\_1[T\_1, T\_2]\)\/\(2\ \@6\ \[Pi]\^2\) + 
            \(2\ I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                \@\[Alpha]\ Sin[2\ \[Pi]\ x]\ \[Omega]\_1\ A\_2[T\_1, T\_2]\ 
                A\&_\_1[T\_1, T\_2]\)\/\@3 - 
            \(I\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \@\[Alpha]\ 
                Sin[\[Pi]\ x]\ \[Omega]\_2\ A\&_\_1[T\_1, T\_2]\^2\)\/\(4\ 
                \@3\) - 
            1\/16\ I\ \@\(3\/2\)\ 
              E\^\(\(-I\)\ T\_0\ \[CapitalOmega] - I\ T\_0\ \[Omega]\_2\)\ f\ 
              Sin[\[Pi]\ x]\ A\&_\_2[T\_1, T\_2] + 
            \(I\ E\^\(I\ T\_0\ \[CapitalOmega] - I\ T\_0\ \[Omega]\_2\)\ f\ 
                Sin[\[Pi]\ x]\ \[Omega]\_2\ A\&_\_2[T\_1, T\_2]\)\/\(96\ \@2\ 
                \[Pi]\^2\) - 
            \(E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ \[Mu]\ Sin[\[Pi]\ x]\ 
                \[Omega]\_2\ A\&_\_2[T\_1, T\_2]\)\/\(4\ \@6\ \[Pi]\^2\) - 
            \(2\ I\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                \@\[Alpha]\ Sin[2\ \[Pi]\ x]\ \[Omega]\_1\ A\_1[T\_1, T\_2]\ 
                A\&_\_2[T\_1, T\_2]\)\/\@3 - 
            6\ I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
              \[Pi]\^2\ \@\[Alpha]\ Sin[2\ \[Pi]\ x]\ A\&_\_1[T\_1, T\_2]\ 
              A\&_\_2[T\_1, T\_2] - 
            2\ I\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ \[Pi]\^2\ \@\[Alpha]\ 
              Sin[\[Pi]\ x]\ A\&_\_2[T\_1, T\_2]\^2]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["9.1.3 Solvability Conditions", "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting ",
  StyleBox["sol1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", ",
  StyleBox["\[CapitalPsi]sol",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", ",
  StyleBox["sol2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", and some of the parameter values into ",
  StyleBox["eqEps[[3]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(order3Eq = 
        \((linearSys /. u_\_1 -> u\_3)\) == 
              \((\(\(\(\(\(\((linearSys /. u_\_1 -> u\_3)\) - 
                                \((\(#[\([1]\)]\ &\)\ /@\ eqEps[\([3]\)])
                                  \) /. sol1\) /. \[CapitalPsi]sol\) /. 
                          \[CapitalGamma]Rule\) /. sol2\) /. intRule1\) //. 
                    intRule2 // Expand)\) /. values1 // Thread; \) // Timing
      \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({21.1410000000005338`\ Second, Null}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Collecting the terms that may lead to secular terms, the terms \
proportional to ",
  Cell[BoxData[
      \(E\^\(I\ \[Omega]\_i\ T\_0\)\)]],
  ", we have"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(ST21 = 
      \(Coefficient[\(#[\([2]\)]\ &\)\ /@\ order3Eq /. expRule1[1], 
            E\^\(I\ \[Omega]\_1\ T\_0\)] /. modeshapes\) /. int -> Integrate; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(ST22 = 
      \(Coefficient[\(#[\([2]\)]\ &\)\ /@\ order3Eq /. expRule1[2], 
            E\^\(I\ \[Omega]\_2\ T\_0\)] /. modeshapes\) /. int -> Integrate; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Demanding that ",
  StyleBox["ST21",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  StyleBox[" ",
    FontColor->RGBColor[1, 0, 1]],
  "be orthogonal to the ",
  StyleBox["adjointC[[1]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain the solvability condition"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"SCond21", "=", 
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    RowBox[{
                      RowBox[{"Solve", "[", 
                        RowBox[{
                        \(\((\(int[adjointC[\([1]\)] . ST21, {x, 0, 1}] /. 
                                  intRule1\) //. intRule2)\) == 0\), ",", 
                          RowBox[{
                            SubsuperscriptBox["A", "1", 
                              TagBox[\((0, 1)\),
                                Derivative],
                              MultilineFunction->None], "[", \(T\_1, T\_2\), 
                            "]"}]}], "]"}], "[", \([1]\), "]"}], "/.", 
                    "modeshapes"}], "/.", \(int -> Integrate\)}], "/.", 
                "SCond1"}], "/.", "frequencies"}], "/.", "values1"}], "//", 
          "ExpandAll"}]}], ";", "\n", \(SCond21 /. displayRule\)}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        InterpretationBox[\(D\_2\[InvisibleSpace]A\_1\),
          SequenceForm[ 
            Subscript[ D, 2], 
            Subscript[ A, 1]],
          Editable->False], "\[Rule]", 
        \(\(13\ I\ f\^2\ A\_1\)\/\(648\ \@3\ \[Pi]\^2\) - 
          \(I\ \[Mu]\^2\ A\_1\)\/\(4\ \@3\ \[Pi]\^2\) + 
          I\ \@3\ \[Pi]\^2\ \[Alpha]\ A\_1\%2\ A\&_\_1 - 
          \@\(3\/2\)\ E\^\(I\ T\_1\ \[Sigma]\_1\)\ \@\[Alpha]\ \[Mu]\ A\_2\ 
            A\&_\_1 - 
          \(8\ I\ \[Pi]\^2\ \[Alpha]\ A\_1\ A\_2\ A\&_\_2\)\/\@3 + 
          \(31\ I\ E\^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2\)\ f\ 
              \@\[Alpha]\ A\&_\_1\ A\&_\_2\)\/\(72\ \@2\)\)}], "}"}]], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Demanding that ",
  StyleBox["ST22",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  StyleBox[" ",
    FontColor->RGBColor[1, 0, 1]],
  "be orthogonal to the ",
  StyleBox["adjointC[[2]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain the solvability condition"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"SCond22", "=", 
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    RowBox[{
                      RowBox[{
                        RowBox[{"Solve", "[", 
                          RowBox[{
                          \(\((\(int[adjointC[\([2]\)] . ST22, {x, 0, 1}] /. 
                                    intRule1\) //. intRule2)\) == 0\), ",", 
                            RowBox[{
                              SubsuperscriptBox["A", "2", 
                                TagBox[\((0, 1)\),
                                  Derivative],
                                MultilineFunction->None], "[", \(T\_1, 
                              T\_2\), "]"}]}], "]"}], "[", \([1]\), "]"}], 
                      "/.", "modeshapes"}], "/.", \(int -> Integrate\)}], 
                  "/.", "SCond1"}], "/.", 
                \(\[CapitalOmega] -> 2  \[Omega]\_2\)}], "/.", 
              "frequencies"}], "/.", "values1"}], "//", "ExpandAll"}]}], ";", 
      "\n", \(SCond22 /. displayRule\)}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        InterpretationBox[\(D\_2\[InvisibleSpace]A\_2\),
          SequenceForm[ 
            Subscript[ D, 2], 
            Subscript[ A, 2]],
          Editable->False], "\[Rule]", 
        \(1\/4\ \@\(3\/2\)\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_1\)\ \@\[Alpha]\ 
            \[Mu]\ A\_1\%2 - \(19\ I\ f\^2\ A\_2\)\/\(9216\ \@3\ \[Pi]\^2\) - 
          \(I\ \[Mu]\^2\ A\_2\)\/\(8\ \@3\ \[Pi]\^2\) - 
          \(4\ I\ \[Pi]\^2\ \[Alpha]\ A\_1\ A\_2\ A\&_\_1\)\/\@3 + 
          \(31\ I\ E\^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2\)\ f\ 
              \@\[Alpha]\ A\&_\_1\%2\)\/\(288\ \@2\) - 
          \(5\ E\^\(I\ T\_1\ \[Sigma]\_2\)\ f\ \[Mu]\ A\&_\_2\)\/\(288\ 
              \[Pi]\^2\) - 
          1\/2\ I\ \@3\ \[Pi]\^2\ \[Alpha]\ A\_2\%2\ A\&_\_2\)}], "}"}]], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
Because in the absence of damping the system is conservative, the modulation \
equations, solvability conditions, must satisfy symmetry conditions. To check \
for these symmetries, we let\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(formList1a = {A\&_\_1[T\_1, T\_2]\ A\&_\_2[T\_1, T\_2], 
        A\_1[T\_1, T\_2]\ A\_2[T\_1, T\_2]\ A\&_\_2[T\_1, T\_2]}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(a1coefs = {s\_11, s\_12} -> 
          Coefficient[\((2\ \[Omega]\_1\ I)\)\ SCond21[\([1, 2]\)], 
            formList1a] // Thread\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({s\_11 \[Rule] 
        \(-\(\(31\ E\^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2\)\ f\ 
                \@\[Alpha]\ \[Omega]\_1\)\/\(36\ \@2\)\)\), 
      s\_12 \[Rule] \(16\ \[Pi]\^2\ \[Alpha]\ \[Omega]\_1\)\/\@3}\)], "Output",\

  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[BoxData[
    \(\(formList2a = {
        A\_1[T\_1, T\_2]\ A\_2[T\_1, T\_2]\ A\&_\_1[T\_1, T\_2], 
        A\&_\_1[T\_1, T\_2]\^2}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(a2coefs = {s\_21, s\_22} -> 
          Coefficient[\((2\ \[Omega]\_2\ I)\)\ SCond22[\([1, 2]\)], 
            formList2a] // Thread\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({s\_21 \[Rule] \(8\ \[Pi]\^2\ \[Alpha]\ \[Omega]\_2\)\/\@3, 
      s\_22 \[Rule] 
        \(-\(\(31\ E\^\(I\ T\_1\ \[Sigma]\_1 + I\ T\_1\ \[Sigma]\_2\)\ f\ 
                \@\[Alpha]\ \[Omega]\_2\)\/\(144\ \@2\)\)\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "The symmetry condition demands that ",
  Cell[BoxData[
      \(s\_12 = s\_21\)]],
  ", which is true because"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\(s\_12 - s\_21 /. a1coefs\) /. a2coefs\) /. frequencies\) /. 
      values1\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(0\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["9.2 Four-Mode Interactions in Suspended Cables", "Section",
  CellMargins->{{Inherited, 17.4375}, {Inherited, Inherited}},
  Evaluatable->False,
  TextAlignment->Left,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],

Cell["\<\
We determine a second-order uniform asymptotic expansion of the \
three-dimensional response of a suspended cable to a transverse harmonic \
distributed excitation of one of the first two vertical or horizontal modes \
when their frequencies are in the ratio of either two-to-one or one-to-one \
and no other internal resonance is activated. Benedettini, Rega, and Alaggio \
(1995) derived nondimensional equations governing three-dimensional \
finite-amplitude vibrations of a suspended homogeneous elastic cable excited \
by harmonic distributed vertical and horizontal loads. The time derivatives \
are expressed in second-order form. As discussed in Chapter 5, second- and \
higher-order treatments of such equations lead to inconsistent results unless \
the time derivatives are expressed in first-order rather than second-order \
form. Therefore, we rewrite these equations as\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\[Delta]\_\(i_Integer, j_Integer\) := If[i == j, 1, 0]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(eq1 = Table[u\_\(j, t\) - v\_j == 0, {j, 2}]; \n
    eq2 = Table[
        v\_\(j, t\) + 2\ \[Mu]\_j\ v\_j - u\_\(j, x, x\) - 
            \[Alpha]\ 
              \((b\ \(y\^\[DoublePrime]\)[x]\ \[Delta]\_\(1, j\) + 
                  u\_\(j, x, x\))\)\ 
              \(\[Integral]\_0\%1
                  \((b\ \(y\^\[Prime]\)[x]\ u\_\(1, x\) + 
                      1\/2\ \((u\_\(1, x\)\%2 + u\_\(2, x\)\%2)\))\) 
                  \[DifferentialD]x\) == 
          P\_j[x]\ Cos[\[CapitalOmega]\ t + \[Tau]\_j], {j, 2}]; \)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(EOM = 
      Transpose[{eq1, eq2}] /. {u_\_\(s_, m__\) :> \[PartialD]\_m u\_s[x, t], 
            v\_s_ :> v\_s[x, t]} // Flatten\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{\(-v\_1[x, t]\), "+", 
            RowBox[{
              SubsuperscriptBox["u", "1", 
                TagBox[\((0, 1)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t\), "]"}]}], "==", 
          "0"}], ",", 
        RowBox[{
          RowBox[{\(2\ \[Mu]\_1\ v\_1[x, t]\), "+", 
            RowBox[{
              SubsuperscriptBox["v", "1", 
                TagBox[\((0, 1)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t\), "]"}], "-", 
            RowBox[{
              SubsuperscriptBox["u", "1", 
                TagBox[\((2, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t\), "]"}], "-", 
            RowBox[{"\[Alpha]", " ", 
              RowBox[{"(", 
                RowBox[{\(\[Integral]\_0\%1\), 
                  RowBox[{
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{"b", " ", 
                          RowBox[{
                            SuperscriptBox["y", "\[Prime]",
                              MultilineFunction->None], "[", "x", "]"}], 
                          " ", 
                          RowBox[{
                            SubsuperscriptBox["u", "1", 
                              TagBox[\((1, 0)\),
                                Derivative],
                              MultilineFunction->None], "[", \(x, t\), 
                            "]"}]}], "+", 
                        RowBox[{\(1\/2\), " ", 
                          RowBox[{"(", 
                            RowBox[{
                              SuperscriptBox[
                                RowBox[{
                                  SubsuperscriptBox["u", "1", 
                                    TagBox[\((1, 0)\),
                                      Derivative],
                                    MultilineFunction->None], "[", \(x, t\), 
                                  "]"}], "2"], "+", 
                              SuperscriptBox[
                                RowBox[{
                                  SubsuperscriptBox["u", "2", 
                                    TagBox[\((1, 0)\),
                                      Derivative],
                                    MultilineFunction->None], "[", \(x, t\), 
                                  "]"}], "2"]}], ")"}]}]}], ")"}], 
                    \(\[DifferentialD]x\)}]}], ")"}], " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{"b", " ", 
                    RowBox[{
                      SuperscriptBox["y", "\[DoublePrime]",
                        MultilineFunction->None], "[", "x", "]"}]}], "+", 
                  RowBox[{
                    SubsuperscriptBox["u", "1", 
                      TagBox[\((2, 0)\),
                        Derivative],
                      MultilineFunction->None], "[", \(x, t\), "]"}]}], 
                ")"}]}]}], "==", 
          \(Cos[t\ \[CapitalOmega] + \[Tau]\_1]\ P\_1[x]\)}], ",", 
        RowBox[{
          RowBox[{\(-v\_2[x, t]\), "+", 
            RowBox[{
              SubsuperscriptBox["u", "2", 
                TagBox[\((0, 1)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t\), "]"}]}], "==", 
          "0"}], ",", 
        RowBox[{
          RowBox[{\(2\ \[Mu]\_2\ v\_2[x, t]\), "+", 
            RowBox[{
              SubsuperscriptBox["v", "2", 
                TagBox[\((0, 1)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t\), "]"}], "-", 
            RowBox[{
              SubsuperscriptBox["u", "2", 
                TagBox[\((2, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t\), "]"}], "-", 
            RowBox[{"\[Alpha]", " ", 
              RowBox[{"(", 
                RowBox[{\(\[Integral]\_0\%1\), 
                  RowBox[{
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{"b", " ", 
                          RowBox[{
                            SuperscriptBox["y", "\[Prime]",
                              MultilineFunction->None], "[", "x", "]"}], 
                          " ", 
                          RowBox[{
                            SubsuperscriptBox["u", "1", 
                              TagBox[\((1, 0)\),
                                Derivative],
                              MultilineFunction->None], "[", \(x, t\), 
                            "]"}]}], "+", 
                        RowBox[{\(1\/2\), " ", 
                          RowBox[{"(", 
                            RowBox[{
                              SuperscriptBox[
                                RowBox[{
                                  SubsuperscriptBox["u", "1", 
                                    TagBox[\((1, 0)\),
                                      Derivative],
                                    MultilineFunction->None], "[", \(x, t\), 
                                  "]"}], "2"], "+", 
                              SuperscriptBox[
                                RowBox[{
                                  SubsuperscriptBox["u", "2", 
                                    TagBox[\((1, 0)\),
                                      Derivative],
                                    MultilineFunction->None], "[", \(x, t\), 
                                  "]"}], "2"]}], ")"}]}]}], ")"}], 
                    \(\[DifferentialD]x\)}]}], ")"}], " ", 
              RowBox[{
                SubsuperscriptBox["u", "2", 
                  TagBox[\((2, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}]}], "==", 
          \(Cos[t\ \[CapitalOmega] + \[Tau]\_2]\ P\_2[x]\)}]}], "}"}]], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[BoxData[
    \(\(yRule = {y -> \((4\ #\ \((1 - #)\)\ &)\)}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["Moreover, we write the associated boundary conditions as", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(BC = {u\_j[0, t] == 0, u\_j[1, t] == 0}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Here, the index ",
  Cell[BoxData[
      \(TraditionalForm\`j = 1\)]],
  " refers to the vertical component of the displacement and ",
  Cell[BoxData[
      \(TraditionalForm\`j = 2\)]],
  " refers to the horizontal component of the displacement; the ",
  Cell[BoxData[
      \(TraditionalForm\`\[Mu]\_j\)]],
  " are the viscous damping coefficients; the ",
  Cell[BoxData[
      \(TraditionalForm\`P\_j[x]\)]],
  " are the distributed amplitudes of the excitation with the frequency ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega]\)]],
  ";  ",
  Cell[BoxData[
      \(TraditionalForm\`\[Delta]\_\(i, \ j\)\)]],
  " denotes the Kronecker delta; and ",
  Cell[BoxData[
      \(TraditionalForm\`b\ y[x]\)]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`y[x] = 4\ x\ \((1 - x)\)\)]],
  ", defined in the ",
  StyleBox["yRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", is the initial static configuration. The spatial and temporal variables \
were nondimensionalized using the span of the cable ",
  Cell[BoxData[
      \(TraditionalForm\`\[ScriptL]\)]],
  " and the characteristic time ",
  Cell[BoxData[
      \(TraditionalForm\`\[ScriptL] \@\( \[CurlyRho]/E\)\)]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`\[CurlyRho]\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`E\)]],
  " are the cable density and modulous of elasticity, respectively."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "We seek an asymptotic expansion of the response of the cable when its span \
is such that the first vertical and horizontal natural frequencies are in the \
ratio of two-to-one; that is, ",
  Cell[BoxData[
      RowBox[{
        StyleBox[\(b\^2\ \[Alpha]\),
          FontSlant->"Italic"], "\[TildeTilde]", \(\[Pi]\^2/16\)}]]],
  ". When ",
  Cell[BoxData[
      RowBox[{
        StyleBox[\(b\^2\ \[Alpha]\),
          FontSlant->"Italic"], "=", \(\[Pi]\^2/16\)}]]],
  ", the natural frequencies are"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(params = {\[Omega]\_\(j_ /; j != 3\) :> 2\ \[Pi], 
        \[Omega]\_3 -> \[Pi], b\^2\ \[Alpha] -> \[Pi]\^2/16}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["and the corresponding normalized modeshapes are", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(modeshapes = {
        \[CapitalPhi]\_1 -> 
          \((\(\@\(2\/3\)\) \((1 - Cos[2  \[Pi]\ #])\)\ &)\), 
        \[CapitalPhi]\_2 -> \((\@2\ Sin[2  \[Pi]\ #]\ &)\), 
        \[CapitalPhi]\_3 -> \((\@2\ Sin[\[Pi]\ #]\ &)\), 
        \[CapitalPhi]\_4 -> \((\@2\ Sin[2  \[Pi]\ #]\ &)\)}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
We use the method of multiple scales and seek a second-order uniform \
asymptotic expansion of the response of the cable to a primary-resonance \
excitation of the first vertical mode in the form\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(multiScales = {u_\_j_[x, t] -> u\_j[x, T\_0, T\_1, T\_2], 
        \(\(Derivative[m_, n_]\)[u_]\)[x, t] -> 
          \(dt[n]\)[D[u[x, T\_0, T\_1, T\_2], {x, m}]], t -> T\_0}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(solRule = {
        u\_i_ -> 
          \((Evaluate[Sum[\[Epsilon]\^j\ u\_\(i, j\)[#1, #2, #3, #4], {j, 3}]]
                \ &)\), 
        v\_i_ -> 
          \((Evaluate[Sum[\[Epsilon]\^j\ v\_\(i, j\)[#1, #2, #3, #4], {j, 3}]]
                \ &)\)}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
Taking into account the resonance conditions, we scale the damping and \
forcing terms as\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(scaling = {\[Mu]\_j_ -> \(\[Epsilon]\^2\) \[Mu]\_j, 
        P\_j_[x] -> \[Epsilon]\^3\ P\_j[x]}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "where the forcing has been scaled at order ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon]\^3\)]],
  " so that its influence first appears at the same order as the nonlinear \
shift in the frequencies in the absence of the internal resonance."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
We consider the case in which the orders of magnitude of the forcing levels \
for both the vertical and horizontal motions are the same. Otherwise, a \
primary resonance of the vertical modes (current study) could also initiate a \
subharmonic resonance of order one-half  of the first horizontal mode and a \
primary resonance of the second horizontal mode at different levels of \
approximation.\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting the ",
  StyleBox["multiScales",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", ",
  StyleBox["solRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", and ",
  StyleBox["scaling",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["EOM",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", expanding the result for small \[Epsilon], and discarding terms of order \
higher than ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon]\^3\)]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(eq92a = 
      \((\((\(\(\(EOM /. Integrate -> int\) /. multiScales\) /. solRule\) /. 
                    scaling // ExpandAll)\) //. intRule2 // ExpandAll)\) /. 
        \[Epsilon]\^\(n_ /; n > 3\) -> 0; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Equating coefficients of like powers of \[Epsilon] in ",
  StyleBox["eq92a",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(eqEps = 
      \(\(Rest[Thread[CoefficientList[Subtract\ @@\ #, \[Epsilon]] == 0]]\ &
              \)\ /@\ eq92a // Transpose\) // TrigToExp; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell["9.2.1 First-Order Solution", "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell["The homogeneous parts of the first-order equations are", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((linearSys = \(#[\([1]\)]\ &\)\ /@\ eqEps[\([1]\)])\) /. displayRule
      \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          InterpretationBox[
            RowBox[{\(D\_0\), "\[InvisibleSpace]", 
              SubsuperscriptBox["u", \(1, 1\), 
                InterpretationBox["\[Null]",
                  SequenceForm[ ],
                  Editable->False]]}],
            SequenceForm[ 
              Subscript[ D, 0], 
              Power[ 
                Subscript[ u, 1, 1], 
                SequenceForm[ ]]],
            Editable->False], "-", \(v\_\(1, 1\)\)}], ",", 
        RowBox[{
          RowBox[{"-", 
            RowBox[{"(", 
              InterpretationBox[
                RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                  SubsuperscriptBox["u", \(1, 1\), 
                    InterpretationBox[\("'"\[InvisibleSpace]"'"\),
                      SequenceForm[ "'", "'"],
                      Editable->False]]}],
                SequenceForm[ "", 
                  Power[ 
                    Subscript[ u, 1, 1], 
                    SequenceForm[ "'", "'"]]],
                Editable->False], ")"}]}], "+", 
          InterpretationBox[
            RowBox[{\(D\_0\), "\[InvisibleSpace]", 
              SubsuperscriptBox["v", \(1, 1\), 
                InterpretationBox["\[Null]",
                  SequenceForm[ ],
                  Editable->False]]}],
            SequenceForm[ 
              Subscript[ D, 0], 
              Power[ 
                Subscript[ v, 1, 1], 
                SequenceForm[ ]]],
            Editable->False], "-", 
          RowBox[{\(b\^2\), " ", "\[Alpha]", " ", 
            RowBox[{"int", "[", 
              RowBox[{
                RowBox[{
                  RowBox[{"(", 
                    InterpretationBox[
                      RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                        SubsuperscriptBox["u", \(1, 1\), 
                          InterpretationBox["\<\"'\"\>",
                            SequenceForm[ "'"],
                            Editable->False]]}],
                      SequenceForm[ "", 
                        Power[ 
                          Subscript[ u, 1, 1], 
                          SequenceForm[ "'"]]],
                      Editable->False], ")"}], " ", 
                  RowBox[{
                    SuperscriptBox["y", "\[Prime]",
                      MultilineFunction->None], "[", "x", "]"}]}], ",", 
                \({x, 0, 1}\)}], "]"}], " ", 
            RowBox[{
              SuperscriptBox["y", "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}]}]}], ",", 
        RowBox[{
          InterpretationBox[
            RowBox[{\(D\_0\), "\[InvisibleSpace]", 
              SubsuperscriptBox["u", \(2, 1\), 
                InterpretationBox["\[Null]",
                  SequenceForm[ ],
                  Editable->False]]}],
            SequenceForm[ 
              Subscript[ D, 0], 
              Power[ 
                Subscript[ u, 2, 1], 
                SequenceForm[ ]]],
            Editable->False], "-", \(v\_\(2, 1\)\)}], ",", 
        RowBox[{
          RowBox[{"-", 
            RowBox[{"(", 
              InterpretationBox[
                RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                  SubsuperscriptBox["u", \(2, 1\), 
                    InterpretationBox[\("'"\[InvisibleSpace]"'"\),
                      SequenceForm[ "'", "'"],
                      Editable->False]]}],
                SequenceForm[ "", 
                  Power[ 
                    Subscript[ u, 2, 1], 
                    SequenceForm[ "'", "'"]]],
                Editable->False], ")"}]}], "+", 
          InterpretationBox[
            RowBox[{\(D\_0\), "\[InvisibleSpace]", 
              SubsuperscriptBox["v", \(2, 1\), 
                InterpretationBox["\[Null]",
                  SequenceForm[ ],
                  Editable->False]]}],
            SequenceForm[ 
              Subscript[ D, 0], 
              Power[ 
                Subscript[ v, 2, 1], 
                SequenceForm[ ]]],
            Editable->False]}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "The first-order problems are identical to the linear eigenvalue problems. \
To account for the interactions arising from the multiple internal resonances \
and the primary resonance, we include the lowest two modes in each plane;  \
the other modes will decay due to damping. Hence, the solution of ",
  StyleBox["eqEps[[1]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " can be expressed as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(sol1u = {
        u\_\(1, 1\) -> 
          Function[{x, T\_0, T\_1, T\_2}, 
            Sum[A\_i[T\_1, T\_2]\ \[CapitalPhi]\_i[x]\ 
                    Exp[I\ \[Omega]\_i\ T\_0] + 
                  A\&_\_i[T\_1, T\_2]\ \[CapitalPhi]\_i[x]\ 
                    Exp[\(-I\)\ \[Omega]\_i\ T\_0], {i, 1, 2}] // Evaluate], 
        u\_\(2, 1\) -> 
          Function[{x, T\_0, T\_1, T\_2}, 
            Sum[A\_i[T\_1, T\_2]\ \[CapitalPhi]\_i[x]\ 
                    Exp[I\ \[Omega]\_i\ T\_0] + 
                  A\&_\_i[T\_1, T\_2]\ \[CapitalPhi]\_i[x]\ 
                    Exp[\(-I\)\ \[Omega]\_i\ T\_0], {i, 3, 4}] // Evaluate]}; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(sol1v = 
      Table[v\_\(k, 1\) \[Rule] 
          Function[{x, T\_0, T\_1, T\_2}, 
            D[u\_\(k, 1\)[x, T\_0, T\_1, T\_2], T\_0] /. sol1u // Evaluate], {
          k, 2}]; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1 = Join[sol1u, sol1v]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_\(1, 1\) \[Rule] 
        Function[{x, T\_0, T\_1, T\_2}, 
          E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1[T\_1, T\_2]\ 
              \[CapitalPhi]\_1[x] + 
            E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2[T\_1, T\_2]\ 
              \[CapitalPhi]\_2[x] + 
            E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ \[CapitalPhi]\_1[x]\ 
              A\&_\_1[T\_1, T\_2] + 
            E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ \[CapitalPhi]\_2[x]\ 
              A\&_\_2[T\_1, T\_2]], 
      u\_\(2, 1\) \[Rule] 
        Function[{x, T\_0, T\_1, T\_2}, 
          E\^\(I\ T\_0\ \[Omega]\_3\)\ A\_3[T\_1, T\_2]\ 
              \[CapitalPhi]\_3[x] + 
            E\^\(I\ T\_0\ \[Omega]\_4\)\ A\_4[T\_1, T\_2]\ 
              \[CapitalPhi]\_4[x] + 
            E\^\(\(-I\)\ T\_0\ \[Omega]\_3\)\ \[CapitalPhi]\_3[x]\ 
              A\&_\_3[T\_1, T\_2] + 
            E\^\(\(-I\)\ T\_0\ \[Omega]\_4\)\ \[CapitalPhi]\_4[x]\ 
              A\&_\_4[T\_1, T\_2]], 
      v\_\(1, 1\) \[Rule] 
        Function[{x, T\_0, T\_1, T\_2}, 
          I\ E\^\(I\ T\_0\ \[Omega]\_1\)\ \[Omega]\_1\ A\_1[T\_1, T\_2]\ 
              \[CapitalPhi]\_1[x] + 
            I\ E\^\(I\ T\_0\ \[Omega]\_2\)\ \[Omega]\_2\ A\_2[T\_1, T\_2]\ 
              \[CapitalPhi]\_2[x] - 
            I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ \[Omega]\_1\ 
              \[CapitalPhi]\_1[x]\ A\&_\_1[T\_1, T\_2] - 
            I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ \[Omega]\_2\ 
              \[CapitalPhi]\_2[x]\ A\&_\_2[T\_1, T\_2]], 
      v\_\(2, 1\) \[Rule] 
        Function[{x, T\_0, T\_1, T\_2}, 
          I\ E\^\(I\ T\_0\ \[Omega]\_3\)\ \[Omega]\_3\ A\_3[T\_1, T\_2]\ 
              \[CapitalPhi]\_3[x] + 
            I\ E\^\(I\ T\_0\ \[Omega]\_4\)\ \[Omega]\_4\ A\_4[T\_1, T\_2]\ 
              \[CapitalPhi]\_4[x] - 
            I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_3\)\ \[Omega]\_3\ 
              \[CapitalPhi]\_3[x]\ A\&_\_3[T\_1, T\_2] - 
            I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_4\)\ \[Omega]\_4\ 
              \[CapitalPhi]\_4[x]\ A\&_\_4[T\_1, T\_2]]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi]\_1[x]\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi]\_2[x]\)]],
  " are the lowest symmetric and antisymmetric vertical eigenmodes, and ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi]\_3[x]\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi]\_4[x]\)]],
  " are the lowest symmetric and antisymmetric horizontal eigenmodes. The ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi]\_n[x]\)]],
  " are orthogonal; they are normalized so that they satisfy the \
orthonormality condition ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Integral]\_0\%1 \[CapitalPhi]\_n[x]\ \[CapitalPhi]\_m[x]\ 
            \[DifferentialD]x = \[Delta]\_\(n, m\)\)]],
  "."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell["Because the problem is self-adjoint, we have", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(adjoint = 
      Table[{\(-I\)\ \[Omega]\_k\ \[CapitalPhi]\_k[x], \[CapitalPhi]\_k[x]}, {
          k, 4}]; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["whose complex conjugate is", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(adjointC = adjoint /. conjugateRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{I\ \[Omega]\_1\ \[CapitalPhi]\_1[x], \[CapitalPhi]\_1[x]}, {
        I\ \[Omega]\_2\ \[CapitalPhi]\_2[x], \[CapitalPhi]\_2[x]}, {
        I\ \[Omega]\_3\ \[CapitalPhi]\_3[x], \[CapitalPhi]\_3[x]}, {
        I\ \[Omega]\_4\ \[CapitalPhi]\_4[x], \[CapitalPhi]\_4[x]}}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["9.2.2 Second-Order Solution", "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting ",
  StyleBox["sol1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["eqEps[[2]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(order2Eq = 
      \((linearSys /. u_\_\(k_, 1\) -> u\_\(k, 2\))\) == 
          \((\(\(\(\(\(\((linearSys /. u_\_\(k_, 1\) -> u\_\(k, 2\))\) - 
                            \((\(#[\([1]\)]\ &\)\ /@\ eqEps[\([2]\)])\) /. 
                          sol1\) /. intRule1\) //. intRule2\) /. modeshapes
                    \) /. yRule\) /. int -> Integrate // Expand)\) // Thread; 
    \norder2Eq /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            InterpretationBox[
              RowBox[{\(D\_0\), "\[InvisibleSpace]", 
                SubsuperscriptBox["u", \(1, 2\), 
                  InterpretationBox["\[Null]",
                    SequenceForm[ ],
                    Editable->False]]}],
              SequenceForm[ 
                Subscript[ D, 0], 
                Power[ 
                  Subscript[ u, 1, 2], 
                  SequenceForm[ ]]],
              Editable->False], "-", \(v\_\(1, 2\)\)}], "==", 
          RowBox[{
            RowBox[{
            \(-\@\(2\/3\)\), " ", \(E\^\(I\ T\_0\ \[Omega]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 1]],
                  Editable->False], ")"}]}], "+", 
            RowBox[{
            \(\@\(2\/3\)\), " ", \(E\^\(I\ T\_0\ \[Omega]\_1\)\), " ", 
              \(Cos[2\ \[Pi]\ x]\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 1]],
                  Editable->False], ")"}]}], "-", 
            RowBox[{
            \(\@\(2\/3\)\), " ", \(E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 1]],
                  Editable->False], ")"}]}], "+", 
            RowBox[{
            \(\@\(2\/3\)\), " ", \(E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\), " ", 
              \(Cos[2\ \[Pi]\ x]\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 1]],
                  Editable->False], ")"}]}], "-", 
            RowBox[{\(\@2\), " ", \(E\^\(I\ T\_0\ \[Omega]\_2\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 2]],
                  Editable->False], ")"}], " ", \(Sin[2\ \[Pi]\ x]\)}], "-", 
            RowBox[{\(\@2\), " ", \(E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 2]],
                  Editable->False], ")"}], " ", \(Sin[2\ \[Pi]\ x]\)}]}]}], 
        ",", 
        RowBox[{
          RowBox[{
            RowBox[{"-", 
              RowBox[{"(", 
                InterpretationBox[
                  RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                    SubsuperscriptBox["u", \(1, 2\), 
                      InterpretationBox[\("'"\[InvisibleSpace]"'"\),
                        SequenceForm[ "'", "'"],
                        Editable->False]]}],
                  SequenceForm[ "", 
                    Power[ 
                      Subscript[ u, 1, 2], 
                      SequenceForm[ "'", "'"]]],
                  Editable->False], ")"}]}], "+", 
            InterpretationBox[
              RowBox[{\(D\_0\), "\[InvisibleSpace]", 
                SubsuperscriptBox["v", \(1, 2\), 
                  InterpretationBox["\[Null]",
                    SequenceForm[ ],
                    Editable->False]]}],
              SequenceForm[ 
                Subscript[ D, 0], 
                Power[ 
                  Subscript[ v, 1, 2], 
                  SequenceForm[ ]]],
              Editable->False], "-", 
            RowBox[{\(b\^2\), " ", "\[Alpha]", " ", 
              RowBox[{"int", "[", 
                RowBox[{
                  RowBox[{
                    RowBox[{"(", 
                      InterpretationBox[
                        RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                          SubsuperscriptBox["u", \(1, 2\), 
                            InterpretationBox["\<\"'\"\>",
                              SequenceForm[ "'"],
                              Editable->False]]}],
                        SequenceForm[ "", 
                          Power[ 
                            Subscript[ u, 1, 2], 
                            SequenceForm[ "'"]]],
                        Editable->False], ")"}], " ", 
                    RowBox[{
                      SuperscriptBox["y", "\[Prime]",
                        MultilineFunction->None], "[", "x", "]"}]}], ",", 
                  \({x, 0, 1}\)}], "]"}], " ", 
              RowBox[{
                SuperscriptBox["y", "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}]}]}], "==", 
          RowBox[{
          \(\(-\(16\/3\)\)\ b\ E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ \[Pi]\^2\ 
              \[Alpha]\ A\_1\%2\), "+", 
            \(64\/3\ b\ E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ \[Pi]\^2\ \[Alpha]\ 
              Cos[2\ \[Pi]\ x]\ A\_1\%2\), "-", 
            \(\(64\ b\ E\^\(I\ T\_0\ \((\[Omega]\_1 + \[Omega]\_2)\)\)\ 
                  \[Pi]\^2\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ A\_1\ A\_2\)\/\@3\), 
            "-", \(16\ b\ E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ \[Pi]\^2\ \[Alpha]\ 
              A\_2\%2\), "-", 
            \(4\ b\ E\^\(2\ I\ T\_0\ \[Omega]\_3\)\ \[Pi]\^2\ \[Alpha]\ 
              A\_3\%2\), "-", 
            \(16\ b\ E\^\(2\ I\ T\_0\ \[Omega]\_4\)\ \[Pi]\^2\ \[Alpha]\ 
              A\_4\%2\), "-", 
            RowBox[{
            "I", " ", \(\@\(2\/3\)\), " ", \(E\^\(I\ T\_0\ \[Omega]\_1\)\), 
              " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 1]],
                  Editable->False], ")"}], " ", \(\[Omega]\_1\)}], "+", 
            RowBox[{
            "I", " ", \(\@\(2\/3\)\), " ", \(E\^\(I\ T\_0\ \[Omega]\_1\)\), 
              " ", \(Cos[2\ \[Pi]\ x]\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 1]],
                  Editable->False], ")"}], " ", \(\[Omega]\_1\)}], "+", 
            RowBox[{
            "I", " ", \(\@\(2\/3\)\), " ", 
              \(E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 1]],
                  Editable->False], ")"}], " ", \(\[Omega]\_1\)}], "-", 
            RowBox[{
            "I", " ", \(\@\(2\/3\)\), " ", 
              \(E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\), " ", 
              \(Cos[2\ \[Pi]\ x]\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 1]],
                  Editable->False], ")"}], " ", \(\[Omega]\_1\)}], "-", 
            RowBox[{
            "I", " ", \(\@2\), " ", \(E\^\(I\ T\_0\ \[Omega]\_2\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 2]],
                  Editable->False], ")"}], " ", \(Sin[2\ \[Pi]\ x]\), " ", 
              \(\[Omega]\_2\)}], "+", 
            RowBox[{
            "I", " ", \(\@2\), " ", \(E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\), 
              " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 2]],
                  Editable->False], ")"}], " ", \(Sin[2\ \[Pi]\ x]\), " ", 
              \(\[Omega]\_2\)}], "-", 
            \(32\/3\ b\ \[Pi]\^2\ \[Alpha]\ A\_1\ A\&_\_1\), "+", 
            \(128\/3\ b\ \[Pi]\^2\ \[Alpha]\ Cos[2\ \[Pi]\ x]\ A\_1\ 
              A\&_\_1\), "-", 
            \(\(64\ b\ E\^\(I\ T\_0\ \((\(-\[Omega]\_1\) + \[Omega]\_2)\)\)\ 
                  \[Pi]\^2\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ A\_2\ A\&_\_1\)\/\@3
                  \), "-", 
            \(16\/3\ b\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Pi]\^2\ 
              \[Alpha]\ A\&_\_1\%2\), "+", 
            \(64\/3\ b\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Pi]\^2\ 
              \[Alpha]\ Cos[2\ \[Pi]\ x]\ A\&_\_1\%2\), "-", 
            \(\(64\ b\ E\^\(I\ T\_0\ \((\[Omega]\_1 - \[Omega]\_2)\)\)\ 
                  \[Pi]\^2\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ A\_1\ A\&_\_2\)\/\@3
                  \), "-", \(32\ b\ \[Pi]\^2\ \[Alpha]\ A\_2\ A\&_\_2\), "-", 
            \(\(64\ b\ E\^\(I\ T\_0\ \((\(-\[Omega]\_1\) - \[Omega]\_2)\)\)\ 
                  \[Pi]\^2\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ A\&_\_1\ 
                  A\&_\_2\)\/\@3\), "-", 
            \(16\ b\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ \[Pi]\^2\ \[Alpha]\ 
              A\&_\_2\%2\), "-", \(8\ b\ \[Pi]\^2\ \[Alpha]\ A\_3\ A\&_\_3\), 
            "-", \(4\ b\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_3\)\ \[Pi]\^2\ 
              \[Alpha]\ A\&_\_3\%2\), "-", 
            \(32\ b\ \[Pi]\^2\ \[Alpha]\ A\_4\ A\&_\_4\), "-", 
            \(16\ b\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_4\)\ \[Pi]\^2\ \[Alpha]\ 
              A\&_\_4\%2\)}]}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[
              RowBox[{\(D\_0\), "\[InvisibleSpace]", 
                SubsuperscriptBox["u", \(2, 2\), 
                  InterpretationBox["\[Null]",
                    SequenceForm[ ],
                    Editable->False]]}],
              SequenceForm[ 
                Subscript[ D, 0], 
                Power[ 
                  Subscript[ u, 2, 2], 
                  SequenceForm[ ]]],
              Editable->False], "-", \(v\_\(2, 2\)\)}], "==", 
          RowBox[{
            RowBox[{\(-\@2\), " ", \(E\^\(I\ T\_0\ \[Omega]\_3\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_3\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 3]],
                  Editable->False], ")"}], " ", \(Sin[\[Pi]\ x]\)}], "-", 
            RowBox[{\(\@2\), " ", \(E\^\(\(-I\)\ T\_0\ \[Omega]\_3\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_3\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 3]],
                  Editable->False], ")"}], " ", \(Sin[\[Pi]\ x]\)}], "-", 
            RowBox[{\(\@2\), " ", \(E\^\(I\ T\_0\ \[Omega]\_4\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_4\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 4]],
                  Editable->False], ")"}], " ", \(Sin[2\ \[Pi]\ x]\)}], "-", 
            RowBox[{\(\@2\), " ", \(E\^\(\(-I\)\ T\_0\ \[Omega]\_4\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_4\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 4]],
                  Editable->False], ")"}], " ", \(Sin[2\ \[Pi]\ x]\)}]}]}], 
        ",", 
        RowBox[{
          RowBox[{
            RowBox[{"-", 
              RowBox[{"(", 
                InterpretationBox[
                  RowBox[{"\<\"\"\>", "\[InvisibleSpace]", 
                    SubsuperscriptBox["u", \(2, 2\), 
                      InterpretationBox[\("'"\[InvisibleSpace]"'"\),
                        SequenceForm[ "'", "'"],
                        Editable->False]]}],
                  SequenceForm[ "", 
                    Power[ 
                      Subscript[ u, 2, 2], 
                      SequenceForm[ "'", "'"]]],
                  Editable->False], ")"}]}], "+", 
            InterpretationBox[
              RowBox[{\(D\_0\), "\[InvisibleSpace]", 
                SubsuperscriptBox["v", \(2, 2\), 
                  InterpretationBox["\[Null]",
                    SequenceForm[ ],
                    Editable->False]]}],
              SequenceForm[ 
                Subscript[ D, 0], 
                Power[ 
                  Subscript[ v, 2, 2], 
                  SequenceForm[ ]]],
              Editable->False]}], "==", 
          RowBox[{
          \(-\(\(16\ b\ E\^\(I\ T\_0\ \((\[Omega]\_1 + \[Omega]\_3)\)\)\ 
                    \[Pi]\^2\ \[Alpha]\ Sin[\[Pi]\ x]\ A\_1\ A\_3\)\/\@3\)\), 
            "-", \(\(64\ b\ E\^\(I\ T\_0\ \((\[Omega]\_1 + \[Omega]\_4)\)\)\ 
                  \[Pi]\^2\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ A\_1\ A\_4\)\/\@3\), 
            "-", 
            RowBox[{
            "I", " ", \(\@2\), " ", \(E\^\(I\ T\_0\ \[Omega]\_3\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_3\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 3]],
                  Editable->False], ")"}], " ", \(Sin[\[Pi]\ x]\), " ", 
              \(\[Omega]\_3\)}], "+", 
            RowBox[{
            "I", " ", \(\@2\), " ", \(E\^\(\(-I\)\ T\_0\ \[Omega]\_3\)\), 
              " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_3\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 3]],
                  Editable->False], ")"}], " ", \(Sin[\[Pi]\ x]\), " ", 
              \(\[Omega]\_3\)}], "-", 
            RowBox[{
            "I", " ", \(\@2\), " ", \(E\^\(I\ T\_0\ \[Omega]\_4\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_4\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 4]],
                  Editable->False], ")"}], " ", \(Sin[2\ \[Pi]\ x]\), " ", 
              \(\[Omega]\_4\)}], "+", 
            RowBox[{
            "I", " ", \(\@2\), " ", \(E\^\(\(-I\)\ T\_0\ \[Omega]\_4\)\), 
              " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_4\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 4]],
                  Editable->False], ")"}], " ", \(Sin[2\ \[Pi]\ x]\), " ", 
              \(\[Omega]\_4\)}], "-", 
            \(\(16\ b\ E\^\(I\ T\_0\ \((\(-\[Omega]\_1\) + \[Omega]\_3)\)\)\ 
                  \[Pi]\^2\ \[Alpha]\ Sin[\[Pi]\ x]\ A\_3\ A\&_\_1\)\/\@3\), 
            "-", \(\(64\ b\ 
                  E\^\(I\ T\_0\ \((\(-\[Omega]\_1\) + \[Omega]\_4)\)\)\ 
                  \[Pi]\^2\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ A\_4\ A\&_\_1\)\/\@3
                  \), "-", 
            \(\(16\ b\ E\^\(I\ T\_0\ \((\[Omega]\_1 - \[Omega]\_3)\)\)\ 
                  \[Pi]\^2\ \[Alpha]\ Sin[\[Pi]\ x]\ A\_1\ A\&_\_3\)\/\@3\), 
            "-", \(\(16\ b\ 
                  E\^\(I\ T\_0\ \((\(-\[Omega]\_1\) - \[Omega]\_3)\)\)\ 
                  \[Pi]\^2\ \[Alpha]\ Sin[\[Pi]\ x]\ A\&_\_1\ A\&_\_3\)\/\@3
                  \), "-", 
            \(\(64\ b\ E\^\(I\ T\_0\ \((\[Omega]\_1 - \[Omega]\_4)\)\)\ 
                  \[Pi]\^2\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ A\_1\ A\&_\_4\)\/\@3
                  \), "-", 
            \(\(64\ b\ E\^\(I\ T\_0\ \((\(-\[Omega]\_1\) - \[Omega]\_4)\)\)\ 
                  \[Pi]\^2\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ A\&_\_1\ 
                  A\&_\_4\)\/\@3\)}]}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "We consider the case of  primary resonance of the first vertical mode, a \
two-to-one internal resonance between the first vertical and horizontal \
modes, a one-to-one internal resonance between the first and second vertical \
modes, and a one-to-one internal resonance between the first vertical and  \
second horizontal modes. In order to collect the terms that may lead to \
secular terms from the right-hand sides of ",
  StyleBox["order2Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we define the rules"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(omgList = Table[\[Omega]\_i, {i, 4}]; \n
    ResonanceConds = {
        \[CapitalOmega] == \[Omega]\_1 + \[Epsilon]\ \[Sigma]\_1, 
        \[Omega]\_2 == \[Omega]\_1 + \[Epsilon]\ \[Sigma]\_2, 
        2  \[Omega]\_3 == \[Omega]\_1 + \[Epsilon]\ \[Sigma]\_3, 
        \[Omega]\_4 == \[Omega]\_1 + \[Epsilon]\ \[Sigma]\_4}; \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(OmgRule = 
      \(\(Solve[ResonanceConds, 
              Complement[omgList, {#}]~Join~{\[CapitalOmega]}]\)[\([1]\)]\ &
          \)\ /@\ omgList\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{\[Omega]\_2 \[Rule] \[Epsilon]\ \[Sigma]\_2 + \[Omega]\_1, 
        \[Omega]\_3 \[Rule] 
          1\/2\ \((\[Epsilon]\ \[Sigma]\_3 + \[Omega]\_1)\), 
        \[Omega]\_4 \[Rule] \[Epsilon]\ \[Sigma]\_4 + \[Omega]\_1, 
        \[CapitalOmega] \[Rule] \[Epsilon]\ \[Sigma]\_1 + \[Omega]\_1}, {
        \[Omega]\_1 \[Rule] \(-\[Epsilon]\)\ \[Sigma]\_2 + \[Omega]\_2, 
        \[Omega]\_3 \[Rule] 
          1\/2\ \((
              \(-\[Epsilon]\)\ \[Sigma]\_2 + \[Epsilon]\ \[Sigma]\_3 + 
                \[Omega]\_2)\), 
        \[Omega]\_4 \[Rule] 
          \(-\[Epsilon]\)\ \[Sigma]\_2 + \[Epsilon]\ \[Sigma]\_4 + 
            \[Omega]\_2, 
        \[CapitalOmega] \[Rule] 
          \[Epsilon]\ \[Sigma]\_1 - \[Epsilon]\ \[Sigma]\_2 + \[Omega]\_2}, {
        \[Omega]\_1 \[Rule] \(-\[Epsilon]\)\ \[Sigma]\_3 + 2\ \[Omega]\_3, 
        \[Omega]\_2 \[Rule] 
          \[Epsilon]\ \[Sigma]\_2 - \[Epsilon]\ \[Sigma]\_3 + 2\ \[Omega]\_3, 
        \[Omega]\_4 \[Rule] 
          \(-\[Epsilon]\)\ \[Sigma]\_3 + \[Epsilon]\ \[Sigma]\_4 + 
            2\ \[Omega]\_3, 
        \[CapitalOmega] \[Rule] 
          \[Epsilon]\ \[Sigma]\_1 - \[Epsilon]\ \[Sigma]\_3 + 
            2\ \[Omega]\_3}, {
        \[Omega]\_1 \[Rule] \(-\[Epsilon]\)\ \[Sigma]\_4 + \[Omega]\_4, 
        \[Omega]\_2 \[Rule] 
          \[Epsilon]\ \[Sigma]\_2 - \[Epsilon]\ \[Sigma]\_4 + \[Omega]\_4, 
        \[Omega]\_3 \[Rule] 
          1\/2\ \((
              \[Epsilon]\ \[Sigma]\_3 - \[Epsilon]\ \[Sigma]\_4 + \[Omega]\_4)
              \), \[CapitalOmega] \[Rule] 
          \[Epsilon]\ \[Sigma]\_1 - \[Epsilon]\ \[Sigma]\_4 + \[Omega]\_4}}
      \)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[BoxData[
    \(expRule1[i_] := 
      Exp[arg_] :> 
        Exp[Expand[arg /. OmgRule[\([i]\)]] /. \[Epsilon]\ T\_0 -> T\_1]\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Collecting the terms that may lead to secular terms, the terms \
proportional to ",
  Cell[BoxData[
      \(E\^\(I\ \[Omega]\_i\ T\_0\)\)]],
  ", from the equations governing the vertical modes, we have"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(ST1v = 
      \(Coefficient[
            \(#[\([2]\)]\ &\)\ /@\ order2Eq[\([{1, 2}]\)] /. expRule1[#], 
            E\^\(I\ \[Omega]\_#\ T\_0\)]\ &\)\ /@\ {1, 2}; \n
    ST1v /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{\(-\@\(2\/3\)\), " ", 
                RowBox[{"(", 
                  InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                    SequenceForm[ 
                      Subscript[ D, 1], 
                      Subscript[ A, 1]],
                    Editable->False], ")"}]}], "+", 
              RowBox[{\(\@\(2\/3\)\), " ", \(Cos[2\ \[Pi]\ x]\), " ", 
                RowBox[{"(", 
                  InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                    SequenceForm[ 
                      Subscript[ D, 1], 
                      Subscript[ A, 1]],
                    Editable->False], ")"}]}], "-", 
              RowBox[{\(\@2\), " ", \(E\^\(I\ T\_1\ \[Sigma]\_2\)\), " ", 
                RowBox[{"(", 
                  InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                    SequenceForm[ 
                      Subscript[ D, 1], 
                      Subscript[ A, 2]],
                    Editable->False], ")"}], " ", \(Sin[2\ \[Pi]\ x]\)}]}], 
            ",", 
            RowBox[{
            \(\(-4\)\ b\ E\^\(I\ T\_1\ \[Sigma]\_3\)\ \[Pi]\^2\ \[Alpha]\ 
                A\_3\%2\), "-", 
              RowBox[{"I", " ", \(\@\(2\/3\)\), " ", 
                RowBox[{"(", 
                  InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                    SequenceForm[ 
                      Subscript[ D, 1], 
                      Subscript[ A, 1]],
                    Editable->False], ")"}], " ", \(\[Omega]\_1\)}], "+", 
              RowBox[{
              "I", " ", \(\@\(2\/3\)\), " ", \(Cos[2\ \[Pi]\ x]\), " ", 
                RowBox[{"(", 
                  InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                    SequenceForm[ 
                      Subscript[ D, 1], 
                      Subscript[ A, 1]],
                    Editable->False], ")"}], " ", \(\[Omega]\_1\)}], "-", 
              RowBox[{
              "I", " ", \(\@2\), " ", \(E\^\(I\ T\_1\ \[Sigma]\_2\)\), " ", 
                RowBox[{"(", 
                  InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                    SequenceForm[ 
                      Subscript[ D, 1], 
                      Subscript[ A, 2]],
                    Editable->False], ")"}], " ", \(Sin[2\ \[Pi]\ x]\), " ", 
                \(\[Omega]\_2\)}]}]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
              \(-\@\(2\/3\)\), " ", \(E\^\(\(-I\)\ T\_1\ \[Sigma]\_2\)\), 
                " ", 
                RowBox[{"(", 
                  InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                    SequenceForm[ 
                      Subscript[ D, 1], 
                      Subscript[ A, 1]],
                    Editable->False], ")"}]}], "+", 
              RowBox[{
              \(\@\(2\/3\)\), " ", \(E\^\(\(-I\)\ T\_1\ \[Sigma]\_2\)\), " ", 
                \(Cos[2\ \[Pi]\ x]\), " ", 
                RowBox[{"(", 
                  InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                    SequenceForm[ 
                      Subscript[ D, 1], 
                      Subscript[ A, 1]],
                    Editable->False], ")"}]}], "-", 
              RowBox[{\(\@2\), " ", 
                RowBox[{"(", 
                  InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                    SequenceForm[ 
                      Subscript[ D, 1], 
                      Subscript[ A, 2]],
                    Editable->False], ")"}], " ", \(Sin[2\ \[Pi]\ x]\)}]}], 
            ",", 
            RowBox[{
            \(\(-4\)\ b\ 
                E\^\(\(-I\)\ T\_1\ \[Sigma]\_2 + I\ T\_1\ \[Sigma]\_3\)\ 
                \[Pi]\^2\ \[Alpha]\ A\_3\%2\), "-", 
              RowBox[{
              "I", " ", \(\@\(2\/3\)\), " ", 
                \(E\^\(\(-I\)\ T\_1\ \[Sigma]\_2\)\), " ", 
                RowBox[{"(", 
                  InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                    SequenceForm[ 
                      Subscript[ D, 1], 
                      Subscript[ A, 1]],
                    Editable->False], ")"}], " ", \(\[Omega]\_1\)}], "+", 
              RowBox[{
              "I", " ", \(\@\(2\/3\)\), " ", 
                \(E\^\(\(-I\)\ T\_1\ \[Sigma]\_2\)\), " ", 
                \(Cos[2\ \[Pi]\ x]\), " ", 
                RowBox[{"(", 
                  InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                    SequenceForm[ 
                      Subscript[ D, 1], 
                      Subscript[ A, 1]],
                    Editable->False], ")"}], " ", \(\[Omega]\_1\)}], "-", 
              RowBox[{"I", " ", \(\@2\), " ", 
                RowBox[{"(", 
                  InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                    SequenceForm[ 
                      Subscript[ D, 1], 
                      Subscript[ A, 2]],
                    Editable->False], ")"}], " ", \(Sin[2\ \[Pi]\ x]\), " ", 
                \(\[Omega]\_2\)}]}]}], "}"}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
Collecting the terms that may lead to secular terms from the equations \
governing the horizontal modes, we have\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(ST1h = 
      \(Coefficient[
            \(#[\([2]\)]\ &\)\ /@\ order2Eq[\([{3, 4}]\)] /. expRule1[#], 
            E\^\(I\ \[Omega]\_#\ T\_0\)]\ &\)\ /@\ {3, 4}; \n
    ST1h /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{\(-\@2\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_3\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 3]],
                  Editable->False], ")"}], " ", \(Sin[\[Pi]\ x]\)}], ",", 
            RowBox[{
              RowBox[{\(-I\), " ", \(\@2\), " ", 
                RowBox[{"(", 
                  InterpretationBox[\(D\_1\[InvisibleSpace]A\_3\),
                    SequenceForm[ 
                      Subscript[ D, 1], 
                      Subscript[ A, 3]],
                    Editable->False], ")"}], " ", \(Sin[\[Pi]\ x]\), " ", 
                \(\[Omega]\_3\)}], "-", 
              \(\(16\ b\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_3\)\ \[Pi]\^2\ 
                    \[Alpha]\ Sin[\[Pi]\ x]\ A\_1\ A\&_\_3\)\/\@3\)}]}], 
          "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{\(-\@2\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_4\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 4]],
                  Editable->False], ")"}], " ", \(Sin[2\ \[Pi]\ x]\)}], ",", 
            RowBox[{\(-I\), " ", \(\@2\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_4\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 4]],
                  Editable->False], ")"}], " ", \(Sin[2\ \[Pi]\ x]\), " ", 
              \(\[Omega]\_4\)}]}], "}"}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Demanding that ",
  StyleBox["ST1v[[i]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  StyleBox[" ",
    FontColor->RGBColor[1, 0, 1]],
  "be orthogonal to the ",
  StyleBox["adjointC[[i]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain the solvability conditions"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"SCond1v", "=", 
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{"Solve", "[", 
                  RowBox[{
                  \(\((\(\(\(\(int[adjointC[\([#]\)] . ST1v[\([#]\)], {x, 0, 
                                      1}] /. intRule1\) //. intRule2\) /. 
                              modeshapes\) /. params\) /. int -> Integrate)
                        \) == 0\), ",", 
                    RowBox[{
                      SubsuperscriptBox["A", "#", 
                        TagBox[\((1, 0)\),
                          Derivative],
                        MultilineFunction->None], "[", \(T\_1, T\_2\), 
                      "]"}]}], "]"}], "[", \([1]\), "]"}], " ", "&"}], " ", 
            "/@", " ", \({1, 2}\)}], "//", "Flatten"}]}], ";", "\n", 
      \(SCond1v /. displayRule\)}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
            SequenceForm[ 
              Subscript[ D, 1], 
              Subscript[ A, 1]],
            Editable->False], "\[Rule]", 
          \(I\ \@\(2\/3\)\ b\ E\^\(I\ T\_1\ \[Sigma]\_3\)\ \[Pi]\ \[Alpha]\ 
            A\_3\%2\)}], ",", 
        RowBox[{
          InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
            SequenceForm[ 
              Subscript[ D, 1], 
              Subscript[ A, 2]],
            Editable->False], "\[Rule]", "0"}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Demanding that ",
  StyleBox["ST1h[[i]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  StyleBox[" ",
    FontColor->RGBColor[1, 0, 1]],
  "be orthogonal to the ",
  StyleBox["adjointC[[i+2]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain the solvability conditions"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"SCond1h", "=", 
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{"Solve", "[", 
                  RowBox[{
                  \(\((\(\(\(\(int[adjointC[\([# + 2]\)] . ST1h[\([#]\)], {x, 
                                      0, 1}] /. intRule1\) //. intRule2\) /. 
                              modeshapes\) /. params\) /. int -> Integrate)
                        \) == 0\), ",", 
                    RowBox[{
                      SubsuperscriptBox["A", \(# + 2\), 
                        TagBox[\((1, 0)\),
                          Derivative],
                        MultilineFunction->None], "[", \(T\_1, T\_2\), 
                      "]"}]}], "]"}], "[", \([1]\), "]"}], " ", "&"}], " ", 
            "/@", " ", \({1, 2}\)}], "//", "Flatten"}]}], ";", "\n", 
      \(SCond1h /. displayRule\)}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          InterpretationBox[\(D\_1\[InvisibleSpace]A\_3\),
            SequenceForm[ 
              Subscript[ D, 1], 
              Subscript[ A, 3]],
            Editable->False], "\[Rule]", 
          \(4\ I\ \@\(2\/3\)\ b\ E\^\(\(-I\)\ T\_1\ \[Sigma]\_3\)\ \[Pi]\ 
            \[Alpha]\ A\_1\ A\&_\_3\)}], ",", 
        RowBox[{
          InterpretationBox[\(D\_1\[InvisibleSpace]A\_4\),
            SequenceForm[ 
              Subscript[ D, 1], 
              Subscript[ A, 4]],
            Editable->False], "\[Rule]", "0"}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[BoxData[
    \(\(SCond1 = Join[SCond1v, SCond1h]; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["whose complex conjugates are", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(ccSCond1 = SCond1 /. conjugateRule; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Next, we use the solvability conditions to eliminate the ",
  Cell[BoxData[
      \(TraditionalForm\`\(D\_1\) A\_\(i\ \)\)]],
  "from the right-hand sides of ",
  StyleBox["order2Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ". To this end, we define the rules"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sigRule = 
      \(Solve[ResonanceConds, Table[\[Sigma]\_i, {i, 4}]]\)[\([1]\)]\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Sigma]\_1 \[Rule] 
        \(-\(\(\(-\[CapitalOmega]\) + \[Omega]\_1\)\/\[Epsilon]\)\), 
      \[Sigma]\_2 \[Rule] \(-\(\(\[Omega]\_1 - \[Omega]\_2\)\/\[Epsilon]\)\), 
      \[Sigma]\_3 \[Rule] 
        \(-\(\(\[Omega]\_1 - 2\ \[Omega]\_3\)\/\[Epsilon]\)\), 
      \[Sigma]\_4 \[Rule] \(-\(\(\[Omega]\_1 - \[Omega]\_4\)\/\[Epsilon]\)\)}
      \)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[BoxData[
    \(\(expRule2 = 
      Exp[a_] :> Exp[\(a /. sigRule\) /. T\_1 -> \[Epsilon]\ T\_0 // Expand]; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting ",
  StyleBox["SCond1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", ",
  StyleBox["ccSCond1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", and ",
  StyleBox["expRule2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["order2Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(order2Eqm = \(\(order2Eq /. SCond1\) /. ccSCond1\) /. expRule2; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "To determine the solution of ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and the associated boundary conditions, we use the method of undetermined \
coefficients. To accomplish this, we first determine the forms of the terms \
on the right-hand sides of ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " by picking up the ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " dependent or ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`T\_0\)]],
  " dependent terms by defining the rule"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(baits = {_\ E\^\(a_\ T\_0 + b_. \)\ f_[c_\ x] :> 
          E\^\(a\ T\_0 + b\)\ f[c\ x], 
        a_\ f_[b_\ x] :> f[b\ x] /; FreeQ[a, T\_0]}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
Then, we collect the solution forms for the horizontal modes according to\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2Formh = 
      \(Table[\(Cases[order2Eqm[\([k, 2]\)], #]\ &\)\ /@\ baits, {k, 3, 
              4}] // Flatten\) // Union\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_3\)\ 
        Sin[\[Pi]\ x], 
      E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_3\)\ Sin[\[Pi]\ x], 
      E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_3\)\ Sin[\[Pi]\ x], 
      E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_3\)\ Sin[\[Pi]\ x], 
      E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_4\)\ 
        Sin[2\ \[Pi]\ x], 
      E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_4\)\ Sin[2\ \[Pi]\ x], 
      E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_4\)\ 
        Sin[2\ \[Pi]\ x], 
      E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_4\)\ Sin[2\ \[Pi]\ x]}
      \)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
Each of these terms satisfies the boundary conditions. However, not all of \
the solution forms\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2Formv = 
      \(Table[\(Cases[order2Eqm[\([k, 2]\)], #]\ &\)\ /@\ baits, {k, 2}] // 
          Flatten\) // Union\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({Cos[2\ \[Pi]\ x], 
      E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ Cos[2\ \[Pi]\ x], 
      E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ Cos[2\ \[Pi]\ x], 
      E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_3\)\ Cos[2\ \[Pi]\ x], 
      E\^\(2\ I\ T\_0\ \[Omega]\_3\)\ Cos[2\ \[Pi]\ x], 
      E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
        Sin[2\ \[Pi]\ x], 
      E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ Sin[2\ \[Pi]\ x], 
      E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
        Sin[2\ \[Pi]\ x], 
      E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ Sin[2\ \[Pi]\ x]}
      \)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "for the vertical modes satisfy the boundary conditions. Besides, there \
exist terms that are not functions of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " on the right-hand sides of ",
  StyleBox["order2Eqm[[{1,2}]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", namely"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(#[\([2]\)]\ &\)\ /@\ order2Eqm[\([{1, 2}]\)] /. 
        Thread[sol2Formv -> 0]\) /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\(-\(2\/3\)\)\ I\ b\ E\^\(2\ I\ T\_0\ \[Omega]\_3\)\ \[Pi]\ \[Alpha]\ 
          A\_3\%2 + 
        2\/3\ I\ b\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_3\)\ \[Pi]\ \[Alpha]\ 
          A\&_\_3\%2, 
      \(-\(16\/3\)\)\ b\ E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ \[Pi]\^2\ \[Alpha]\ 
          A\_1\%2 - 
        16\ b\ E\^\(2\ I\ T\_0\ \[Omega]\_2\)\ \[Pi]\^2\ \[Alpha]\ A\_2\%2 - 
        4\ b\ E\^\(2\ I\ T\_0\ \[Omega]\_3\)\ \[Pi]\^2\ \[Alpha]\ A\_3\%2 - 
        16\ b\ E\^\(2\ I\ T\_0\ \[Omega]\_4\)\ \[Pi]\^2\ \[Alpha]\ A\_4\%2 + 
        2\/3\ b\ E\^\(2\ I\ T\_0\ \[Omega]\_3\)\ \[Pi]\ \[Alpha]\ A\_3\%2\ 
          \[Omega]\_1 - 32\/3\ b\ \[Pi]\^2\ \[Alpha]\ A\_1\ A\&_\_1 - 
        16\/3\ b\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Pi]\^2\ \[Alpha]\ 
          A\&_\_1\%2 - 32\ b\ \[Pi]\^2\ \[Alpha]\ A\_2\ A\&_\_2 - 
        16\ b\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\)\ \[Pi]\^2\ \[Alpha]\ 
          A\&_\_2\%2 - 8\ b\ \[Pi]\^2\ \[Alpha]\ A\_3\ A\&_\_3 - 
        4\ b\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_3\)\ \[Pi]\^2\ \[Alpha]\ 
          A\&_\_3\%2 + 
        2\/3\ b\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_3\)\ \[Pi]\ \[Alpha]\ 
          \[Omega]\_1\ A\&_\_3\%2 - 
        32\ b\ \[Pi]\^2\ \[Alpha]\ A\_4\ A\&_\_4 - 
        16\ b\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_4\)\ \[Pi]\^2\ \[Alpha]\ 
          A\&_\_4\%2}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Hence, we need to either consider some algebraic forms or combined \
algebraic and sinusoidal forms for ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " to manually adjust the forms in ",
  StyleBox["sol2Formv",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " or use a more general approach to let ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " pick up the right forms. The latter approach is used here."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell["Vertical Modes", "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Instead of looking for the ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " dependent forms, we seek all of the ",
  Cell[BoxData[
      \(TraditionalForm\`T\_0\)]],
  " dependent forms as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2Formv1 = 
      Join[{1}, 
        \(Table[Cases[order2Eqm[\([k, 2]\)], Exp[_], \[Infinity]], {k, 2}] // 
            Flatten\) // Union]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({1, E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\), 
      E\^\(2\ I\ T\_0\ \[Omega]\_1\), E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_2\), 
      E\^\(2\ I\ T\_0\ \[Omega]\_2\), 
      E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\), 
      E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\), 
      E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\), 
      E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\), 
      E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_3\), E\^\(2\ I\ T\_0\ \[Omega]\_3\), 
      E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_4\), E\^\(2\ I\ T\_0\ \[Omega]\_4\)}
      \)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "where the first argument in ",
  StyleBox["sol2Formv1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " is included to account for the ",
  Cell[BoxData[
      \(TraditionalForm\`T\_0\)]],
  " independent terms."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "We define the undetermined coefficients for ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\(1, \ 2\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`v\_\(1, \ 2\)\)]],
  " as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(uSymbolv = Table[\[Psi]\_\(1, i\)[x], {i, Length[sol2Formv1]}]; \n
    vSymbolv = uSymbolv /. \[Psi] -> \[Eta]; \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["and write the general solution in the form", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(sol2v = {
        u\_\(1, 2\) -> 
          Function[{x, T\_0, T\_1, T\_2}, uSymbolv . sol2Formv1 // Evaluate], 
        v\_\(1, 2\) -> 
          Function[{x, T\_0, T\_1, T\_2}, 
            vSymbolv . sol2Formv1 // Evaluate]}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting ",
  StyleBox["sol2v",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["order2Eqm[[1]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and equating the coefficients of the ",
  StyleBox["sol2Formv1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " on both sides yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(expr1 = Subtract\ @@\ order2Eqm[\([1]\)] /. sol2v; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(eqv1 = 
      Join[{expr1 == 0 /. Exp[_] -> 0}, 
        Coefficient[expr1, Rest[sol2Formv1]] == 0 // Thread]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\(-\[Eta]\_\(1, 1\)[x]\) == 0, 
      \(-\[Eta]\_\(1, 2\)[x]\) - 2\ I\ \[Omega]\_1\ \[Psi]\_\(1, 2\)[x] == 0, 
      \(-\[Eta]\_\(1, 3\)[x]\) + 2\ I\ \[Omega]\_1\ \[Psi]\_\(1, 3\)[x] == 0, 
      \(-\[Eta]\_\(1, 4\)[x]\) - 2\ I\ \[Omega]\_2\ \[Psi]\_\(1, 4\)[x] == 0, 
      \(-\[Eta]\_\(1, 5\)[x]\) + 2\ I\ \[Omega]\_2\ \[Psi]\_\(1, 5\)[x] == 0, 
      \(-\[Eta]\_\(1, 6\)[x]\) - I\ \[Omega]\_1\ \[Psi]\_\(1, 6\)[x] - 
          I\ \[Omega]\_2\ \[Psi]\_\(1, 6\)[x] == 0, 
      \(-\[Eta]\_\(1, 7\)[x]\) + I\ \[Omega]\_1\ \[Psi]\_\(1, 7\)[x] - 
          I\ \[Omega]\_2\ \[Psi]\_\(1, 7\)[x] == 0, 
      \(-\[Eta]\_\(1, 8\)[x]\) - I\ \[Omega]\_1\ \[Psi]\_\(1, 8\)[x] + 
          I\ \[Omega]\_2\ \[Psi]\_\(1, 8\)[x] == 0, 
      \(-\[Eta]\_\(1, 9\)[x]\) + I\ \[Omega]\_1\ \[Psi]\_\(1, 9\)[x] + 
          I\ \[Omega]\_2\ \[Psi]\_\(1, 9\)[x] == 0, 
      \(-\(2\/3\)\)\ I\ b\ \[Pi]\ \[Alpha]\ A\&_\_3[T\_1, T\_2]\^2 + 
          2\/3\ I\ b\ \[Pi]\ \[Alpha]\ Cos[2\ \[Pi]\ x]\ 
            A\&_\_3[T\_1, T\_2]\^2 - \[Eta]\_\(1, 10\)[x] - 
          2\ I\ \[Omega]\_3\ \[Psi]\_\(1, 10\)[x] == 0, 
      2\/3\ I\ b\ \[Pi]\ \[Alpha]\ A\_3[T\_1, T\_2]\^2 - 
          2\/3\ I\ b\ \[Pi]\ \[Alpha]\ Cos[2\ \[Pi]\ x]\ 
            A\_3[T\_1, T\_2]\^2 - \[Eta]\_\(1, 11\)[x] + 
          2\ I\ \[Omega]\_3\ \[Psi]\_\(1, 11\)[x] == 0, 
      \(-\[Eta]\_\(1, 12\)[x]\) - 2\ I\ \[Omega]\_4\ \[Psi]\_\(1, 12\)[x] == 
        0, \(-\[Eta]\_\(1, 13\)[x]\) + 
          2\ I\ \[Omega]\_4\ \[Psi]\_\(1, 13\)[x] == 0}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Solving for ",
  StyleBox["vSymbolv",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " from ",
  StyleBox["eqv1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(eta1Sol = \(Solve[eqv1, vSymbolv]\)[\([1]\)]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Eta]\_\(1, 1\)[x] \[Rule] 0, 
      \[Eta]\_\(1, 2\)[x] \[Rule] 
        \(-2\)\ I\ \[Omega]\_1\ \[Psi]\_\(1, 2\)[x], 
      \[Eta]\_\(1, 3\)[x] \[Rule] 2\ I\ \[Omega]\_1\ \[Psi]\_\(1, 3\)[x], 
      \[Eta]\_\(1, 4\)[x] \[Rule] 
        \(-2\)\ I\ \[Omega]\_2\ \[Psi]\_\(1, 4\)[x], 
      \[Eta]\_\(1, 5\)[x] \[Rule] 2\ I\ \[Omega]\_2\ \[Psi]\_\(1, 5\)[x], 
      \[Eta]\_\(1, 6\)[x] \[Rule] 
        \(-I\)\ \((
            \[Omega]\_1\ \[Psi]\_\(1, 6\)[x] + 
              \[Omega]\_2\ \[Psi]\_\(1, 6\)[x])\), 
      \[Eta]\_\(1, 7\)[x] \[Rule] 
        I\ \((\[Omega]\_1\ \[Psi]\_\(1, 7\)[x] - 
              \[Omega]\_2\ \[Psi]\_\(1, 7\)[x])\), 
      \[Eta]\_\(1, 8\)[x] \[Rule] 
        \(-I\)\ \((
            \[Omega]\_1\ \[Psi]\_\(1, 8\)[x] - 
              \[Omega]\_2\ \[Psi]\_\(1, 8\)[x])\), 
      \[Eta]\_\(1, 9\)[x] \[Rule] 
        I\ \((\[Omega]\_1\ \[Psi]\_\(1, 9\)[x] + 
              \[Omega]\_2\ \[Psi]\_\(1, 9\)[x])\), 
      \[Eta]\_\(1, 10\)[x] \[Rule] 
        2\/3\ I\ \((
            \(-b\)\ \[Pi]\ \[Alpha]\ A\&_\_3[T\_1, T\_2]\^2 + 
              b\ \[Pi]\ \[Alpha]\ Cos[2\ \[Pi]\ x]\ A\&_\_3[T\_1, T\_2]\^2 - 
              3\ \[Omega]\_3\ \[Psi]\_\(1, 10\)[x])\), 
      \[Eta]\_\(1, 11\)[x] \[Rule] 
        \(-\(2\/3\)\)\ I\ 
          \((\(-b\)\ \[Pi]\ \[Alpha]\ A\_3[T\_1, T\_2]\^2 + 
              b\ \[Pi]\ \[Alpha]\ Cos[2\ \[Pi]\ x]\ A\_3[T\_1, T\_2]\^2 - 
              3\ \[Omega]\_3\ \[Psi]\_\(1, 11\)[x])\), 
      \[Eta]\_\(1, 12\)[x] \[Rule] 
        \(-2\)\ I\ \[Omega]\_4\ \[Psi]\_\(1, 12\)[x], 
      \[Eta]\_\(1, 13\)[x] \[Rule] 2\ I\ \[Omega]\_4\ \[Psi]\_\(1, 13\)[x]}
      \)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Substituting ",
  StyleBox["sol2v",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["eta1Sol",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["order2Eqm[[2]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and equating the coefficients of the ",
  StyleBox["sol2Formv1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " on both sides yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(expr2 = 
      \(\(\(\(\(Subtract\ @@\ order2Eqm[\([2]\)] /. sol2v\) /. eta1Sol\) /. 
              intRule1\) //. intRule2\) /. 
          int[\(y\^\[Prime]\)[x]\ \(\[Psi]\_\(1, k_\)\^\[Prime]\)[x], _] -> 
            \[Beta]\_k\) /. yRule; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(eqv2 = 
      Join[{expr2 == 0 /. Exp[_] -> 0}, 
          Coefficient[expr2, Rest[sol2Formv1]] == 0 // Thread] /. params\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
          \(\(\[Pi]\^2\ \[Beta]\_1\)\/2\), "+", 
            \(32\/3\ b\ \[Pi]\^2\ \[Alpha]\ A\_1[T\_1, T\_2]\ 
              A\&_\_1[T\_1, T\_2]\), "-", 
            \(128\/3\ b\ \[Pi]\^2\ \[Alpha]\ Cos[2\ \[Pi]\ x]\ 
              A\_1[T\_1, T\_2]\ A\&_\_1[T\_1, T\_2]\), "+", 
            \(32\ b\ \[Pi]\^2\ \[Alpha]\ A\_2[T\_1, T\_2]\ 
              A\&_\_2[T\_1, T\_2]\), "+", 
            \(8\ b\ \[Pi]\^2\ \[Alpha]\ A\_3[T\_1, T\_2]\ 
              A\&_\_3[T\_1, T\_2]\), "+", 
            \(32\ b\ \[Pi]\^2\ \[Alpha]\ A\_4[T\_1, T\_2]\ 
              A\&_\_4[T\_1, T\_2]\), "-", 
            RowBox[{
              SubsuperscriptBox["\[Psi]", \(1, 1\), "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}]}], "==", "0"}], 
        ",", 
        RowBox[{
          RowBox[{
          \(\(\[Pi]\^2\ \[Beta]\_2\)\/2\), "+", 
            \(16\/3\ b\ \[Pi]\^2\ \[Alpha]\ A\&_\_1[T\_1, T\_2]\^2\), "-", 
            \(64\/3\ b\ \[Pi]\^2\ \[Alpha]\ Cos[2\ \[Pi]\ x]\ 
              A\&_\_1[T\_1, T\_2]\^2\), "-", 
            \(16\ \[Pi]\^2\ \[Psi]\_\(1, 2\)[x]\), "-", 
            RowBox[{
              SubsuperscriptBox["\[Psi]", \(1, 2\), "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}]}], "==", "0"}], 
        ",", 
        RowBox[{
          RowBox[{
          \(\(\[Pi]\^2\ \[Beta]\_3\)\/2\), "+", 
            \(16\/3\ b\ \[Pi]\^2\ \[Alpha]\ A\_1[T\_1, T\_2]\^2\), "-", 
            \(64\/3\ b\ \[Pi]\^2\ \[Alpha]\ Cos[2\ \[Pi]\ x]\ 
              A\_1[T\_1, T\_2]\^2\), "-", 
            \(16\ \[Pi]\^2\ \[Psi]\_\(1, 3\)[x]\), "-", 
            RowBox[{
              SubsuperscriptBox["\[Psi]", \(1, 3\), "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}]}], "==", "0"}], 
        ",", 
        RowBox[{
          RowBox[{
          \(\(\[Pi]\^2\ \[Beta]\_4\)\/2\), "+", 
            \(16\ b\ \[Pi]\^2\ \[Alpha]\ A\&_\_2[T\_1, T\_2]\^2\), "-", 
            \(16\ \[Pi]\^2\ \[Psi]\_\(1, 4\)[x]\), "-", 
            RowBox[{
              SubsuperscriptBox["\[Psi]", \(1, 4\), "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}]}], "==", "0"}], 
        ",", 
        RowBox[{
          RowBox[{
          \(\(\[Pi]\^2\ \[Beta]\_5\)\/2\), "+", 
            \(16\ b\ \[Pi]\^2\ \[Alpha]\ A\_2[T\_1, T\_2]\^2\), "-", 
            \(16\ \[Pi]\^2\ \[Psi]\_\(1, 5\)[x]\), "-", 
            RowBox[{
              SubsuperscriptBox["\[Psi]", \(1, 5\), "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}]}], "==", "0"}], 
        ",", 
        RowBox[{
          RowBox[{
          \(\(\[Pi]\^2\ \[Beta]\_6\)\/2\), "+", 
            \(\(64\ b\ \[Pi]\^2\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ 
                  A\&_\_1[T\_1, T\_2]\ A\&_\_2[T\_1, T\_2]\)\/\@3\), "-", 
            \(16\ \[Pi]\^2\ \[Psi]\_\(1, 6\)[x]\), "-", 
            RowBox[{
              SubsuperscriptBox["\[Psi]", \(1, 6\), "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}]}], "==", "0"}], 
        ",", 
        RowBox[{
          RowBox[{
          \(\(\[Pi]\^2\ \[Beta]\_7\)\/2\), "+", 
            \(\(64\ b\ \[Pi]\^2\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ 
                  A\_1[T\_1, T\_2]\ A\&_\_2[T\_1, T\_2]\)\/\@3\), "-", 
            RowBox[{
              SubsuperscriptBox["\[Psi]", \(1, 7\), "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}]}], "==", "0"}], 
        ",", 
        RowBox[{
          RowBox[{
          \(\(\[Pi]\^2\ \[Beta]\_8\)\/2\), "+", 
            \(\(64\ b\ \[Pi]\^2\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ 
                  A\_2[T\_1, T\_2]\ A\&_\_1[T\_1, T\_2]\)\/\@3\), "-", 
            RowBox[{
              SubsuperscriptBox["\[Psi]", \(1, 8\), "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}]}], "==", "0"}], 
        ",", 
        RowBox[{
          RowBox[{
          \(\(\[Pi]\^2\ \[Beta]\_9\)\/2\), "+", 
            \(\(64\ b\ \[Pi]\^2\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ 
                  A\_1[T\_1, T\_2]\ A\_2[T\_1, T\_2]\)\/\@3\), "-", 
            \(16\ \[Pi]\^2\ \[Psi]\_\(1, 9\)[x]\), "-", 
            RowBox[{
              SubsuperscriptBox["\[Psi]", \(1, 9\), "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}]}], "==", "0"}], 
        ",", 
        RowBox[{
          RowBox[{
          \(\(\[Pi]\^2\ \[Beta]\_10\)\/2\), "+", 
            \(4\/3\ b\ \[Pi]\^2\ \[Alpha]\ A\&_\_3[T\_1, T\_2]\^2\), "+", 
            \(8\/3\ b\ \[Pi]\^2\ \[Alpha]\ Cos[2\ \[Pi]\ x]\ 
              A\&_\_3[T\_1, T\_2]\^2\), "-", 
            \(4\ \[Pi]\^2\ \[Psi]\_\(1, 10\)[x]\), "-", 
            RowBox[{
              SubsuperscriptBox["\[Psi]", \(1, 10\), "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}]}], "==", "0"}], 
        ",", 
        RowBox[{
          RowBox[{
          \(\(\[Pi]\^2\ \[Beta]\_11\)\/2\), "+", 
            \(4\/3\ b\ \[Pi]\^2\ \[Alpha]\ A\_3[T\_1, T\_2]\^2\), "+", 
            \(8\/3\ b\ \[Pi]\^2\ \[Alpha]\ Cos[2\ \[Pi]\ x]\ 
              A\_3[T\_1, T\_2]\^2\), "-", 
            \(4\ \[Pi]\^2\ \[Psi]\_\(1, 11\)[x]\), "-", 
            RowBox[{
              SubsuperscriptBox["\[Psi]", \(1, 11\), "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}]}], "==", "0"}], 
        ",", 
        RowBox[{
          RowBox[{
          \(\(\[Pi]\^2\ \[Beta]\_12\)\/2\), "+", 
            \(16\ b\ \[Pi]\^2\ \[Alpha]\ A\&_\_4[T\_1, T\_2]\^2\), "-", 
            \(16\ \[Pi]\^2\ \[Psi]\_\(1, 12\)[x]\), "-", 
            RowBox[{
              SubsuperscriptBox["\[Psi]", \(1, 12\), "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}]}], "==", "0"}], 
        ",", 
        RowBox[{
          RowBox[{
          \(\(\[Pi]\^2\ \[Beta]\_13\)\/2\), "+", 
            \(16\ b\ \[Pi]\^2\ \[Alpha]\ A\_4[T\_1, T\_2]\^2\), "-", 
            \(16\ \[Pi]\^2\ \[Psi]\_\(1, 13\)[x]\), "-", 
            RowBox[{
              SubsuperscriptBox["\[Psi]", \(1, 13\), "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}]}], "==", "0"}]}], 
      "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Next, we determine the solutions of the boundary-value problems: ",
  StyleBox["eqv2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and the associated boundary conditions. First, we obtain the information \
about the solution forms ",
  StyleBox["uSymbolv",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " according to"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Psi]Form = 
      \(\(\(DSolve[{#[\([1]\)], #[\([2]\)] == 0 /. x -> 0, #[\([2]\)] == 0 /. 
                        x -> 1}, #[\([2]\)], x]\)[\([1]\)] /. C[i_] -> 0\ &
              \)\ /@\ Transpose[{eqv2, uSymbolv}] // Flatten\) // ExpandAll; 
    \n\[Psi]Form /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Psi]\_\(1, 1\)[x] \[Rule] 
        \(-\(1\/4\)\)\ \[Pi]\^2\ x\ \[Beta]\_1 + 
          1\/4\ \[Pi]\^2\ x\^2\ \[Beta]\_1 - 
          32\/3\ b\ \[Alpha]\ A\_1\ A\&_\_1 - 
          16\/3\ b\ \[Pi]\^2\ x\ \[Alpha]\ A\_1\ A\&_\_1 + 
          16\/3\ b\ \[Pi]\^2\ x\^2\ \[Alpha]\ A\_1\ A\&_\_1 + 
          32\/3\ b\ \[Alpha]\ Cos[2\ \[Pi]\ x]\ A\_1\ A\&_\_1 - 
          16\ b\ \[Pi]\^2\ x\ \[Alpha]\ A\_2\ A\&_\_2 + 
          16\ b\ \[Pi]\^2\ x\^2\ \[Alpha]\ A\_2\ A\&_\_2 - 
          4\ b\ \[Pi]\^2\ x\ \[Alpha]\ A\_3\ A\&_\_3 + 
          4\ b\ \[Pi]\^2\ x\^2\ \[Alpha]\ A\_3\ A\&_\_3 - 
          16\ b\ \[Pi]\^2\ x\ \[Alpha]\ A\_4\ A\&_\_4 + 
          16\ b\ \[Pi]\^2\ x\^2\ \[Alpha]\ A\_4\ A\&_\_4, 
      \[Psi]\_\(1, 2\)[x] \[Rule] 
        \[Beta]\_2\/32 - 1\/32\ Cos[4\ \[Pi]\ x]\ \[Beta]\_2 + 
          1\/3\ b\ \[Alpha]\ A\&_\_1\%2 - 
          16\/9\ b\ \[Alpha]\ Cos[2\ \[Pi]\ x]\ A\&_\_1\%2 + 
          13\/9\ b\ \[Alpha]\ Cos[4\ \[Pi]\ x]\ A\&_\_1\%2, 
      \[Psi]\_\(1, 3\)[x] \[Rule] 
        1\/3\ b\ \[Alpha]\ A\_1\%2 - 
          16\/9\ b\ \[Alpha]\ Cos[2\ \[Pi]\ x]\ A\_1\%2 + 
          13\/9\ b\ \[Alpha]\ Cos[4\ \[Pi]\ x]\ A\_1\%2 + \[Beta]\_3\/32 - 
          1\/32\ Cos[4\ \[Pi]\ x]\ \[Beta]\_3, 
      \[Psi]\_\(1, 4\)[x] \[Rule] 
        \[Beta]\_4\/32 - 1\/32\ Cos[4\ \[Pi]\ x]\ \[Beta]\_4 + 
          b\ \[Alpha]\ A\&_\_2\%2 - 
          b\ \[Alpha]\ Cos[4\ \[Pi]\ x]\ A\&_\_2\%2, 
      \[Psi]\_\(1, 5\)[x] \[Rule] 
        b\ \[Alpha]\ A\_2\%2 - b\ \[Alpha]\ Cos[4\ \[Pi]\ x]\ A\_2\%2 + 
          \[Beta]\_5\/32 - 1\/32\ Cos[4\ \[Pi]\ x]\ \[Beta]\_5, 
      \[Psi]\_\(1, 6\)[x] \[Rule] 
        \[Beta]\_6\/32 - 1\/32\ Cos[4\ \[Pi]\ x]\ \[Beta]\_6 + 
          \(16\ b\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ A\&_\_1\ A\&_\_2\)\/\(3\ 
              \@3\), \[Psi]\_\(1, 7\)[x] \[Rule] 
        \(-\(1\/4\)\)\ \[Pi]\^2\ x\ \[Beta]\_7 + 
          1\/4\ \[Pi]\^2\ x\^2\ \[Beta]\_7 - 
          \(16\ b\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ A\_1\ A\&_\_2\)\/\@3, 
      \[Psi]\_\(1, 8\)[x] \[Rule] 
        \(-\(1\/4\)\)\ \[Pi]\^2\ x\ \[Beta]\_8 + 
          1\/4\ \[Pi]\^2\ x\^2\ \[Beta]\_8 - 
          \(16\ b\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ A\_2\ A\&_\_1\)\/\@3, 
      \[Psi]\_\(1, 9\)[x] \[Rule] 
        \(16\ b\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ A\_1\ A\_2\)\/\(3\ \@3\) + 
          \[Beta]\_9\/32 - 1\/32\ Cos[4\ \[Pi]\ x]\ \[Beta]\_9, 
      \[Psi]\_\(1, 10\)[x] \[Rule] 
        \[Beta]\_10\/8 - 1\/8\ Cos[2\ \[Pi]\ x]\ \[Beta]\_10 + 
          1\/3\ b\ \[Alpha]\ A\&_\_3\%2 - 
          1\/3\ b\ \[Alpha]\ Cos[2\ \[Pi]\ x]\ A\&_\_3\%2 + 
          2\/3\ b\ \[Pi]\ x\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ A\&_\_3\%2, 
      \[Psi]\_\(1, 11\)[x] \[Rule] 
        1\/3\ b\ \[Alpha]\ A\_3\%2 - 
          1\/3\ b\ \[Alpha]\ Cos[2\ \[Pi]\ x]\ A\_3\%2 + 
          2\/3\ b\ \[Pi]\ x\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ A\_3\%2 + 
          \[Beta]\_11\/8 - 1\/8\ Cos[2\ \[Pi]\ x]\ \[Beta]\_11, 
      \[Psi]\_\(1, 12\)[x] \[Rule] 
        \[Beta]\_12\/32 - 1\/32\ Cos[4\ \[Pi]\ x]\ \[Beta]\_12 + 
          b\ \[Alpha]\ A\&_\_4\%2 - 
          b\ \[Alpha]\ Cos[4\ \[Pi]\ x]\ A\&_\_4\%2, 
      \[Psi]\_\(1, 13\)[x] \[Rule] 
        b\ \[Alpha]\ A\_4\%2 - b\ \[Alpha]\ Cos[4\ \[Pi]\ x]\ A\_4\%2 + 
          \[Beta]\_13\/32 - 1\/32\ Cos[4\ \[Pi]\ x]\ \[Beta]\_13}\)], "Output",\

  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Then, according to ",
  StyleBox["\[Psi]Form",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we pick up the spatial function forms for ",
  StyleBox["uSymbolv",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(bait1 = {a_. \ x\^n_.  :> x\^n /; FreeQ[a, x], 
        a_\ f_[b_\ x] :> f[b\ x] /; FreeQ[a, x], 
        a_\ x\ f_[b_\ x] :> x\ f[b\ x]}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(funcList = 
      Table[Prepend[
          \(\(Cases[\[Psi]Form[\([i, 2]\)], #]\ &\)\ /@\ bait1 // Flatten
              \) // Union, 1], {i, Length[\[Psi]Form]}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{1, x, x\^2, Cos[2\ \[Pi]\ x]}, {1, Cos[2\ \[Pi]\ x], 
        Cos[4\ \[Pi]\ x]}, {1, Cos[2\ \[Pi]\ x], Cos[4\ \[Pi]\ x]}, {1, 
        Cos[4\ \[Pi]\ x]}, {1, Cos[4\ \[Pi]\ x]}, {1, Cos[4\ \[Pi]\ x], 
        Sin[2\ \[Pi]\ x]}, {1, x, x\^2, Sin[2\ \[Pi]\ x]}, {1, x, x\^2, 
        Sin[2\ \[Pi]\ x]}, {1, Cos[4\ \[Pi]\ x], Sin[2\ \[Pi]\ x]}, {1, 
        Cos[2\ \[Pi]\ x], x\ Sin[2\ \[Pi]\ x]}, {1, Cos[2\ \[Pi]\ x], 
        x\ Sin[2\ \[Pi]\ x]}, {1, Cos[4\ \[Pi]\ x]}, {1, Cos[4\ \[Pi]\ x]}}
      \)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "We assume the solution for ",
  Cell[BoxData[
      \(TraditionalForm\`\[Psi]\_\(1, \ i\)\)]],
  " as a linear combination of ",
  StyleBox["funcList[[i]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", substitute it into ",
  StyleBox["\[Psi]Form[[i]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ",  equate both sides, solve for the undetermined coefficients, and obtain \
the solution for ",
  Cell[BoxData[
      \(TraditionalForm\`\[Psi]\_\(1, \ i\)\)]],
  " as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(psi1Sol = 
      Table[\n\t\tform = funcList[\([k]\)]; \n\t\t
        cList = Table[c\_i, {i, Length[form]}]; \n\t\tsol = cList . form; 
        algExpr = 
          sol - \[Psi]Form[\([k, 2]\)] /. 
            \[Beta]\_k_ -> 
              Integrate[
                Expand[\(y\^\[Prime]\)[x]\ D[sol, x] /. yRule], {x, 0, 1}]; \n
        \t\talgEq = 
          Append[Coefficient[algExpr, Rest[form]], 
                algExpr /. Thread[Rest[form] -> 0]] == 0 // Thread; \n\t\ \ 
        \[Psi]\_\(1, k\) -> 
          Function[x, 
            \(sol /. \(Solve[algEq, cList]\)[\([1]\)] // Expand\) // 
              Evaluate], \n\t\ {k, Length[\[Psi]Form]}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(Solve::"svars" \( : \ \) 
      "Equations may not give solutions for all \"solve\" variables."\)], 
  "Message",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(Solve::"svars" \( : \ \) 
      "Equations may not give solutions for all \"solve\" variables."\)], 
  "Message",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Psi]\_\(1, 1\) \[Rule] 
        Function[x, 
          \(-\(32\/3\)\)\ b\ \[Alpha]\ A\_1[T\_1, T\_2]\ 
              A\&_\_1[T\_1, T\_2] + 
            \(48\ b\ \[Pi]\^2\ x\ \[Alpha]\ A\_1[T\_1, T\_2]\ 
                A\&_\_1[T\_1, T\_2]\)\/\(3 + \[Pi]\^2\) - 
            \(48\ b\ \[Pi]\^2\ x\^2\ \[Alpha]\ A\_1[T\_1, T\_2]\ 
                A\&_\_1[T\_1, T\_2]\)\/\(3 + \[Pi]\^2\) + 
            32\/3\ b\ \[Alpha]\ Cos[2\ \[Pi]\ x]\ A\_1[T\_1, T\_2]\ 
              A\&_\_1[T\_1, T\_2] - 
            \(48\ b\ \[Pi]\^2\ x\ \[Alpha]\ A\_2[T\_1, T\_2]\ 
                A\&_\_2[T\_1, T\_2]\)\/\(3 + \[Pi]\^2\) + 
            \(48\ b\ \[Pi]\^2\ x\^2\ \[Alpha]\ A\_2[T\_1, T\_2]\ 
                A\&_\_2[T\_1, T\_2]\)\/\(3 + \[Pi]\^2\) - 
            \(12\ b\ \[Pi]\^2\ x\ \[Alpha]\ A\_3[T\_1, T\_2]\ 
                A\&_\_3[T\_1, T\_2]\)\/\(3 + \[Pi]\^2\) + 
            \(12\ b\ \[Pi]\^2\ x\^2\ \[Alpha]\ A\_3[T\_1, T\_2]\ 
                A\&_\_3[T\_1, T\_2]\)\/\(3 + \[Pi]\^2\) - 
            \(48\ b\ \[Pi]\^2\ x\ \[Alpha]\ A\_4[T\_1, T\_2]\ 
                A\&_\_4[T\_1, T\_2]\)\/\(3 + \[Pi]\^2\) + 
            \(48\ b\ \[Pi]\^2\ x\^2\ \[Alpha]\ A\_4[T\_1, T\_2]\ 
                A\&_\_4[T\_1, T\_2]\)\/\(3 + \[Pi]\^2\)], 
      \[Psi]\_\(1, 2\) \[Rule] 
        Function[x, 
          4\/9\ b\ \[Alpha]\ A\&_\_1[T\_1, T\_2]\^2 - 
            16\/9\ b\ \[Alpha]\ Cos[2\ \[Pi]\ x]\ A\&_\_1[T\_1, T\_2]\^2 + 
            4\/3\ b\ \[Alpha]\ Cos[4\ \[Pi]\ x]\ A\&_\_1[T\_1, T\_2]\^2], 
      \[Psi]\_\(1, 3\) \[Rule] 
        Function[x, 
          4\/9\ b\ \[Alpha]\ A\_1[T\_1, T\_2]\^2 - 
            16\/9\ b\ \[Alpha]\ Cos[2\ \[Pi]\ x]\ A\_1[T\_1, T\_2]\^2 + 
            4\/3\ b\ \[Alpha]\ Cos[4\ \[Pi]\ x]\ A\_1[T\_1, T\_2]\^2], 
      \[Psi]\_\(1, 4\) \[Rule] 
        Function[x, 
          4\/3\ b\ \[Alpha]\ A\&_\_2[T\_1, T\_2]\^2 - 
            4\/3\ b\ \[Alpha]\ Cos[4\ \[Pi]\ x]\ A\&_\_2[T\_1, T\_2]\^2], 
      \[Psi]\_\(1, 5\) \[Rule] 
        Function[x, 
          4\/3\ b\ \[Alpha]\ A\_2[T\_1, T\_2]\^2 - 
            4\/3\ b\ \[Alpha]\ Cos[4\ \[Pi]\ x]\ A\_2[T\_1, T\_2]\^2], 
      \[Psi]\_\(1, 6\) \[Rule] 
        Function[x, 
          \(16\ b\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ A\&_\_1[T\_1, T\_2]\ 
              A\&_\_2[T\_1, T\_2]\)\/\(3\ \@3\)], 
      \[Psi]\_\(1, 7\) \[Rule] 
        Function[x, 
          \(-\(\(16\ b\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ A\_1[T\_1, T\_2]\ 
                  A\&_\_2[T\_1, T\_2]\)\/\@3\)\)], 
      \[Psi]\_\(1, 8\) \[Rule] 
        Function[x, 
          \(-\(\(16\ b\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ A\_2[T\_1, T\_2]\ 
                  A\&_\_1[T\_1, T\_2]\)\/\@3\)\)], 
      \[Psi]\_\(1, 9\) \[Rule] 
        Function[x, 
          \(16\ b\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ A\_1[T\_1, T\_2]\ 
              A\_2[T\_1, T\_2]\)\/\(3\ \@3\)], 
      \[Psi]\_\(1, 10\) \[Rule] 
        Function[x, 
          \(-c\_2\) + Cos[2\ \[Pi]\ x]\ c\_2 + 
            2\/3\ b\ \[Pi]\ x\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ 
              A\&_\_3[T\_1, T\_2]\^2], 
      \[Psi]\_\(1, 11\) \[Rule] 
        Function[x, 
          \(-c\_2\) + Cos[2\ \[Pi]\ x]\ c\_2 + 
            2\/3\ b\ \[Pi]\ x\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ 
              A\_3[T\_1, T\_2]\^2], 
      \[Psi]\_\(1, 12\) \[Rule] 
        Function[x, 
          4\/3\ b\ \[Alpha]\ A\&_\_4[T\_1, T\_2]\^2 - 
            4\/3\ b\ \[Alpha]\ Cos[4\ \[Pi]\ x]\ A\&_\_4[T\_1, T\_2]\^2], 
      \[Psi]\_\(1, 13\) \[Rule] 
        Function[x, 
          4\/3\ b\ \[Alpha]\ A\_4[T\_1, T\_2]\^2 - 
            4\/3\ b\ \[Alpha]\ Cos[4\ \[Pi]\ x]\ A\_4[T\_1, T\_2]\^2]}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
We note that all of the spatial dependent functions satisfy the boundary \
conditions.\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "The ",
  StyleBox["sol2Formv1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " consists of two parts: a part is related to the secular terms, which \
consists of terms proportional to ",
  Cell[BoxData[
      \(TraditionalForm\`E\^\(\(\[PlusMinus]I\)\ \[Omega]\_1\ T\_0\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`E\^\(\(\[PlusMinus]I\)\ \[Omega]\_2\ T\_0\)\)]],
  " and the other part consists of terms that are not related to the secular \
terms. The positions of the former are"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(pos[1] = 
      \(\((\(Position[
                  \(#\ sol2Formv1 /. expRule1[1]\) /. 
                    Exp[_.  + _\ T\_0] -> 0, a_ /; a =!= 0, 1] // Flatten
                \) // Rest)\)\ &\)\ /@
        \ {E\^\(\(-I\)\ \[Omega]\_1\ T\_0\), E\^\(I\ \[Omega]\_1\ T\_0\)}\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{11}, {10}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(pos[2] = 
      \(\((\(Position[
                  \(#\ sol2Formv1 /. expRule1[2]\) /. 
                    Exp[_.  + _\ T\_0] -> 0, a_ /; a =!= 0, 1] // Flatten
                \) // Rest)\)\ &\)\ /@
        \ {E\^\(\(-I\)\ \[Omega]\_2\ T\_0\), E\^\(I\ \[Omega]\_2\ T\_0\)}\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{11}, {10}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Since ",
  StyleBox["pos[1]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["pos[2]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " are the same, we simply define"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \({pos1, pos1cc} = pos[1] // Flatten\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({11, 10}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Next, we augment ",
  Cell[BoxData[
      \(\[Psi]\_\(1, pos1\)\)]],
  " and ",
  Cell[BoxData[
      \(\[Eta]\_\(1, pos1\)\)]],
  " by a linear combination of all possible homogeneous solutions. The \
unknown coefficients can be determined by the orthogonality conditions. (",
  Cell[BoxData[
      \(TraditionalForm\`\[Psi]\_\(1, pos1cc\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Eta]\_\(1, pos1cc\)\)]],
  " are simply the complex conjugates of ",
  Cell[BoxData[
      \(TraditionalForm\`\[Psi]\_\(1, pos1\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Eta]\_\(1, pos1\)\)]],
  ", respectively.) First, we express their solution forms using ",
  StyleBox["psi1Sol",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["eta1Sol ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(STFormv = 
      \(\(\(\({\[Psi]\_\(1, pos1\)[x] + 
                      Sum[c\_\(1, j\)\ \[CapitalPhi]\_j[x], {j, 2}], 
                    \[Eta]\_\(1, pos1\)[x] + 
                      Sum[c\_\(1, j\)\ I\ \[Omega]\_j\ \[CapitalPhi]\_j[x], {
                          j, 2}]} /. eta1Sol\) /. psi1Sol\) /. 
              c\_i_ -> 0\) /. modeshapes\) /. params // Expand\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\@\(2\/3\)\ c\_\(1, 1\) - \@\(2\/3\)\ Cos[2\ \[Pi]\ x]\ c\_\(1, 1\) + 
        \@2\ Sin[2\ \[Pi]\ x]\ c\_\(1, 2\) + 
        2\/3\ b\ \[Pi]\ x\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ A\_3[T\_1, T\_2]\^2, 
      2\ I\ \@\(2\/3\)\ \[Pi]\ c\_\(1, 1\) - 
        2\ I\ \@\(2\/3\)\ \[Pi]\ Cos[2\ \[Pi]\ x]\ c\_\(1, 1\) + 
        2\ I\ \@2\ \[Pi]\ Sin[2\ \[Pi]\ x]\ c\_\(1, 2\) + 
        2\/3\ I\ b\ \[Pi]\ \[Alpha]\ A\_3[T\_1, T\_2]\^2 - 
        2\/3\ I\ b\ \[Pi]\ \[Alpha]\ Cos[2\ \[Pi]\ x]\ A\_3[T\_1, T\_2]\^2 + 
        4\/3\ I\ b\ \[Pi]\^2\ x\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ 
          A\_3[T\_1, T\_2]\^2}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Demanding that ",
  StyleBox["STFormv",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  StyleBox[" ",
    FontColor->RGBColor[1, 0, 1]],
  "be orthogonal to the ",
  StyleBox["adjointC[[i]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain the unknown coefficients"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(c1Rule = 
      \(Solve[\(\(\(\(int[adjointC[\([#]\)] . STFormv, {x, 0, 1}] == 0 /. 
                        modeshapes\) /. params\) /. intRule1\) //. intRule2
                  \) /. int -> Integrate, c\_\(1, #\)]\ &\)\ /@\ {1, 2} // 
        Flatten\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({c\_\(1, 1\) \[Rule] 0, 
      c\_\(1, 2\) \[Rule] 
        \(-\(\(b\ \[Pi]\ \[Alpha]\ A\_3[T\_1, T\_2]\^2\)\/\(3\ \@2\)\)\)}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Then, we adjust ",
  StyleBox["psi1Sol",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " with"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(psi1Sol[\([pos1]\)] = 
      \[Psi]\_\(1, pos1\) -> 
        Function[x, STFormv[\([1]\)] /. c1Rule // Evaluate]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\[Psi]\_\(1, 11\) \[Rule] 
      Function[x, 
        \(-\(1\/3\)\)\ b\ \[Pi]\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ 
            A\_3[T\_1, T\_2]\^2 + 
          2\/3\ b\ \[Pi]\ x\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ A\_3[T\_1, T\_2]\^2]
        \)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(psi1Sol[\([pos1cc]\)] = 
      \[Psi]\_\(1, pos1cc\) -> 
        Function[x, 
          \(STFormv[\([1]\)] /. c1Rule\) /. conjugateRule // Evaluate]\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\[Psi]\_\(1, 10\) \[Rule] 
      Function[x, 
        \(-\(1\/3\)\)\ b\ \[Pi]\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ 
            A\&_\_3[T\_1, T\_2]\^2 + 
          2\/3\ b\ \[Pi]\ x\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ 
            A\&_\_3[T\_1, T\_2]\^2]\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Horizontal Modes", "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "The ",
  StyleBox["sol2Formh",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " consists of two parts: a part is related to the secular terms, which \
consists of terms proportional to ",
  Cell[BoxData[
      \(TraditionalForm\`E\^\(\(\[PlusMinus]I\)\ \[Omega]\_3\ T\_0\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`E\^\(\(\[PlusMinus]I\)\ \[Omega]\_4\ T\_0\)\)]],
  " and the other part consists of terms that are not related to the secular \
terms. The positions of the former are"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(pos[3] = 
      \(\((\(Position[
                  \(#\ sol2Formh /. expRule1[3]\) /. Exp[_.  + _\ T\_0] -> 0, 
                  a_ /; a =!= 0, 1] // Flatten\) // Rest)\)\ &\)\ /@
        \ {E\^\(\(-I\)\ \[Omega]\_3\ T\_0\), E\^\(I\ \[Omega]\_3\ T\_0\)}\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{2}, {3}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(pos[4] = 
      \(\((\(Position[
                  \(#\ sol2Formh /. expRule1[4]\) /. Exp[_.  + _\ T\_0] -> 0, 
                  a_ /; a =!= 0, 1] // Flatten\) // Rest)\)\ &\)\ /@
        \ {E\^\(\(-I\)\ \[Omega]\_4\ T\_0\), E\^\(I\ \[Omega]\_4\ T\_0\)}\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{}, {}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Hence, we assume that the solution for ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\(2, \ 2\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`v\_\(2, \ 2\)\)]],
  " consists of two parts corresponding to the parts in ",
  StyleBox["sol2Formh",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ". The part, which is not related to the secular terms, is"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2Formha = Delete[sol2Formh, pos[3]]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_3\)\ 
        Sin[\[Pi]\ x], 
      E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_3\)\ Sin[\[Pi]\ x], 
      E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_4\)\ 
        Sin[2\ \[Pi]\ x], 
      E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_4\)\ Sin[2\ \[Pi]\ x], 
      E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_4\)\ 
        Sin[2\ \[Pi]\ x], 
      E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_4\)\ Sin[2\ \[Pi]\ x]}
      \)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["We define the corresponding undetermined coefficients as", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(uSymbolha = Table[\[Psi]\_\(2, i\), {i, Length[sol2Formha]}]; \n
    vSymbolha = uSymbolha /. \[Psi] -> \[Eta]; \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Hence, the general solution in terms of the ",
  StyleBox["sol2Formha",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " can be written as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(sol2ha = {
        u\_\(2, 2\) -> 
          Function[{x, T\_0, T\_1, T\_2}, 
            uSymbolha . sol2Formha // Evaluate], 
        v\_\(2, 2\) -> 
          Function[{x, T\_0, T\_1, T\_2}, 
            vSymbolha . sol2Formha // Evaluate]}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "The part of ",
  StyleBox["sol2Formh",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", which is related to the secular terms, is"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2Formhb = sol2Formh[\([\(pos[3]\)[\([1]\)]]\)]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_3\)\ Sin[\[Pi]\ x]}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["and define the undetermined coefficients as", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(uSymbolhb = Table[\[Psi]s\_\(2, i\), {i, Length[sol2Formhb]}]; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "where the undetermined coefficients for ",
  Cell[BoxData[
      \(TraditionalForm\`v\_\(2, \ 2\)\)]],
  " are related to the ",
  StyleBox["uSymbolhb",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " due to the orthogonality condition. Therefore, the general solution in \
terms of the ",
  StyleBox["sol2Formhb",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " can be written as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(sol2hb = {
        u\_\(2, 2\) -> 
          Function[{x, T\_0, T\_1, T\_2}, 
            uSymbolhb . sol2Formhb // Evaluate], 
        v\_\(2, 2\) -> 
          Function[{x, T\_0, T\_1, T\_2}, 
            \(-I\)\ \[Omega]\_3\ uSymbolhb . sol2Formhb // Evaluate]}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "The total solution is a combination of ",
  StyleBox["sol2ha",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", ",
  StyleBox["sol2hb",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", and the complex conjugate of ",
  StyleBox["sol2hb",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting ",
  StyleBox["sol2ha",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["order2Eqm[[{3,4}]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and equating the coefficients of ",
  StyleBox["sol2Formha ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "on both sides, we have"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(algEqa = 
      Flatten[\(Coefficient[Subtract\ @@\ # /. sol2ha, sol2Formha]\ &\)\ /@\ 
              order2Eqm[\([{3, 4}]\)]] == 0 // Thread; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Solving for the ",
  StyleBox["uSymbolha",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and the ",
  StyleBox["vSymbolha",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(symbolaRule = 
      \(Solve[algEqa, uSymbolha~Join~vSymbolha]\)[\([1]\)] /. params\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Psi]\_\(2, 1\) \[Rule] 
        \(2\ b\ \[Alpha]\ A\&_\_1[T\_1, T\_2]\ A\&_\_3[T\_1, T\_2]\)\/\@3, 
      \[Psi]\_\(2, 2\) \[Rule] 
        \(2\ b\ \[Alpha]\ A\_1[T\_1, T\_2]\ A\_3[T\_1, T\_2]\)\/\@3, 
      \[Psi]\_\(2, 3\) \[Rule] 
        \(16\ b\ \[Alpha]\ A\&_\_1[T\_1, T\_2]\ A\&_\_4[T\_1, T\_2]\)\/\(3\ 
            \@3\), \[Psi]\_\(2, 4\) \[Rule] 
        \(-\(\(16\ b\ \[Alpha]\ A\_1[T\_1, T\_2]\ A\&_\_4[T\_1, T\_2]\)\/\@3
                \)\), \[Psi]\_\(2, 5\) \[Rule] 
        \(-\(\(16\ b\ \[Alpha]\ A\_4[T\_1, T\_2]\ A\&_\_1[T\_1, T\_2]\)\/\@3
                \)\), \[Psi]\_\(2, 6\) \[Rule] 
        \(16\ b\ \[Alpha]\ A\_1[T\_1, T\_2]\ A\_4[T\_1, T\_2]\)\/\(3\ \@3\), 
      \[Eta]\_\(2, 1\) \[Rule] 
        \(-2\)\ I\ \@3\ b\ \[Pi]\ \[Alpha]\ A\&_\_1[T\_1, T\_2]\ 
          A\&_\_3[T\_1, T\_2], 
      \[Eta]\_\(2, 2\) \[Rule] 
        2\ I\ \@3\ b\ \[Pi]\ \[Alpha]\ A\_1[T\_1, T\_2]\ A\_3[T\_1, T\_2], 
      \[Eta]\_\(2, 3\) \[Rule] 
        \(-\(\(64\ I\ b\ \[Pi]\ \[Alpha]\ A\&_\_1[T\_1, T\_2]\ 
                A\&_\_4[T\_1, T\_2]\)\/\(3\ \@3\)\)\), 
      \[Eta]\_\(2, 4\) \[Rule] 0, \[Eta]\_\(2, 5\) \[Rule] 0, 
      \[Eta]\_\(2, 6\) \[Rule] 
        \(64\ I\ b\ \[Pi]\ \[Alpha]\ A\_1[T\_1, T\_2]\ A\_4[T\_1, T\_2]\)\/\(3
            \ \@3\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Substituting ",
  StyleBox["sol2hb",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into either of ",
  StyleBox["order2Eqm[[{3,4}]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", equating the coefficients of ",
  StyleBox["sol2Formhb",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " on both sides, and solving for the ",
  StyleBox["uSymbolhb",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we have"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(symbolbRule = 
      \(Solve[Coefficient[Subtract\ @@\ order2Eqm[\([3]\)] /. sol2hb, 
                  sol2Formhb] == 0 // Thread, uSymbolhb]\)[\([1]\)] /. params
        \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Psi]s\_\(2, 1\) \[Rule] 
        \(-\(\(4\ b\ \[Alpha]\ A\_1[T\_1, T\_2]\ A\&_\_3[T\_1, T\_2]\)\/\@3
                \)\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Substituting ",
  StyleBox["symbolaRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["symbolbRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["sol2ha",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["sol2hb",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(sol2haForm = 
      \({u\_\(2, 2\)[x, T\_0, T\_1, T\_2], 
            v\_\(2, 2\)[x, T\_0, T\_1, T\_2]} /. sol2ha\) /. symbolaRule; \n
    sol2hbForm = 
      \({u\_\(2, 2\)[x, T\_0, T\_1, T\_2], 
            v\_\(2, 2\)[x, T\_0, T\_1, T\_2]} /. sol2hb\) /. symbolbRule; 
    \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2h = {
        u\_\(2, 2\) \[Rule] 
          Function[{x, T\_0, T\_1, T\_2}, 
            \(sol2haForm[\([1]\)] + sol2hbForm[\([1]\)] + 
                  \((sol2hbForm[\([1]\)] /. conjugateRule)\) // Expand\) // 
              Evaluate], 
        v\_\(2, 2\) \[Rule] 
          Function[{x, T\_0, T\_1, T\_2}, 
            \(sol2haForm[\([2]\)] + sol2hbForm[\([2]\)] + 
                  \((sol2hbForm[\([2]\)] /. conjugateRule)\) // Expand\) // 
              Evaluate]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_\(2, 2\) \[Rule] 
        Function[{x, T\_0, T\_1, T\_2}, 
          \(2\ b\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_3\)\ 
                \[Alpha]\ Sin[\[Pi]\ x]\ A\_1[T\_1, T\_2]\ 
                A\_3[T\_1, T\_2]\)\/\@3 + 
            \(16\ b\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_4\)\ 
                \[Alpha]\ Sin[2\ \[Pi]\ x]\ A\_1[T\_1, T\_2]\ 
                A\_4[T\_1, T\_2]\)\/\(3\ \@3\) - 
            \(4\ b\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_3\)\ 
                \[Alpha]\ Sin[\[Pi]\ x]\ A\_3[T\_1, T\_2]\ 
                A\&_\_1[T\_1, T\_2]\)\/\@3 - 
            \(16\ b\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_4\)\ 
                \[Alpha]\ Sin[2\ \[Pi]\ x]\ A\_4[T\_1, T\_2]\ 
                A\&_\_1[T\_1, T\_2]\)\/\@3 - 
            \(4\ b\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_3\)\ 
                \[Alpha]\ Sin[\[Pi]\ x]\ A\_1[T\_1, T\_2]\ 
                A\&_\_3[T\_1, T\_2]\)\/\@3 + 
            \(2\ b\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_3\)\ 
                \[Alpha]\ Sin[\[Pi]\ x]\ A\&_\_1[T\_1, T\_2]\ 
                A\&_\_3[T\_1, T\_2]\)\/\@3 - 
            \(16\ b\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_4\)\ 
                \[Alpha]\ Sin[2\ \[Pi]\ x]\ A\_1[T\_1, T\_2]\ 
                A\&_\_4[T\_1, T\_2]\)\/\@3 + 
            \(16\ b\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_4\)\ 
                \[Alpha]\ Sin[2\ \[Pi]\ x]\ A\&_\_1[T\_1, T\_2]\ 
                A\&_\_4[T\_1, T\_2]\)\/\(3\ \@3\)], 
      v\_\(2, 2\) \[Rule] 
        Function[{x, T\_0, T\_1, T\_2}, 
          2\ I\ \@3\ b\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_3\)\ 
              \[Pi]\ \[Alpha]\ Sin[\[Pi]\ x]\ A\_1[T\_1, T\_2]\ 
              A\_3[T\_1, T\_2] + 
            \(64\ I\ b\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_4\)\ 
                \[Pi]\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ A\_1[T\_1, T\_2]\ 
                A\_4[T\_1, T\_2]\)\/\(3\ \@3\) - 
            \(4\ I\ b\ 
                E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_3\)\ 
                \[Alpha]\ Sin[\[Pi]\ x]\ \[Omega]\_3\ A\_3[T\_1, T\_2]\ 
                A\&_\_1[T\_1, T\_2]\)\/\@3 + 
            \(4\ I\ b\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_3\)\ 
                \[Alpha]\ Sin[\[Pi]\ x]\ \[Omega]\_3\ A\_1[T\_1, T\_2]\ 
                A\&_\_3[T\_1, T\_2]\)\/\@3 - 
            2\ I\ \@3\ b\ 
              E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_3\)\ \[Pi]\ 
              \[Alpha]\ Sin[\[Pi]\ x]\ A\&_\_1[T\_1, T\_2]\ 
              A\&_\_3[T\_1, T\_2] - 
            \(64\ I\ b\ 
                E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_4\)\ 
                \[Pi]\ \[Alpha]\ Sin[2\ \[Pi]\ x]\ A\&_\_1[T\_1, T\_2]\ 
                A\&_\_4[T\_1, T\_2]\)\/\(3\ \@3\)]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["9.2.3 Solvability Conditions", "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting ",
  StyleBox["sol1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", ",
  StyleBox["sol2v",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", and ",
  StyleBox["sol2h",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["eqEps[[3]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(order3Eq = 
        \((linearSys /. u_\_\(k_, 1\) -> u\_\(k, 3\))\) == 
            \((\(\(\(\(\(\(\(\(\(\((linearSys /. u_\_\(k_, 1\) -> u\_\(k, 3\))
                                        \) - 
                                      \((\(#[\([1]\)]\ &\)\ /@\ 
                                        eqEps[\([3]\)])\) /. sol1\) /. sol2v
                                  \) /. eta1Sol\) /. psi1Sol\) /. sol2h\) /. 
                          intRule1\) //. intRule2\) /. modeshapes\) /. yRule
                    \) /. int -> Integrate // Expand)\) // Thread; \) // 
      Timing\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({43.2419999999999671`\ Second, Null}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Collecting the terms that may lead to secular terms, the terms \
proportional to ",
  Cell[BoxData[
      \(E\^\(I\ \[Omega]\_i\ T\_0\)\)]],
  ", from the equations governing the vertical modes, we have"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(ST2v = 
      \(Coefficient[
            \(#[\([2]\)]\ &\)\ /@\ order3Eq[\([{1, 2}]\)] /. expRule1[#], 
            E\^\(I\ \[Omega]\_#\ T\_0\)]\ &\)\ /@\ {1, 2}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
Collecting the terms that may lead to secular terms from the equations \
governing the horizontal modes, we have\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(ST2h = 
      \(Coefficient[
            \(#[\([2]\)]\ &\)\ /@\ order3Eq[\([{3, 4}]\)] /. expRule1[#], 
            E\^\(I\ \[Omega]\_#\ T\_0\)]\ &\)\ /@\ {3, 4}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Demanding that ",
  StyleBox["ST2v[[i]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  StyleBox[" ",
    FontColor->RGBColor[1, 0, 1]],
  "be orthogonal to the ",
  StyleBox["adjointC[[i]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain the solvability conditions"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"SCond2v", "=", 
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{"Solve", "[", 
                    RowBox[{
                    \(\((\(\(\(\(int[adjointC[\([#]\)] . ST2v[\([#]\)], {x, 
                                        0, 1}] /. intRule1\) //. intRule2
                                  \) /. modeshapes\) /. params\) /. 
                            int -> Integrate)\) == 0\), ",", 
                      RowBox[{
                        SubsuperscriptBox["A", "#", 
                          TagBox[\((0, 1)\),
                            Derivative],
                          MultilineFunction->None], "[", \(T\_1, T\_2\), 
                        "]"}]}], "]"}], "[", \([1]\), "]"}], " ", "&"}], " ", 
              "/@", " ", \({1, 2}\)}], "//", "Flatten"}], "//", 
          "ExpandAll"}]}], ";", "\n", \(SCond2v /. displayRule\)}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          InterpretationBox[\(D\_2\[InvisibleSpace]A\_1\),
            SequenceForm[ 
              Subscript[ D, 2], 
              Subscript[ A, 1]],
            Editable->False], "\[Rule]", 
          \(\(-\(\(I\ E\^\(I\ T\_1\ \[Sigma]\_1 + I\ \[Tau]\_1\)\ 
                    \(\[Integral]\_0\%1
                        \((P\_1[x] - Cos[2\ \[Pi]\ x]\ P\_1[x])\) 
                        \[DifferentialD]x\)\)\/\(4\ \@6\ \[Pi]\)\)\) - 
            A\_1\ \[Mu]\_1 + 2\/3\ I\ \[Pi]\^3\ \[Alpha]\ A\_1\%2\ A\&_\_1 - 
            224\/3\ I\ b\^2\ \[Pi]\ \[Alpha]\^2\ A\_1\%2\ A\&_\_1 + 
            \(256\ I\ b\^2\ \[Pi]\ \[Alpha]\^2\ A\_1\%2\ A\&_\_1\)\/\(3 + 
                \[Pi]\^2\) + 
            \(64\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\ A\_1\%2\ A\&_\_1\)\/\(9 + 
                3\ \[Pi]\^2\) + 
            2\/3\ I\ E\^\(2\ I\ T\_1\ \[Sigma]\_2\)\ \[Pi]\^3\ \[Alpha]\ 
              A\_2\%2\ A\&_\_1 - 
            352\/9\ I\ b\^2\ E\^\(2\ I\ T\_1\ \[Sigma]\_2\)\ \[Pi]\ 
              \[Alpha]\^2\ A\_2\%2\ A\&_\_1 + 
            2\/3\ I\ E\^\(2\ I\ T\_1\ \[Sigma]\_4\)\ \[Pi]\^3\ \[Alpha]\ 
              A\_4\%2\ A\&_\_1 - 
            352\/9\ I\ b\^2\ E\^\(2\ I\ T\_1\ \[Sigma]\_4\)\ \[Pi]\ 
              \[Alpha]\^2\ A\_4\%2\ A\&_\_1 + 
            4\/3\ I\ \[Pi]\^3\ \[Alpha]\ A\_1\ A\_2\ A\&_\_2 - 
            256\/9\ I\ b\^2\ \[Pi]\ \[Alpha]\^2\ A\_1\ A\_2\ A\&_\_2 - 
            \(256\ I\ b\^2\ \[Pi]\ \[Alpha]\^2\ A\_1\ A\_2\ A\&_\_2\)\/\(3 + 
                \[Pi]\^2\) - 
            \(64\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\ A\_1\ A\_2\ 
                A\&_\_2\)\/\(9 + 3\ \[Pi]\^2\) + 
            1\/3\ I\ \[Pi]\^3\ \[Alpha]\ A\_1\ A\_3\ A\&_\_3 - 
            4\/3\ I\ b\^2\ \[Pi]\ \[Alpha]\^2\ A\_1\ A\_3\ A\&_\_3 - 
            \(64\ I\ b\^2\ \[Pi]\ \[Alpha]\^2\ A\_1\ A\_3\ A\&_\_3\)\/\(3 + 
                \[Pi]\^2\) - 
            \(16\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\ A\_1\ A\_3\ 
                A\&_\_3\)\/\(9 + 3\ \[Pi]\^2\) + 
            4\/3\ I\ \[Pi]\^3\ \[Alpha]\ A\_1\ A\_4\ A\&_\_4 - 
            256\/9\ I\ b\^2\ \[Pi]\ \[Alpha]\^2\ A\_1\ A\_4\ A\&_\_4 - 
            \(256\ I\ b\^2\ \[Pi]\ \[Alpha]\^2\ A\_1\ A\_4\ A\&_\_4\)\/\(3 + 
                \[Pi]\^2\) - 
            \(64\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\ A\_1\ A\_4\ 
                A\&_\_4\)\/\(9 + 3\ \[Pi]\^2\)\)}], ",", 
        RowBox[{
          InterpretationBox[\(D\_2\[InvisibleSpace]A\_2\),
            SequenceForm[ 
              Subscript[ D, 2], 
              Subscript[ A, 2]],
            Editable->False], "\[Rule]", 
          \(\(-\(\(I\ 
                    E\^\(I\ T\_1\ \[Sigma]\_1 - I\ T\_1\ \[Sigma]\_2 + 
                        I\ \[Tau]\_1\)\ 
                    \(\[Integral]\_0\%1\( Sin[2\ \[Pi]\ x]\ P\_1[x]\) 
                        \[DifferentialD]x\)\)\/\(4\ \@2\ \[Pi]\)\)\) - 
            A\_2\ \[Mu]\_1 + 
            4\/3\ I\ \[Pi]\^3\ \[Alpha]\ A\_1\ A\_2\ A\&_\_1 - 
            1024\/9\ I\ b\^2\ \[Pi]\ \[Alpha]\^2\ A\_1\ A\_2\ A\&_\_1 + 
            \(64\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\ A\_1\ A\_2\ 
                A\&_\_1\)\/\(3 + \[Pi]\^2\) + 
            2\/3\ I\ E\^\(\(-2\)\ I\ T\_1\ \[Sigma]\_2\)\ \[Pi]\^3\ \[Alpha]\ 
              A\_1\%2\ A\&_\_2 - 
            352\/9\ I\ b\^2\ E\^\(\(-2\)\ I\ T\_1\ \[Sigma]\_2\)\ \[Pi]\ 
              \[Alpha]\^2\ A\_1\%2\ A\&_\_2 + 
            6\ I\ \[Pi]\^3\ \[Alpha]\ A\_2\%2\ A\&_\_2 + 
            32\/3\ I\ b\^2\ \[Pi]\ \[Alpha]\^2\ A\_2\%2\ A\&_\_2 - 
            \(64\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\ A\_2\%2\ A\&_\_2\)\/\(3 + 
                \[Pi]\^2\) + 
            2\ I\ E\^\(\(-2\)\ I\ T\_1\ \[Sigma]\_2 + 
                  2\ I\ T\_1\ \[Sigma]\_4\)\ \[Pi]\^3\ \[Alpha]\ A\_4\%2\ 
              A\&_\_2 + 
            32\/3\ I\ b\^2\ 
              E\^\(\(-2\)\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ T\_1\ \[Sigma]\_4\)\ 
              \[Pi]\ \[Alpha]\^2\ A\_4\%2\ A\&_\_2 + 
            I\ \[Pi]\^3\ \[Alpha]\ A\_2\ A\_3\ A\&_\_3 - 
            \(16\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\ A\_2\ A\_3\ 
                A\&_\_3\)\/\(3 + \[Pi]\^2\) + 
            4\ I\ \[Pi]\^3\ \[Alpha]\ A\_2\ A\_4\ A\&_\_4 - 
            \(64\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\ A\_2\ A\_4\ 
                A\&_\_4\)\/\(3 + \[Pi]\^2\)\)}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Demanding that ",
  StyleBox["ST2h[[i]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  StyleBox[" ",
    FontColor->RGBColor[1, 0, 1]],
  "be orthogonal to the ",
  StyleBox["adjointC[[i+2]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain the solvability conditions"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"SCond2h", "=", 
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{"Solve", "[", 
                    RowBox[{
                    \(\((\(\(\(\(int[adjointC[\([# + 2]\)] . ST2h[\([#]\)], {
                                        x, 0, 1}] /. intRule1\) //. intRule2
                                  \) /. modeshapes\) /. params\) /. 
                            int -> Integrate)\) == 0\), ",", 
                      RowBox[{
                        SubsuperscriptBox["A", \(# + 2\), 
                          TagBox[\((0, 1)\),
                            Derivative],
                          MultilineFunction->None], "[", \(T\_1, T\_2\), 
                        "]"}]}], "]"}], "[", \([1]\), "]"}], " ", "&"}], " ", 
              "/@", " ", \({1, 2}\)}], "//", "Flatten"}], "//", 
          "ExpandAll"}]}], ";", "\n", \(SCond2h /. displayRule\)}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          InterpretationBox[\(D\_2\[InvisibleSpace]A\_3\),
            SequenceForm[ 
              Subscript[ D, 2], 
              Subscript[ A, 3]],
            Editable->False], "\[Rule]", 
          \(\(-A\_3\)\ \[Mu]\_2 + 
            2\/3\ I\ \[Pi]\^3\ \[Alpha]\ A\_1\ A\_3\ A\&_\_1 - 
            136\/3\ I\ b\^2\ \[Pi]\ \[Alpha]\^2\ A\_1\ A\_3\ A\&_\_1 + 
            \(32\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\ A\_1\ A\_3\ 
                A\&_\_1\)\/\(3 + \[Pi]\^2\) + 
            2\ I\ \[Pi]\^3\ \[Alpha]\ A\_2\ A\_3\ A\&_\_2 - 
            \(32\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\ A\_2\ A\_3\ 
                A\&_\_2\)\/\(3 + \[Pi]\^2\) + 
            3\/4\ I\ \[Pi]\^3\ \[Alpha]\ A\_3\%2\ A\&_\_3 - 
            4\/3\ I\ b\^2\ \[Pi]\ \[Alpha]\^2\ A\_3\%2\ A\&_\_3 - 
            \(8\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\ A\_3\%2\ A\&_\_3\)\/\(3 + 
                \[Pi]\^2\) + 2\ I\ \[Pi]\^3\ \[Alpha]\ A\_3\ A\_4\ A\&_\_4 - 
            \(32\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\ A\_3\ A\_4\ 
                A\&_\_4\)\/\(3 + \[Pi]\^2\)\)}], ",", 
        RowBox[{
          InterpretationBox[\(D\_2\[InvisibleSpace]A\_4\),
            SequenceForm[ 
              Subscript[ D, 2], 
              Subscript[ A, 4]],
            Editable->False], "\[Rule]", 
          \(\(-\(\(I\ 
                    E\^\(I\ T\_1\ \[Sigma]\_1 - I\ T\_1\ \[Sigma]\_4 + 
                        I\ \[Tau]\_2\)\ 
                    \(\[Integral]\_0\%1\( Sin[2\ \[Pi]\ x]\ P\_2[x]\) 
                        \[DifferentialD]x\)\)\/\(4\ \@2\ \[Pi]\)\)\) - 
            A\_4\ \[Mu]\_2 + 
            4\/3\ I\ \[Pi]\^3\ \[Alpha]\ A\_1\ A\_4\ A\&_\_1 - 
            1024\/9\ I\ b\^2\ \[Pi]\ \[Alpha]\^2\ A\_1\ A\_4\ A\&_\_1 + 
            \(64\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\ A\_1\ A\_4\ 
                A\&_\_1\)\/\(3 + \[Pi]\^2\) + 
            4\ I\ \[Pi]\^3\ \[Alpha]\ A\_2\ A\_4\ A\&_\_2 - 
            \(64\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\ A\_2\ A\_4\ 
                A\&_\_2\)\/\(3 + \[Pi]\^2\) + 
            I\ \[Pi]\^3\ \[Alpha]\ A\_3\ A\_4\ A\&_\_3 - 
            \(16\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\ A\_3\ A\_4\ 
                A\&_\_3\)\/\(3 + \[Pi]\^2\) + 
            2\/3\ I\ E\^\(\(-2\)\ I\ T\_1\ \[Sigma]\_4\)\ \[Pi]\^3\ \[Alpha]\ 
              A\_1\%2\ A\&_\_4 - 
            352\/9\ I\ b\^2\ E\^\(\(-2\)\ I\ T\_1\ \[Sigma]\_4\)\ \[Pi]\ 
              \[Alpha]\^2\ A\_1\%2\ A\&_\_4 + 
            2\ I\ E\^\(2\ I\ T\_1\ \[Sigma]\_2 - 2\ I\ T\_1\ \[Sigma]\_4\)\ 
              \[Pi]\^3\ \[Alpha]\ A\_2\%2\ A\&_\_4 + 
            32\/3\ I\ b\^2\ 
              E\^\(2\ I\ T\_1\ \[Sigma]\_2 - 2\ I\ T\_1\ \[Sigma]\_4\)\ 
              \[Pi]\ \[Alpha]\^2\ A\_2\%2\ A\&_\_4 + 
            6\ I\ \[Pi]\^3\ \[Alpha]\ A\_4\%2\ A\&_\_4 + 
            32\/3\ I\ b\^2\ \[Pi]\ \[Alpha]\^2\ A\_4\%2\ A\&_\_4 - 
            \(64\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\ A\_4\%2\ A\&_\_4\)\/\(3 + 
                \[Pi]\^2\)\)}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "We can rewrite ",
  StyleBox["SCond2v",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["SCond2h",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in compact form by collecting the coefficients of the same form as \
follows:"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(collectForm = 
      Table[{A\_i[T\_1, T\_2]\ E\^\(I\ \[Omega]\_i\ T\_0\), 
            A\&_\_i[T\_1, T\_2]\ E\^\(\(-I\)\ \[Omega]\_i\ T\_0\)}, {i, 
            4}] // Flatten; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(cubicTerms = 
      \(Nest[Outer[Times, collectForm, #]\ &, collectForm, 2] // Flatten\) // 
        Union; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(cubicST[i_] := 
      \(\(E\^\(\(-I\)\ \[Omega]\_i\ T\_0\)\ cubicTerms /. expRule1[i]\) /. 
            Exp[_\ T\_0 + _. ] -> 0 // Union\) // Rest\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(moduEq = 
      MapIndexed[
        \((term = cubicST[#2[\([1]\)]]; 
            coef = Coefficient[#1[\([2]\)], term]; #1[\([1]\)] == 
              \((#1[\([2]\)] /. Thread[term -> 0])\) + coef . term)\)\ &, 
        Join[SCond2v, SCond2h]]; \nmoduEq /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          InterpretationBox[\(D\_2\[InvisibleSpace]A\_1\),
            SequenceForm[ 
              Subscript[ D, 2], 
              Subscript[ A, 1]],
            Editable->False], "==", 
          \(\(-\(\(I\ E\^\(I\ T\_1\ \[Sigma]\_1 + I\ \[Tau]\_1\)\ 
                    \(\[Integral]\_0\%1
                        \((P\_1[x] - Cos[2\ \[Pi]\ x]\ P\_1[x])\) 
                        \[DifferentialD]x\)\)\/\(4\ \@6\ \[Pi]\)\)\) - 
            A\_1\ \[Mu]\_1 + 
            \((2\/3\ I\ \[Pi]\^3\ \[Alpha] - 
                  224\/3\ I\ b\^2\ \[Pi]\ \[Alpha]\^2 + 
                  \(256\ I\ b\^2\ \[Pi]\ \[Alpha]\^2\)\/\(3 + \[Pi]\^2\) + 
                  \(64\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\)\/\(9 + 3\ \[Pi]\^2\))
                \)\ A\_1\%2\ A\&_\_1 + 
            E\^\(2\ I\ T\_1\ \[Sigma]\_2\)\ 
              \((2\/3\ I\ \[Pi]\^3\ \[Alpha] - 
                  352\/9\ I\ b\^2\ \[Pi]\ \[Alpha]\^2)\)\ A\_2\%2\ A\&_\_1 + 
            E\^\(2\ I\ T\_1\ \[Sigma]\_4\)\ 
              \((2\/3\ I\ \[Pi]\^3\ \[Alpha] - 
                  352\/9\ I\ b\^2\ \[Pi]\ \[Alpha]\^2)\)\ A\_4\%2\ A\&_\_1 + 
            \((4\/3\ I\ \[Pi]\^3\ \[Alpha] - 
                  256\/9\ I\ b\^2\ \[Pi]\ \[Alpha]\^2 - 
                  \(256\ I\ b\^2\ \[Pi]\ \[Alpha]\^2\)\/\(3 + \[Pi]\^2\) - 
                  \(64\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\)\/\(9 + 3\ \[Pi]\^2\))
                \)\ A\_1\ A\_2\ A\&_\_2 + 
            \((1\/3\ I\ \[Pi]\^3\ \[Alpha] - 
                  4\/3\ I\ b\^2\ \[Pi]\ \[Alpha]\^2 - 
                  \(64\ I\ b\^2\ \[Pi]\ \[Alpha]\^2\)\/\(3 + \[Pi]\^2\) - 
                  \(16\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\)\/\(9 + 3\ \[Pi]\^2\))
                \)\ A\_1\ A\_3\ A\&_\_3 + 
            \((4\/3\ I\ \[Pi]\^3\ \[Alpha] - 
                  256\/9\ I\ b\^2\ \[Pi]\ \[Alpha]\^2 - 
                  \(256\ I\ b\^2\ \[Pi]\ \[Alpha]\^2\)\/\(3 + \[Pi]\^2\) - 
                  \(64\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\)\/\(9 + 3\ \[Pi]\^2\))
                \)\ A\_1\ A\_4\ A\&_\_4\)}], ",", 
        RowBox[{
          InterpretationBox[\(D\_2\[InvisibleSpace]A\_2\),
            SequenceForm[ 
              Subscript[ D, 2], 
              Subscript[ A, 2]],
            Editable->False], "==", 
          \(\(-\(\(I\ 
                    E\^\(I\ T\_1\ \[Sigma]\_1 - I\ T\_1\ \[Sigma]\_2 + 
                        I\ \[Tau]\_1\)\ 
                    \(\[Integral]\_0\%1\( Sin[2\ \[Pi]\ x]\ P\_1[x]\) 
                        \[DifferentialD]x\)\)\/\(4\ \@2\ \[Pi]\)\)\) - 
            A\_2\ \[Mu]\_1 + 
            \((4\/3\ I\ \[Pi]\^3\ \[Alpha] - 
                  1024\/9\ I\ b\^2\ \[Pi]\ \[Alpha]\^2 + 
                  \(64\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\)\/\(3 + \[Pi]\^2\))
                \)\ A\_1\ A\_2\ A\&_\_1 + 
            E\^\(\(-2\)\ I\ T\_1\ \[Sigma]\_2\)\ 
              \((2\/3\ I\ \[Pi]\^3\ \[Alpha] - 
                  352\/9\ I\ b\^2\ \[Pi]\ \[Alpha]\^2)\)\ A\_1\%2\ A\&_\_2 + 
            \((6\ I\ \[Pi]\^3\ \[Alpha] + 
                  32\/3\ I\ b\^2\ \[Pi]\ \[Alpha]\^2 - 
                  \(64\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\)\/\(3 + \[Pi]\^2\))
                \)\ A\_2\%2\ A\&_\_2 + 
            E\^\(\(-2\)\ I\ T\_1\ \[Sigma]\_2 + 2\ I\ T\_1\ \[Sigma]\_4\)\ 
              \((2\ I\ \[Pi]\^3\ \[Alpha] + 
                  32\/3\ I\ b\^2\ \[Pi]\ \[Alpha]\^2)\)\ A\_4\%2\ A\&_\_2 + 
            \((I\ \[Pi]\^3\ \[Alpha] - 
                  \(16\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\)\/\(3 + \[Pi]\^2\))
                \)\ A\_2\ A\_3\ A\&_\_3 + 
            \((4\ I\ \[Pi]\^3\ \[Alpha] - 
                  \(64\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\)\/\(3 + \[Pi]\^2\))
                \)\ A\_2\ A\_4\ A\&_\_4\)}], ",", 
        RowBox[{
          InterpretationBox[\(D\_2\[InvisibleSpace]A\_3\),
            SequenceForm[ 
              Subscript[ D, 2], 
              Subscript[ A, 3]],
            Editable->False], "==", 
          \(\(-A\_3\)\ \[Mu]\_2 + 
            \((2\/3\ I\ \[Pi]\^3\ \[Alpha] - 
                  136\/3\ I\ b\^2\ \[Pi]\ \[Alpha]\^2 + 
                  \(32\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\)\/\(3 + \[Pi]\^2\))
                \)\ A\_1\ A\_3\ A\&_\_1 + 
            \((2\ I\ \[Pi]\^3\ \[Alpha] - 
                  \(32\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\)\/\(3 + \[Pi]\^2\))
                \)\ A\_2\ A\_3\ A\&_\_2 + 
            \((3\/4\ I\ \[Pi]\^3\ \[Alpha] - 
                  4\/3\ I\ b\^2\ \[Pi]\ \[Alpha]\^2 - 
                  \(8\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\)\/\(3 + \[Pi]\^2\))\)\ 
              A\_3\%2\ A\&_\_3 + 
            \((2\ I\ \[Pi]\^3\ \[Alpha] - 
                  \(32\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\)\/\(3 + \[Pi]\^2\))
                \)\ A\_3\ A\_4\ A\&_\_4\)}], ",", 
        RowBox[{
          InterpretationBox[\(D\_2\[InvisibleSpace]A\_4\),
            SequenceForm[ 
              Subscript[ D, 2], 
              Subscript[ A, 4]],
            Editable->False], "==", 
          \(\(-\(\(I\ 
                    E\^\(I\ T\_1\ \[Sigma]\_1 - I\ T\_1\ \[Sigma]\_4 + 
                        I\ \[Tau]\_2\)\ 
                    \(\[Integral]\_0\%1\( Sin[2\ \[Pi]\ x]\ P\_2[x]\) 
                        \[DifferentialD]x\)\)\/\(4\ \@2\ \[Pi]\)\)\) - 
            A\_4\ \[Mu]\_2 + 
            \((4\/3\ I\ \[Pi]\^3\ \[Alpha] - 
                  1024\/9\ I\ b\^2\ \[Pi]\ \[Alpha]\^2 + 
                  \(64\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\)\/\(3 + \[Pi]\^2\))
                \)\ A\_1\ A\_4\ A\&_\_1 + 
            \((4\ I\ \[Pi]\^3\ \[Alpha] - 
                  \(64\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\)\/\(3 + \[Pi]\^2\))
                \)\ A\_2\ A\_4\ A\&_\_2 + 
            \((I\ \[Pi]\^3\ \[Alpha] - 
                  \(16\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\)\/\(3 + \[Pi]\^2\))
                \)\ A\_3\ A\_4\ A\&_\_3 + 
            E\^\(\(-2\)\ I\ T\_1\ \[Sigma]\_4\)\ 
              \((2\/3\ I\ \[Pi]\^3\ \[Alpha] - 
                  352\/9\ I\ b\^2\ \[Pi]\ \[Alpha]\^2)\)\ A\_1\%2\ A\&_\_4 + 
            E\^\(2\ I\ T\_1\ \[Sigma]\_2 - 2\ I\ T\_1\ \[Sigma]\_4\)\ 
              \((2\ I\ \[Pi]\^3\ \[Alpha] + 
                  32\/3\ I\ b\^2\ \[Pi]\ \[Alpha]\^2)\)\ A\_2\%2\ A\&_\_4 + 
            \((6\ I\ \[Pi]\^3\ \[Alpha] + 
                  32\/3\ I\ b\^2\ \[Pi]\ \[Alpha]\^2 - 
                  \(64\ I\ b\^2\ \[Pi]\^3\ \[Alpha]\^2\)\/\(3 + \[Pi]\^2\))
                \)\ A\_4\%2\ A\&_\_4\)}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
These solvability conditions satisfy the symmetry properties because\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(formList = 
      Table[A\_j[T\_1, T\_2]\ 
          Table[A\_i[T\_1, T\_2]\ A\&_\_i[T\_1, T\_2], {i, 4}], {j, 4}]; \n
    formList /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{A\_1\%2\ A\&_\_1, A\_1\ A\_2\ A\&_\_2, A\_1\ A\_3\ A\&_\_3, 
        A\_1\ A\_4\ A\&_\_4}, {A\_1\ A\_2\ A\&_\_1, A\_2\%2\ A\&_\_2, 
        A\_2\ A\_3\ A\&_\_3, A\_2\ A\_4\ A\&_\_4}, {A\_1\ A\_3\ A\&_\_1, 
        A\_2\ A\_3\ A\&_\_2, A\_3\%2\ A\&_\_3, A\_3\ A\_4\ A\&_\_4}, {
        A\_1\ A\_4\ A\&_\_1, A\_2\ A\_4\ A\&_\_2, A\_3\ A\_4\ A\&_\_3, 
        A\_4\%2\ A\&_\_4}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(notationList = Table[s\_\(i, j\), {i, 4}, {j, 4}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{s\_\(1, 1\), s\_\(1, 2\), s\_\(1, 3\), s\_\(1, 4\)}, {s\_\(2, 1\), 
        s\_\(2, 2\), s\_\(2, 3\), s\_\(2, 4\)}, {s\_\(3, 1\), s\_\(3, 2\), 
        s\_\(3, 3\), s\_\(3, 4\)}, {s\_\(4, 1\), s\_\(4, 2\), s\_\(4, 3\), 
        s\_\(4, 4\)}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[BoxData[
    \(\(coefRule = 
      MapThread[
          Rule, {notationList, 
            \(Coefficient[\((2\ \[Omega]\_#\ I)\)\ moduEq[\([#, 2]\)], 
                  formList[\([#]\)]]\ &\)\ /@\ Range[4]}, 2] // Flatten; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(testList = 
      \(\(Table[s\_\(i, j\) - s\_\(j, i\), {i, 4}, {j, i, 4}] // Flatten\) // 
          Union\) // Rest\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({s\_\(1, 2\) - s\_\(2, 1\), s\_\(1, 3\) - s\_\(3, 1\), 
      s\_\(2, 3\) - s\_\(3, 2\), s\_\(1, 4\) - s\_\(4, 1\), 
      s\_\(2, 4\) - s\_\(4, 2\), s\_\(3, 4\) - s\_\(4, 3\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(testList /. coefRule\) /. params // Factor\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({0, 0, 0, 0, 0, 0}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1024}, {0, 712}},
WindowToolbars->{"RulerBar", "EditBar"},
WindowSize->{692, 566},
WindowMargins->{{3, Automatic}, {Automatic, 5}},
PrintingCopies->1,
PrintingStartingPageNumber->297,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Inherited, Cell[ 
        TextData[ {
          ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
        TextData[ {
          ValueBox[ "FileName"]}], "Header"], Inherited, Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"]}},
PrintingOptions->{"FirstPageHeader"->False,
"FacingPages"->True},
Magnification->1
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "ChapterTwo"->{
    Cell[7218, 224, 281, 6, 46, "Section",
      Evaluatable->False,
      CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],
    Cell[123768, 3310, 285, 6, 46, "Section",
      Evaluatable->False,
      CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}]},
  "ChapterTwo.2"->{
    Cell[7218, 224, 281, 6, 46, "Section",
      Evaluatable->False,
      CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],
    Cell[123768, 3310, 285, 6, 46, "Section",
      Evaluatable->False,
      CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}]},
  "ChapterTwo.2.1"->{
    Cell[7218, 224, 281, 6, 46, "Section",
      Evaluatable->False,
      CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],
    Cell[123768, 3310, 285, 6, 46, "Section",
      Evaluatable->False,
      CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"ChapterTwo", 258643, 6988},
  {"ChapterTwo.2", 258939, 6995},
  {"ChapterTwo.2.1", 259237, 7002}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 165, 6, 240, "Title"],
Cell[1899, 59, 860, 15, 128, "Text"],

Cell[CellGroupData[{
Cell[2784, 78, 79, 2, 53, "Section"],
Cell[2866, 82, 118, 3, 30, "Input"],
Cell[2987, 87, 751, 20, 90, "Text"],
Cell[3741, 109, 112, 3, 30, "Input"],
Cell[3856, 114, 456, 15, 22, "Input"],
Cell[4315, 131, 117, 3, 22, "Input"],
Cell[4435, 136, 328, 13, 26, "Text"],
Cell[4766, 151, 206, 6, 22, "Input"],
Cell[4975, 159, 247, 8, 26, "Text"],
Cell[5225, 169, 499, 10, 72, "Input"],
Cell[5727, 181, 213, 6, 40, "Text"],
Cell[5943, 189, 186, 4, 22, "Input"],
Cell[6132, 195, 144, 4, 26, "Text"],
Cell[6279, 201, 902, 18, 107, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7218, 224, 281, 6, 46, "Section",
  Evaluatable->False,
  CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],
Cell[7502, 232, 377, 8, 54, "Text"],
Cell[7882, 242, 2245, 47, 79, "Input"],
Cell[10130, 291, 105, 2, 26, "Text"],
Cell[10238, 295, 710, 20, 22, "Input"],
Cell[10951, 317, 481, 19, 26, "Text"],
Cell[11435, 338, 671, 16, 69, "Text"],
Cell[12109, 356, 209, 5, 22, "Input"],
Cell[12321, 363, 643, 25, 40, "Text"],
Cell[12967, 390, 301, 7, 34, "Input"],
Cell[13271, 399, 315, 12, 26, "Text"],
Cell[13589, 413, 197, 6, 22, "Input"],
Cell[13789, 421, 536, 25, 26, "Text"],
Cell[14328, 448, 223, 5, 40, "Text"],
Cell[14554, 455, 283, 7, 34, "Input"],
Cell[14840, 464, 399, 11, 40, "Text"],
Cell[15242, 477, 146, 4, 22, "Input"],
Cell[15391, 483, 621, 24, 40, "Text"],
Cell[16015, 509, 320, 7, 60, "Input"],
Cell[16338, 518, 135, 3, 26, "Text"],

Cell[CellGroupData[{
Cell[16498, 525, 232, 5, 34, "Input"],
Cell[16733, 532, 28465, 610, 165, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[45235, 1147, 95, 2, 43, "Subsection"],
Cell[45333, 1151, 239, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[45597, 1163, 172, 4, 34, "Input"],
Cell[45772, 1169, 3179, 81, 22, "Output"]
}, Open  ]],
Cell[48966, 1253, 380, 10, 40, "Text"],
Cell[49349, 1265, 421, 9, 35, "Input"],

Cell[CellGroupData[{
Cell[49795, 1278, 238, 5, 34, "Input"],
Cell[50036, 1285, 1409, 28, 57, "Output"]
}, Open  ]],
Cell[51460, 1316, 495, 15, 41, "Text"],

Cell[CellGroupData[{
Cell[51980, 1335, 320, 8, 48, "Input"],
Cell[52303, 1345, 1356, 32, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[53696, 1382, 112, 3, 22, "Input"],
Cell[53811, 1387, 641, 18, 22, "Output"]
}, Open  ]],
Cell[54467, 1408, 189, 5, 26, "Text"],
Cell[54659, 1415, 117, 3, 22, "Input"],
Cell[54779, 1420, 580, 12, 69, "Text"],
Cell[55362, 1434, 365, 7, 41, "Input"],
Cell[55730, 1443, 174, 7, 26, "Text"],

Cell[CellGroupData[{
Cell[55929, 1454, 167, 5, 22, "Input"],
Cell[56099, 1461, 115, 3, 35, "Output"]
}, Open  ]],
Cell[56229, 1467, 381, 16, 26, "Text"],

Cell[CellGroupData[{
Cell[56635, 1487, 127, 3, 22, "Input"],
Cell[56765, 1492, 990, 23, 53, "Output"]
}, Open  ]],
Cell[57770, 1518, 365, 15, 26, "Text"],
Cell[58138, 1535, 170, 5, 22, "Input"],
Cell[58311, 1542, 703, 26, 40, "Text"],

Cell[CellGroupData[{
Cell[59039, 1572, 397, 9, 47, "Input"],
Cell[59439, 1583, 146, 4, 32, "Output"]
}, Open  ]],
Cell[59600, 1590, 120, 2, 26, "Text"],
Cell[59723, 1594, 248, 5, 22, "Input"],
Cell[59974, 1601, 89, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[60088, 1607, 115, 3, 22, "Input"],
Cell[60206, 1612, 213, 5, 22, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[60468, 1623, 96, 2, 43, "Subsection"],
Cell[60567, 1627, 411, 16, 26, "Text"],

Cell[CellGroupData[{
Cell[61003, 1647, 593, 11, 112, "Input"],
Cell[61599, 1660, 10275, 212, 282, "Output"]
}, Open  ]],
Cell[71889, 1875, 280, 9, 26, "Text"],

Cell[CellGroupData[{
Cell[72194, 1888, 226, 6, 22, "Input"],
Cell[72423, 1896, 453, 10, 28, "Output"]
}, Open  ]],
Cell[72891, 1909, 192, 6, 22, "Input"],
Cell[73086, 1917, 232, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[73343, 1929, 214, 5, 34, "Input"],
Cell[73560, 1936, 968, 23, 39, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[74565, 1964, 214, 5, 34, "Input"],
Cell[74782, 1971, 1059, 25, 39, "Output"]
}, Open  ]],
Cell[75856, 1999, 380, 14, 26, "Text"],

Cell[CellGroupData[{
Cell[76261, 2017, 641, 16, 60, "Input"],
Cell[76905, 2035, 499, 13, 32, "Output"]
}, Open  ]],
Cell[77419, 2051, 380, 14, 26, "Text"],

Cell[CellGroupData[{
Cell[77824, 2069, 641, 16, 60, "Input"],
Cell[78468, 2087, 593, 15, 32, "Output"]
}, Open  ]],
Cell[79076, 2105, 104, 2, 26, "Text"],
Cell[79183, 2109, 117, 3, 22, "Input"],
Cell[79303, 2114, 91, 2, 26, "Text"],
Cell[79397, 2118, 120, 3, 22, "Input"],
Cell[79520, 2123, 611, 22, 26, "Text"],

Cell[CellGroupData[{
Cell[80156, 2149, 162, 5, 22, "Input"],
Cell[80321, 2156, 268, 7, 28, "Output"]
}, Open  ]],
Cell[80604, 2166, 179, 5, 22, "Input"],
Cell[80786, 2173, 467, 20, 26, "Text"],

Cell[CellGroupData[{
Cell[81278, 2197, 195, 5, 34, "Input"],
Cell[81476, 2204, 8298, 162, 370, "Output"]
}, Open  ]],
Cell[89789, 2369, 489, 14, 55, "Text"],

Cell[CellGroupData[{
Cell[90303, 2387, 356, 8, 47, "Input"],
Cell[90662, 2397, 1824, 35, 81, "Output"]
}, Open  ]],
Cell[92501, 2435, 726, 20, 55, "Text"],

Cell[CellGroupData[{
Cell[93252, 2459, 336, 8, 47, "Input"],
Cell[93591, 2469, 101, 3, 22, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[93729, 2477, 336, 8, 47, "Input"],
Cell[94068, 2487, 105, 3, 22, "Output"]
}, Open  ]],
Cell[94188, 2493, 404, 14, 40, "Text"],

Cell[CellGroupData[{
Cell[94617, 2511, 155, 4, 22, "Input"],
Cell[94775, 2517, 1153, 23, 57, "Output"]
}, Open  ]],
Cell[95943, 2543, 106, 2, 26, "Text"],
Cell[96052, 2547, 181, 4, 34, "Input"],
Cell[96236, 2553, 223, 8, 26, "Text"],
Cell[96462, 2563, 288, 7, 34, "Input"],
Cell[96753, 2572, 236, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[97014, 2584, 128, 3, 22, "Input"],
Cell[97145, 2589, 219, 5, 22, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[97401, 2599, 128, 3, 22, "Input"],
Cell[97532, 2604, 264, 6, 22, "Output"]
}, Open  ]],
Cell[97811, 2613, 106, 2, 26, "Text"],
Cell[97920, 2617, 216, 5, 34, "Input"],
Cell[98139, 2624, 665, 24, 40, "Text"],
Cell[98807, 2650, 399, 9, 60, "Input"],
Cell[99209, 2661, 401, 16, 26, "Text"],
Cell[99613, 2679, 456, 16, 40, "Text"],
Cell[100072, 2697, 378, 8, 85, "Input"],
Cell[100453, 2707, 421, 16, 26, "Text"],

Cell[CellGroupData[{
Cell[100899, 2727, 244, 6, 34, "Input"],
Cell[101146, 2735, 2666, 49, 259, "Output"]
}, Open  ]],
Cell[103827, 2787, 729, 28, 40, "Text"],

Cell[CellGroupData[{
Cell[104581, 2819, 444, 10, 72, "Input"],
Cell[105028, 2831, 612, 13, 64, "Output"]
}, Open  ]],
Cell[105655, 2847, 299, 12, 26, "Text"],
Cell[105957, 2861, 311, 8, 34, "Input"],

Cell[CellGroupData[{
Cell[106293, 2873, 535, 13, 72, "Input"],
Cell[106831, 2888, 7855, 124, 702, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[114735, 3018, 97, 2, 43, "Subsection"],
Cell[114835, 3022, 497, 20, 26, "Text"],

Cell[CellGroupData[{
Cell[115357, 3046, 509, 10, 86, "Input"],
Cell[115869, 3058, 117, 3, 22, "Output"]
}, Open  ]],
Cell[116001, 3064, 232, 8, 26, "Text"],
Cell[116236, 3074, 244, 6, 34, "Input"],
Cell[116483, 3082, 244, 6, 34, "Input"],
Cell[116730, 3090, 380, 14, 26, "Text"],

Cell[CellGroupData[{
Cell[117135, 3108, 1058, 24, 98, "Input"],
Cell[118196, 3134, 778, 18, 67, "Output"]
}, Open  ]],
Cell[118989, 3155, 380, 14, 26, "Text"],

Cell[CellGroupData[{
Cell[119394, 3173, 1188, 27, 98, "Input"],
Cell[120585, 3202, 875, 19, 68, "Output"]
}, Open  ]],
Cell[121475, 3224, 258, 6, 40, "Text"],
Cell[121736, 3232, 210, 5, 22, "Input"],

Cell[CellGroupData[{
Cell[121971, 3241, 211, 5, 22, "Input"],
Cell[122185, 3248, 300, 7, 35, "Output"]
}, Open  ]],
Cell[122500, 3258, 198, 5, 25, "Input"],

Cell[CellGroupData[{
Cell[122723, 3267, 211, 5, 22, "Input"],
Cell[122937, 3274, 298, 6, 35, "Output"]
}, Open  ]],
Cell[123250, 3283, 187, 7, 26, "Text"],

Cell[CellGroupData[{
Cell[123462, 3294, 160, 4, 22, "Input"],
Cell[123625, 3300, 82, 3, 22, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[123768, 3310, 285, 6, 46, "Section",
  Evaluatable->False,
  CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],
Cell[124056, 3318, 953, 15, 111, "Text"],
Cell[125012, 3335, 134, 3, 22, "Input"],
Cell[125149, 3340, 607, 14, 78, "Input"],

Cell[CellGroupData[{
Cell[125781, 3358, 209, 5, 24, "Input"],
Cell[125993, 3365, 5934, 134, 117, "Output"]
}, Open  ]],
Cell[131942, 3502, 127, 3, 22, "Input"],
Cell[132072, 3507, 119, 2, 26, "Text"],
Cell[132194, 3511, 125, 3, 22, "Input"],
Cell[132322, 3516, 1487, 45, 83, "Text"],
Cell[133812, 3563, 578, 16, 40, "Text"],
Cell[134393, 3581, 197, 4, 22, "Input"],
Cell[134593, 3587, 110, 2, 26, "Text"],
Cell[134706, 3591, 371, 8, 61, "Input"],
Cell[135080, 3601, 266, 6, 40, "Text"],
Cell[135349, 3609, 263, 6, 39, "Input"],
Cell[135615, 3617, 340, 9, 35, "Input"],
Cell[135958, 3628, 160, 5, 26, "Text"],
Cell[136121, 3635, 182, 4, 22, "Input"],
Cell[136306, 3641, 328, 8, 40, "Text"],
Cell[136637, 3651, 468, 9, 69, "Text"],
Cell[137108, 3662, 624, 24, 40, "Text"],
Cell[137735, 3688, 290, 6, 47, "Input"],
Cell[138028, 3696, 229, 8, 26, "Text"],
Cell[138260, 3706, 227, 5, 34, "Input"],

Cell[CellGroupData[{
Cell[138512, 3715, 95, 2, 43, "Subsection"],
Cell[138610, 3719, 117, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[138752, 3725, 157, 4, 22, "Input"],
Cell[138912, 3731, 4120, 105, 34, "Output"]
}, Open  ]],
Cell[143047, 3839, 488, 11, 54, "Text"],
Cell[143538, 3852, 721, 16, 60, "Input"],
Cell[144262, 3870, 266, 7, 34, "Input"],

Cell[CellGroupData[{
Cell[144553, 3881, 105, 3, 22, "Input"],
Cell[144661, 3886, 2082, 42, 105, "Output"]
}, Open  ]],
Cell[146758, 3931, 856, 25, 55, "Text"],
Cell[147617, 3958, 107, 2, 26, "Text"],
Cell[147727, 3962, 192, 5, 22, "Input"],
Cell[147922, 3969, 89, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[148036, 3975, 115, 3, 22, "Input"],
Cell[148154, 3980, 351, 7, 22, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[148554, 3993, 96, 2, 43, "Subsection"],
Cell[148653, 3997, 279, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[148957, 4013, 484, 9, 80, "Input"],
Cell[149444, 4024, 16285, 353, 439, "Output"]
}, Open  ]],
Cell[165744, 4380, 610, 13, 69, "Text"],
Cell[166357, 4395, 403, 8, 34, "Input"],

Cell[CellGroupData[{
Cell[166785, 4407, 226, 6, 22, "Input"],
Cell[167014, 4415, 1705, 35, 80, "Output"]
}, Open  ]],
Cell[168734, 4453, 192, 6, 22, "Input"],
Cell[168929, 4461, 281, 8, 40, "Text"],

Cell[CellGroupData[{
Cell[169235, 4473, 269, 7, 34, "Input"],
Cell[169507, 4482, 5157, 116, 153, "Output"]
}, Open  ]],
Cell[174679, 4601, 183, 5, 26, "Text"],

Cell[CellGroupData[{
Cell[174887, 4610, 269, 7, 34, "Input"],
Cell[175159, 4619, 1766, 42, 50, "Output"]
}, Open  ]],
Cell[176940, 4664, 386, 14, 26, "Text"],

Cell[CellGroupData[{
Cell[177351, 4682, 947, 22, 98, "Input"],
Cell[178301, 4706, 649, 18, 38, "Output"]
}, Open  ]],
Cell[178965, 4727, 388, 14, 26, "Text"],

Cell[CellGroupData[{
Cell[179378, 4745, 957, 22, 86, "Input"],
Cell[180338, 4769, 663, 18, 38, "Output"]
}, Open  ]],
Cell[181016, 4790, 117, 3, 22, "Input"],
Cell[181136, 4795, 91, 2, 26, "Text"],
Cell[181230, 4799, 120, 3, 22, "Input"],
Cell[181353, 4804, 359, 11, 40, "Text"],

Cell[CellGroupData[{
Cell[181737, 4819, 162, 5, 22, "Input"],
Cell[181902, 4826, 427, 9, 28, "Output"]
}, Open  ]],
Cell[182344, 4838, 179, 5, 22, "Input"],
Cell[182526, 4845, 467, 20, 26, "Text"],
Cell[182996, 4867, 153, 4, 22, "Input"],
Cell[183152, 4873, 708, 23, 55, "Text"],
Cell[183863, 4898, 227, 5, 22, "Input"],
Cell[184093, 4905, 144, 4, 26, "Text"],

Cell[CellGroupData[{
Cell[184262, 4913, 205, 5, 22, "Input"],
Cell[184470, 4920, 732, 14, 33, "Output"]
}, Open  ]],
Cell[185217, 4937, 166, 5, 26, "Text"],

Cell[CellGroupData[{
Cell[185408, 4946, 198, 5, 22, "Input"],
Cell[185609, 4953, 680, 14, 33, "Output"]
}, Open  ]],
Cell[186304, 4970, 378, 12, 40, "Text"],

Cell[CellGroupData[{
Cell[186707, 4986, 180, 4, 22, "Input"],
Cell[186890, 4992, 1384, 24, 89, "Output"]
}, Open  ]],
Cell[188289, 5019, 515, 15, 54, "Text"],

Cell[CellGroupData[{
Cell[188829, 5038, 86, 2, 34, "Subsubsection"],
Cell[188918, 5042, 273, 10, 26, "Text"],

Cell[CellGroupData[{
Cell[189216, 5056, 221, 6, 34, "Input"],
Cell[189440, 5064, 641, 12, 33, "Output"]
}, Open  ]],
Cell[190096, 5079, 305, 11, 26, "Text"],
Cell[190404, 5092, 263, 10, 26, "Text"],
Cell[190670, 5104, 192, 4, 34, "Input"],
Cell[190865, 5110, 105, 2, 26, "Text"],
Cell[190973, 5114, 313, 8, 34, "Input"],
Cell[191289, 5124, 426, 16, 26, "Text"],
Cell[191718, 5142, 135, 3, 22, "Input"],

Cell[CellGroupData[{
Cell[191878, 5149, 189, 5, 34, "Input"],
Cell[192070, 5156, 1580, 26, 114, "Output"]
}, Open  ]],
Cell[193665, 5185, 280, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[193970, 5201, 124, 3, 22, "Input"],
Cell[194097, 5206, 1708, 37, 102, "Output"]
}, Open  ]],
Cell[195820, 5246, 518, 20, 26, "Text"],
Cell[196341, 5268, 326, 7, 48, "Input"],

Cell[CellGroupData[{
Cell[196692, 5279, 204, 6, 47, "Input"],
Cell[196899, 5287, 6215, 139, 343, "Output"]
}, Open  ]],
Cell[203129, 5429, 430, 13, 40, "Text"],

Cell[CellGroupData[{
Cell[203584, 5446, 358, 7, 72, "Input"],
Cell[203945, 5455, 3344, 64, 331, "Output"]
}, Open  ]],
Cell[207304, 5522, 323, 12, 26, "Text"],
Cell[207630, 5536, 223, 5, 34, "Input"],

Cell[CellGroupData[{
Cell[207878, 5545, 242, 6, 34, "Input"],
Cell[208123, 5553, 582, 10, 57, "Output"]
}, Open  ]],
Cell[208720, 5566, 581, 19, 40, "Text"],

Cell[CellGroupData[{
Cell[209326, 5589, 738, 17, 124, "Input"],
Cell[210067, 5608, 180, 5, 20, "Message"],
Cell[210250, 5615, 180, 5, 20, "Message"],
Cell[210433, 5622, 3643, 77, 401, "Output"]
}, Open  ]],
Cell[214091, 5702, 157, 5, 26, "Text"],
Cell[214251, 5709, 590, 16, 40, "Text"],

Cell[CellGroupData[{
Cell[214866, 5729, 357, 9, 47, "Input"],
Cell[215226, 5740, 93, 3, 22, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[215356, 5748, 357, 9, 47, "Input"],
Cell[215716, 5759, 93, 3, 22, "Output"]
}, Open  ]],
Cell[215824, 5765, 293, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[216142, 5781, 114, 3, 22, "Input"],
Cell[216259, 5786, 89, 3, 22, "Output"]
}, Open  ]],
Cell[216363, 5792, 938, 31, 54, "Text"],

Cell[CellGroupData[{
Cell[217326, 5827, 452, 9, 60, "Input"],
Cell[217781, 5838, 677, 12, 92, "Output"]
}, Open  ]],
Cell[218473, 5853, 382, 14, 26, "Text"],

Cell[CellGroupData[{
Cell[218880, 5871, 332, 7, 72, "Input"],
Cell[219215, 5880, 209, 6, 34, "Output"]
}, Open  ]],
Cell[219439, 5889, 187, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[219651, 5901, 192, 5, 22, "Input"],
Cell[219846, 5908, 310, 8, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[220193, 5921, 231, 7, 34, "Input"],
Cell[220427, 5930, 320, 8, 28, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[220796, 5944, 88, 2, 34, "Subsubsection"],
Cell[220887, 5948, 589, 16, 40, "Text"],

Cell[CellGroupData[{
Cell[221501, 5968, 337, 8, 47, "Input"],
Cell[221841, 5978, 91, 3, 22, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[221969, 5986, 337, 8, 47, "Input"],
Cell[222309, 5996, 89, 3, 22, "Output"]
}, Open  ]],
Cell[222413, 6002, 454, 14, 40, "Text"],

Cell[CellGroupData[{
Cell[222892, 6020, 118, 3, 22, "Input"],
Cell[223013, 6025, 579, 12, 33, "Output"]
}, Open  ]],
Cell[223607, 6040, 119, 2, 26, "Text"],
Cell[223729, 6044, 192, 4, 34, "Input"],
Cell[223924, 6050, 231, 8, 26, "Text"],
Cell[224158, 6060, 329, 9, 34, "Input"],
Cell[224490, 6071, 223, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[224738, 6083, 129, 3, 22, "Input"],
Cell[224870, 6088, 151, 4, 22, "Output"]
}, Open  ]],
Cell[225036, 6095, 106, 2, 26, "Text"],
Cell[225145, 6099, 150, 4, 22, "Input"],
Cell[225298, 6105, 489, 16, 40, "Text"],
Cell[225790, 6123, 353, 10, 34, "Input"],
Cell[226146, 6135, 410, 16, 26, "Text"],
Cell[226559, 6153, 429, 16, 26, "Text"],
Cell[226991, 6171, 227, 5, 47, "Input"],
Cell[227221, 6178, 289, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[227535, 6194, 166, 5, 22, "Input"],
Cell[227704, 6201, 1352, 26, 128, "Output"]
}, Open  ]],
Cell[229071, 6230, 547, 20, 40, "Text"],

Cell[CellGroupData[{
Cell[229643, 6254, 252, 6, 60, "Input"],
Cell[229898, 6262, 206, 5, 33, "Output"]
}, Open  ]],
Cell[230119, 6270, 469, 20, 26, "Text"],
Cell[230591, 6292, 356, 9, 34, "Input"],

Cell[CellGroupData[{
Cell[230972, 6305, 556, 13, 72, "Input"],
Cell[231531, 6320, 2904, 51, 358, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[234496, 6378, 97, 2, 43, "Subsection"],
Cell[234596, 6382, 457, 20, 26, "Text"],

Cell[CellGroupData[{
Cell[235078, 6406, 662, 12, 105, "Input"],
Cell[235743, 6420, 117, 3, 22, "Output"]
}, Open  ]],
Cell[235875, 6426, 281, 8, 40, "Text"],
Cell[236159, 6436, 247, 6, 22, "Input"],
Cell[236409, 6444, 183, 5, 26, "Text"],
Cell[236595, 6451, 247, 6, 22, "Input"],
Cell[236845, 6459, 386, 14, 26, "Text"],

Cell[CellGroupData[{
Cell[237256, 6477, 1027, 23, 111, "Input"],
Cell[238286, 6502, 4347, 82, 267, "Output"]
}, Open  ]],
Cell[242648, 6587, 388, 14, 26, "Text"],

Cell[CellGroupData[{
Cell[243061, 6605, 1037, 23, 98, "Input"],
Cell[244101, 6630, 3038, 59, 191, "Output"]
}, Open  ]],
Cell[247154, 6692, 351, 13, 26, "Text"],
Cell[247508, 6707, 261, 6, 22, "Input"],
Cell[247772, 6715, 192, 5, 22, "Input"],
Cell[247967, 6722, 226, 5, 22, "Input"],

Cell[CellGroupData[{
Cell[248218, 6731, 347, 8, 47, "Input"],
Cell[248568, 6741, 6453, 126, 391, "Output"]
}, Open  ]],
Cell[255036, 6870, 139, 4, 26, "Text"],

Cell[CellGroupData[{
Cell[255200, 6878, 226, 6, 35, "Input"],
Cell[255429, 6886, 458, 8, 33, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[255924, 6899, 129, 3, 22, "Input"],
Cell[256056, 6904, 324, 6, 22, "Output"]
}, Open  ]],
Cell[256395, 6913, 295, 8, 47, "Input"],

Cell[CellGroupData[{
Cell[256715, 6925, 196, 5, 22, "Input"],
Cell[256914, 6932, 257, 5, 22, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[257208, 6942, 124, 3, 22, "Input"],
Cell[257335, 6947, 99, 3, 22, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

